/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.bootstrapcontext;

import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.XATerminator;
import jakarta.resource.spi.work.HintsContext;
import jakarta.resource.spi.work.SecurityContext;
import jakarta.resource.spi.work.TransactionContext;
import jakarta.resource.spi.work.WorkContext;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import org.jboss.jca.core.api.bootstrap.CloneableBootstrapContext;
import org.jboss.jca.core.api.workmanager.DistributableContext;
import org.jboss.jca.core.api.workmanager.WorkManager;
import org.jboss.jca.core.workmanager.WorkManagerCoordinator;

public class BaseCloneableBootstrapContext
implements CloneableBootstrapContext {
    private TransactionSynchronizationRegistry transactionSynchronizationRegistry = null;
    private WorkManager workManager = null;
    private String workManagerName = null;
    private XATerminator xaTerminator = null;
    private Set<Class> supportedContexts = new HashSet<Class>(4);
    private List<Timer> timers;
    private String id;
    private String name;

    public BaseCloneableBootstrapContext() {
        this.supportedContexts.add(HintsContext.class);
        this.supportedContexts.add(SecurityContext.class);
        this.supportedContexts.add(TransactionContext.class);
        this.supportedContexts.add(DistributableContext.class);
        this.timers = null;
        this.id = null;
        this.name = null;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String v) {
        this.id = v;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String v) {
        this.name = v;
    }

    public void setResourceAdapter(ResourceAdapter ra) {
        if (this.workManager != null) {
            this.workManager.setResourceAdapter(ra);
        }
    }

    public TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return this.transactionSynchronizationRegistry;
    }

    public void setTransactionSynchronizationRegistry(TransactionSynchronizationRegistry tsr) {
        this.transactionSynchronizationRegistry = tsr;
    }

    public WorkManager getWorkManager() {
        if (this.workManager == null) {
            this.workManager = WorkManagerCoordinator.getInstance().createWorkManager(this.id, this.workManagerName);
        }
        return this.workManager;
    }

    public void setWorkManager(WorkManager wm) {
        this.workManager = wm;
    }

    public String getWorkManagerName() {
        return this.workManagerName;
    }

    public void setWorkManagerName(String wmn) {
        this.workManagerName = wmn;
    }

    public XATerminator getXATerminator() {
        return this.xaTerminator;
    }

    public void setXATerminator(XATerminator xt) {
        this.xaTerminator = xt;
    }

    public Timer createTimer() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.name);
            if (this.id != null) {
                sb.append(":");
            }
        }
        if (this.id != null) {
            sb.append(this.id);
        }
        Timer t = null;
        t = sb.length() > 0 ? new Timer(sb.toString(), true) : new Timer(true);
        if (this.timers == null) {
            this.timers = new ArrayList<Timer>();
        }
        this.timers.add(t);
        return t;
    }

    public boolean isContextSupported(Class<? extends WorkContext> workContextClass) {
        if (workContextClass == null) {
            return false;
        }
        return this.supportedContexts.contains(workContextClass);
    }

    public void shutdown() {
        if (this.timers != null) {
            for (Timer t : this.timers) {
                t.cancel();
                t.purge();
            }
        }
    }

    public CloneableBootstrapContext clone() throws CloneNotSupportedException {
        BaseCloneableBootstrapContext bcbc = (BaseCloneableBootstrapContext)super.clone();
        bcbc.setTransactionSynchronizationRegistry(this.getTransactionSynchronizationRegistry());
        bcbc.setXATerminator(this.getXATerminator());
        bcbc.setName(this.getName());
        bcbc.setWorkManagerName(this.getWorkManagerName());
        return bcbc;
    }
}

