/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.jaspi.impl;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.wildfly.common.Assert;
import org.wildfly.security.auth.jaspi.impl.ThreadLocalCallbackHandler;
import org.wildfly.security.auth.jaspi.impl.WrappingServerAuthContext;

class WrappingServerAuthConfig
implements ServerAuthConfig {
    private final ThreadLocalCallbackHandler threadLocalHandler;
    private final CallbackHandler realHandler;
    private final ServerAuthConfig delegate;

    WrappingServerAuthConfig(ThreadLocalCallbackHandler threadLocalHandler, CallbackHandler realHandler, ServerAuthConfig delegate) {
        this.threadLocalHandler = (ThreadLocalCallbackHandler)Assert.checkNotNullParam((String)"threadLocalHandler", (Object)threadLocalHandler);
        this.realHandler = (CallbackHandler)Assert.checkNotNullParam((String)"realHandler", (Object)realHandler);
        this.delegate = (ServerAuthConfig)Assert.checkNotNullParam((String)"delegate", (Object)delegate);
    }

    public String getMessageLayer() {
        return (String)this.threadLocalHandler.get(() -> ((ServerAuthConfig)this.delegate).getMessageLayer(), this.realHandler);
    }

    public String getAppContext() {
        return (String)this.threadLocalHandler.get(() -> ((ServerAuthConfig)this.delegate).getAppContext(), this.realHandler);
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        return (String)this.threadLocalHandler.get(() -> this.delegate.getAuthContextID(messageInfo), this.realHandler);
    }

    public void refresh() {
        this.threadLocalHandler.run(() -> ((ServerAuthConfig)this.delegate).refresh(), this.realHandler);
    }

    public boolean isProtected() {
        return (Boolean)this.threadLocalHandler.get(() -> ((ServerAuthConfig)this.delegate).isProtected(), this.realHandler);
    }

    public ServerAuthContext getAuthContext(String authContextID, Subject serviceSubject, Map properties) throws AuthException {
        ServerAuthContext serverAuthContext = (ServerAuthContext)this.threadLocalHandler.get(() -> this.delegate.getAuthContext(authContextID, serviceSubject, properties), this.realHandler);
        return serverAuthContext != null ? new WrappingServerAuthContext(this.threadLocalHandler, this.realHandler, serverAuthContext) : null;
    }

    static ServerAuthConfig getServerAuthConfig(AuthConfigProvider authConfigProvider, String layer, String appContext, CallbackHandler realCallbackHandler) throws AuthException {
        ThreadLocalCallbackHandler threadLocalHandler = ThreadLocalCallbackHandler.getInstance();
        ServerAuthConfig serverAuthConfig = (ServerAuthConfig)threadLocalHandler.get(() -> authConfigProvider.getServerAuthConfig(layer, appContext, (CallbackHandler)threadLocalHandler), realCallbackHandler);
        Assert.assertNotNull((Object)serverAuthConfig);
        return new WrappingServerAuthConfig(threadLocalHandler, realCallbackHandler, serverAuthConfig);
    }
}

