/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfiguration;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.server.service.CacheContainerServiceInstallerProvider;
import org.wildfly.clustering.server.service.ProvidedBiServiceInstallerProvider;
import org.wildfly.clustering.server.util.MapEntry;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class NoTransportResourceDefinition
extends TransportResourceDefinition {
    static final PathElement PATH = NoTransportResourceDefinition.pathElement("none");

    NoTransportResourceDefinition() {
        super(PATH, UnaryOperator.identity());
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        PathAddress containerAddress = address.getParent();
        String containerName = containerAddress.getLastElement().getValue();
        LinkedList<ResourceServiceInstaller> installers = new LinkedList<ResourceServiceInstaller>();
        final ServiceDependency environment = ServiceDependency.on((NullaryServiceDescriptor)ServerEnvironment.SERVICE_DESCRIPTOR);
        Supplier<TransportConfiguration> configurationFactory = new Supplier<TransportConfiguration>(){

            @Override
            public TransportConfiguration get() {
                return new GlobalConfigurationBuilder().transport().transport(null).clusterName("local").nodeName(((ServerEnvironment)environment.get()).getNodeName()).create();
            }
        };
        installers.add((ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder((RuntimeCapability)CAPABILITY, (Supplier)configurationFactory).requires((Consumer)environment)).build());
        new ProvidedBiServiceInstallerProvider(CacheContainerServiceInstallerProvider.class, CacheContainerServiceInstallerProvider.class.getClassLoader()).apply(context.getCapabilityServiceSupport(), (Map.Entry)MapEntry.of((Object)containerName, (Object)"local")).forEach(installers::add);
        return ResourceServiceInstaller.combine(installers);
    }
}

