/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.DeploymentUtils;
import org.jboss.as.server.deployment.Services;
import org.jboss.as.server.deployment.module.AdditionalModuleSpecification;
import org.jboss.as.server.deployment.module.ExtensionListEntry;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.logging.ServerLogger;
import org.jboss.as.server.moduleservice.ExtensionIndex;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public final class ModuleExtensionListProcessor
implements DeploymentUnitProcessor {
    @Override
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        ModuleIdentifier extension;
        AttachmentList<ExtensionListEntry> entries;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        ModuleLoader moduleLoader = deploymentUnit.getAttachment(Attachments.SERVICE_MODULE_LOADER);
        ServiceController controller = phaseContext.getServiceRegistry().getRequiredService(Services.JBOSS_DEPLOYMENT_EXTENSION_INDEX);
        ExtensionIndex index = (ExtensionIndex)controller.getValue();
        List<ResourceRoot> allResourceRoots = DeploymentUtils.allResourceRoots(deploymentUnit);
        HashSet<ServiceName> nextPhaseDeps = new HashSet<ServiceName>();
        LinkedHashSet<ModuleIdentifier> allExtensionListEntries = new LinkedHashSet<ModuleIdentifier>();
        for (ResourceRoot resourceRoot : allResourceRoots) {
            entries = resourceRoot.getAttachment(Attachments.EXTENSION_LIST_ENTRIES);
            if (entries == null) continue;
            for (ExtensionListEntry entry : entries) {
                extension = index.findExtension(entry.getName(), entry.getSpecificationVersion(), entry.getImplementationVersion(), entry.getImplementationVendorId());
                if (extension != null) {
                    allExtensionListEntries.add(extension);
                    continue;
                }
                ServerLogger.DEPLOYMENT_LOGGER.cannotFindExtensionListEntry(entry, resourceRoot);
            }
        }
        if (deploymentUnit.getParent() != null) {
            for (ResourceRoot resourceRoot : DeploymentUtils.allResourceRoots(deploymentUnit.getParent())) {
                entries = resourceRoot.getAttachment(Attachments.EXTENSION_LIST_ENTRIES);
                if (entries == null) continue;
                for (ExtensionListEntry entry : entries) {
                    extension = index.findExtension(entry.getName(), entry.getSpecificationVersion(), entry.getImplementationVersion(), entry.getImplementationVendorId());
                    if (extension == null) continue;
                    allExtensionListEntries.add(extension);
                }
            }
        }
        for (ModuleIdentifier extension2 : allExtensionListEntries) {
            ModuleDependency dependency = new ModuleDependency(moduleLoader, extension2, false, false, true, true);
            dependency.addImportFilter(PathFilters.getMetaInfSubdirectoriesFilter(), true);
            dependency.addImportFilter(PathFilters.getMetaInfFilter(), true);
            moduleSpecification.addLocalDependency(dependency);
            nextPhaseDeps.add(ServiceModuleLoader.moduleSpecServiceName(extension2.toString()));
        }
        List additionalModules = deploymentUnit.getAttachment(Attachments.ADDITIONAL_MODULES);
        if (additionalModules != null) {
            for (AdditionalModuleSpecification additionalModule : additionalModules) {
                for (ResourceRoot resourceRoot : additionalModule.getResourceRoots()) {
                    AttachmentList<ExtensionListEntry> entries2 = resourceRoot.getAttachment(Attachments.EXTENSION_LIST_ENTRIES);
                    if (entries2 == null) continue;
                    for (ExtensionListEntry entry : entries2) {
                        ModuleIdentifier extension3 = index.findExtension(entry.getName(), entry.getSpecificationVersion(), entry.getImplementationVersion(), entry.getImplementationVendorId());
                        if (extension3 != null) {
                            moduleSpecification.addLocalDependency(new ModuleDependency(moduleLoader, extension3, false, false, true, false));
                            nextPhaseDeps.add(ServiceModuleLoader.moduleSpecServiceName(extension3.toString()));
                            continue;
                        }
                        ServerLogger.DEPLOYMENT_LOGGER.cannotFindExtensionListEntry(entry, resourceRoot);
                    }
                }
            }
        }
        for (ServiceName dep : nextPhaseDeps) {
            phaseContext.addToAttachmentList(Attachments.NEXT_PHASE_DEPS, dep);
        }
    }
}

