/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.protostream.ProtobufTagMarshaller;
import org.wildfly.clustering.marshalling.protostream.DefaultProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.DefaultProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.EnumMarshaller;
import org.wildfly.clustering.marshalling.protostream.Marshallable;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamSizeOperation;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.common.function.Functions;

public interface ProtoStreamMarshaller<T>
extends ProtobufTagMarshaller<T>,
Marshallable<T> {
    default public String getTypeName() {
        Class targetClass = this.getJavaClass();
        Package targetPackage = targetClass.getPackage();
        return targetPackage != null ? targetPackage.getName() + "." + targetClass.getSimpleName() : targetClass.getSimpleName();
    }

    default public T read(ProtobufTagMarshaller.ReadContext context) throws IOException {
        return (T)this.readFrom(new DefaultProtoStreamReader(context));
    }

    default public void write(ProtobufTagMarshaller.WriteContext context, T value) throws IOException {
        this.writeTo(new DefaultProtoStreamWriter(context), value);
    }

    default public <V extends T> ProtoStreamMarshaller<V> wrap(Class<? extends V> type, Function<T, V> wrapper) {
        return this.wrap(type, Functions.cast(Function.identity()), wrapper);
    }

    default public <V> ProtoStreamMarshaller<V> wrap(final Class<? extends V> type, final Function<V, T> unwrapper, final Function<T, V> wrapper) {
        final ProtoStreamMarshaller marshaller = this;
        return new ProtoStreamMarshaller<V>(){

            @Override
            public Class<? extends V> getJavaClass() {
                return type;
            }

            @Override
            public V readFrom(ProtoStreamReader reader) throws IOException {
                return wrapper.apply(marshaller.readFrom(reader));
            }

            @Override
            public void writeTo(ProtoStreamWriter writer, V value) throws IOException {
                marshaller.writeTo(writer, unwrapper.apply(value));
            }

            @Override
            public OptionalInt size(ProtoStreamSizeOperation operation, V value) {
                return marshaller.size(operation, unwrapper.apply(value));
            }
        };
    }

    public static <T> ProtoStreamMarshaller<T> of(T value) {
        return ProtoStreamMarshaller.of(Functions.constantSupplier(value));
    }

    public static <T> ProtoStreamMarshaller<T> of(final Supplier<T> factory) {
        return new ProtoStreamMarshaller<T>(){

            @Override
            public Class<? extends T> getJavaClass() {
                return factory.get().getClass();
            }

            @Override
            public T readFrom(ProtoStreamReader reader) throws IOException {
                return factory.get();
            }

            @Override
            public void writeTo(ProtoStreamWriter writer, T value) throws IOException {
            }

            @Override
            public OptionalInt size(ProtoStreamSizeOperation operation, T value) {
                return OptionalInt.of(0);
            }
        };
    }

    public static <E extends Enum<E>> ProtoStreamMarshaller<E> of(Class<E> enumClass) {
        return new EnumMarshaller<E>(enumClass);
    }
}

