/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jpa.processor;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.persistence.spi.PersistenceProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.jboss.as.controller.ModuleIdentifierUtil;
import org.jboss.as.jpa.messages.JpaLogger;
import org.jboss.as.jpa.transaction.JtaManagerImpl;
import org.jboss.jandex.Index;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jipijapa.plugin.spi.JtaManager;
import org.jipijapa.plugin.spi.ManagementAdaptor;
import org.jipijapa.plugin.spi.PersistenceProviderAdaptor;
import org.jipijapa.plugin.spi.PersistenceProviderIntegratorAdaptor;
import org.jipijapa.plugin.spi.PersistenceUnitMetadata;
import org.jipijapa.plugin.spi.Platform;

public class PersistenceProviderAdaptorLoader {
    private static final PersistenceProviderAdaptor noopAdaptor = new PersistenceProviderAdaptor(){

        public void injectJtaManager(JtaManager jtaManager) {
        }

        public void injectPlatform(Platform platform) {
        }

        public void addProviderProperties(Map properties, PersistenceUnitMetadata pu) {
        }

        public void addProviderDependencies(PersistenceUnitMetadata pu) {
        }

        public void beforeCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        }

        public void afterCreateContainerEntityManagerFactory(PersistenceUnitMetadata pu) {
        }

        public ManagementAdaptor getManagementAdaptor() {
            return null;
        }

        public boolean doesScopedPersistenceUnitNameIdentifyCacheRegionName(PersistenceUnitMetadata pu) {
            return true;
        }

        public void cleanup(PersistenceUnitMetadata pu) {
        }

        public Object beanManagerLifeCycle(BeanManager beanManager) {
            return null;
        }

        public void markPersistenceUnitAvailable(Object wrapperBeanManagerLifeCycle) {
        }
    };

    public static PersistenceProviderAdaptor loadPersistenceAdapterModule(String adapterModule, Platform platform, JtaManagerImpl manager) throws ModuleLoadException {
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        if (adapterModule == null) {
            return noopAdaptor;
        }
        PersistenceProviderAdaptor persistenceProviderAdaptor = null;
        Module module = moduleLoader.loadModule(adapterModule = ModuleIdentifierUtil.canonicalModuleIdentifier((String)adapterModule));
        ServiceLoader serviceLoader = module.loadService(PersistenceProviderAdaptor.class);
        if (serviceLoader != null) {
            for (PersistenceProviderAdaptor adaptor : serviceLoader) {
                if (persistenceProviderAdaptor != null) {
                    throw JpaLogger.ROOT_LOGGER.multipleAdapters(adapterModule);
                }
                persistenceProviderAdaptor = adaptor;
                JpaLogger.ROOT_LOGGER.debugf("loaded persistence provider adapter %s", adapterModule);
            }
            if (persistenceProviderAdaptor != null) {
                persistenceProviderAdaptor.injectJtaManager((JtaManager)manager);
                persistenceProviderAdaptor.injectPlatform(platform);
            }
        }
        return persistenceProviderAdaptor;
    }

    public static PersistenceProviderAdaptor loadPersistenceAdapter(PersistenceProvider persistenceProvider, Platform platform, JtaManagerImpl jtaManager) {
        PersistenceProviderAdaptor persistenceProviderAdaptor = null;
        ServiceLoader<PersistenceProviderAdaptor> serviceLoader = ServiceLoader.load(PersistenceProviderAdaptor.class, persistenceProvider.getClass().getClassLoader());
        if (serviceLoader != null) {
            for (PersistenceProviderAdaptor adaptor : serviceLoader) {
                if (persistenceProviderAdaptor != null) {
                    throw JpaLogger.ROOT_LOGGER.classloaderHasMultipleAdapters(persistenceProvider.getClass().getClassLoader().toString());
                }
                persistenceProviderAdaptor = adaptor;
                JpaLogger.ROOT_LOGGER.debugf("loaded persistence provider adapter %s from classloader %s", persistenceProviderAdaptor.getClass().getName(), persistenceProvider.getClass().getClassLoader().toString());
            }
            if (persistenceProviderAdaptor != null) {
                persistenceProviderAdaptor.injectJtaManager((JtaManager)jtaManager);
                persistenceProviderAdaptor.injectPlatform(platform);
            }
        }
        return persistenceProviderAdaptor == null ? noopAdaptor : persistenceProviderAdaptor;
    }

    public static List<PersistenceProviderIntegratorAdaptor> loadPersistenceProviderIntegratorModule(String adapterModule, Collection<Index> indexes) throws ModuleLoadException {
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ArrayList<PersistenceProviderIntegratorAdaptor> persistenceProviderAdaptors = new ArrayList<PersistenceProviderIntegratorAdaptor>();
        adapterModule = ModuleIdentifierUtil.canonicalModuleIdentifier((String)adapterModule);
        Module module = moduleLoader.loadModule(adapterModule);
        ServiceLoader serviceLoader = module.loadService(PersistenceProviderIntegratorAdaptor.class);
        for (PersistenceProviderIntegratorAdaptor adaptor : serviceLoader) {
            persistenceProviderAdaptors.add(adaptor);
            JpaLogger.ROOT_LOGGER.debugf("loaded persistence provider integrator adapter %s from %s", adaptor, adapterModule);
            if (adaptor == null) continue;
            adaptor.injectIndexes(indexes);
        }
        return persistenceProviderAdaptors;
    }
}

