/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.spi;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.hibernate.search.mapper.pojo.model.spi.AbstractPojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;
import org.hibernate.search.util.common.reflect.impl.GenericTypeContext;

public final class GenericContextAwarePojoGenericTypeModel<T>
extends AbstractPojoGenericTypeModel<T>
implements PojoTypeModel<T> {
    private final Helper helper;
    private final GenericTypeContext genericTypeContext;
    private final Map<Object, PojoPropertyModel<?>> genericPropertyCache = new HashMap();

    private static Optional<PojoTypeModel<?>> typeArgument(Helper helper, GenericTypeContext selfTypeContext, Class<?> rawSuperType, int typeParameterIndex) {
        return selfTypeContext.resolveTypeArgument(rawSuperType, typeParameterIndex).map(type -> new GenericContextAwarePojoGenericTypeModel(helper, new GenericTypeContext(selfTypeContext.declaringContext(), type)));
    }

    private static Optional<PojoTypeModel<?>> arrayElementType(Helper helper, GenericTypeContext selfTypeContext) {
        return selfTypeContext.resolveArrayElementType().map(type -> new GenericContextAwarePojoGenericTypeModel(helper, new GenericTypeContext(selfTypeContext.declaringContext(), type)));
    }

    private GenericContextAwarePojoGenericTypeModel(Helper helper, GenericTypeContext genericTypeContext) {
        super(helper.rawTypeModel(genericTypeContext.rawType()));
        this.helper = helper;
        this.genericTypeContext = genericTypeContext;
    }

    @Override
    public String name() {
        return this.genericTypeContext.name();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenericContextAwarePojoGenericTypeModel that = (GenericContextAwarePojoGenericTypeModel)o;
        return Objects.equals(this.genericTypeContext, that.genericTypeContext);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.genericTypeContext);
    }

    @Override
    public PojoPropertyModel<?> property(String propertyName) {
        return this.wrapProperty(super.property(propertyName));
    }

    @Override
    public <U> Optional<PojoTypeModel<? extends U>> castTo(Class<U> target) {
        return Optional.of(new GenericContextAwarePojoGenericTypeModel<T>(this.helper, this.genericTypeContext.castTo(target)));
    }

    @Override
    public Optional<PojoTypeModel<?>> typeArgument(Class<?> rawSuperType, int typeParameterIndex) {
        return GenericContextAwarePojoGenericTypeModel.typeArgument(this.helper, this.genericTypeContext, rawSuperType, typeParameterIndex);
    }

    @Override
    public Optional<PojoTypeModel<?>> arrayElementType() {
        return GenericContextAwarePojoGenericTypeModel.arrayElementType(this.helper, this.genericTypeContext);
    }

    private <U> PojoPropertyModel<? extends U> wrapProperty(PojoPropertyModel<U> rawPropertyModel) {
        Object cacheKey = this.helper.propertyCacheKey(rawPropertyModel);
        PojoPropertyModel<?> cached = this.genericPropertyCache.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        Type propertyType = this.helper.propertyGenericType(rawPropertyModel);
        GenericTypeContext propertyGenericTypeContext = new GenericTypeContext(this.genericTypeContext, propertyType);
        GenericContextAwarePojoGenericTypeModel<T> genericPropertyTypeModel = new GenericContextAwarePojoGenericTypeModel<T>(this.helper, propertyGenericTypeContext);
        GenericContextAwarePojoPropertyModel<U> propertyModel = new GenericContextAwarePojoPropertyModel<U>(rawPropertyModel, genericPropertyTypeModel);
        this.genericPropertyCache.put(cacheKey, propertyModel);
        return propertyModel;
    }

    public static interface Helper {
        public <T> PojoRawTypeModel<T> rawTypeModel(Class<T> var1);

        public Object propertyCacheKey(PojoPropertyModel<?> var1);

        public Type propertyGenericType(PojoPropertyModel<?> var1);
    }

    public static class RawTypeDeclaringContext<T> {
        private final Helper helper;
        private final GenericTypeContext genericTypeContext;

        public RawTypeDeclaringContext(Helper helper, Class<T> rawType) {
            this.helper = helper;
            this.genericTypeContext = new GenericTypeContext(rawType);
        }

        public Optional<PojoTypeModel<?>> typeArgument(Class<?> rawSuperType, int typeParameterIndex) {
            return GenericContextAwarePojoGenericTypeModel.typeArgument(this.helper, this.genericTypeContext, rawSuperType, typeParameterIndex);
        }

        public Optional<PojoTypeModel<?>> arrayElementType() {
            return GenericContextAwarePojoGenericTypeModel.arrayElementType(this.helper, this.genericTypeContext);
        }

        public PojoTypeModel<?> memberTypeReference(Type declaredType) {
            return new GenericContextAwarePojoGenericTypeModel(this.helper, new GenericTypeContext(this.genericTypeContext, declaredType));
        }
    }
}

