/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.faces.component;

import jakarta.faces.component.StateHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.function.Supplier;
import org.wildfly.clustering.marshalling.protostream.AbstractSerializationContextInitializer;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.SerializationContext;
import org.wildfly.clustering.marshalling.protostream.reflect.FieldMarshaller;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ComponentSerializationContextInitializer
extends AbstractSerializationContextInitializer {
    public ComponentSerializationContextInitializer() {
        super("jakarta.faces.component.proto");
    }

    public void registerMarshallers(SerializationContext context) {
        ComponentSerializationContextInitializer.registerMarshaller(context, UIComponent.class, "PropertyKeys");
        ComponentSerializationContextInitializer.registerMarshaller(context, UIComponent.class, "PropertyKeysPrivate");
        Map.Entry<Class<? extends Object>, Supplier<Object>> entry = ComponentSerializationContextInitializer.findClass("jakarta.faces.component.StateHolderSaver", FacesContext.class, Object.class);
        context.registerMarshaller((ProtoStreamMarshaller)new FieldMarshaller(entry.getKey(), entry.getValue(), new Class[]{String.class, Serializable.class}));
    }

    private static <E extends Enum<E>> void registerMarshaller(SerializationContext context, Class<?> parentClass, String enumName) {
        Class<E> enumClass = ComponentSerializationContextInitializer.findEnumClass(parentClass, enumName);
        context.registerMarshaller(ProtoStreamMarshaller.of(enumClass));
    }

    private static <E extends Enum<E>> Class<E> findEnumClass(Class<?> parentClass, String enumName) {
        try {
            return WildFlySecurityManager.getClassLoaderPrivileged(parentClass).loadClass(parentClass.getName() + "$" + enumName).asSubclass(Enum.class);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Map.Entry<Class<? extends Object>, Supplier<Object>> findClass(String className, Class<?> ... constructorParameterTypes) {
        try {
            Class<?> targetClass = WildFlySecurityManager.getClassLoaderPrivileged(StateHolder.class).loadClass(className);
            PrivilegedAction<Object> action = () -> {
                try {
                    Constructor constructor = targetClass.getDeclaredConstructor(constructorParameterTypes);
                    constructor.setAccessible(true);
                    return constructor.newInstance(null, null);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalStateException(e);
                }
            };
            return Map.entry(targetClass, () -> WildFlySecurityManager.doUnchecked((PrivilegedAction)action));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }
}

