/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.session;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionListeners;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.ThreadSetupHandler;
import jakarta.servlet.ServletContext;
import java.time.Duration;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.wildfly.clustering.cache.batch.BatchContextualizerFactory;
import org.wildfly.clustering.context.Contextualizer;
import org.wildfly.clustering.context.ContextualizerFactory;
import org.wildfly.clustering.session.ImmutableSession;
import org.wildfly.clustering.session.SessionManagerConfiguration;
import org.wildfly.clustering.session.SessionManagerFactory;
import org.wildfly.clustering.web.container.SessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.undertow.IdentifierFactoryAdapter;
import org.wildfly.clustering.web.undertow.session.DistributableInactiveSessionStatistics;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManager;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerConfiguration;
import org.wildfly.clustering.web.undertow.session.DistributableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.RecordableSessionManagerStatistics;
import org.wildfly.clustering.web.undertow.session.UndertowSessionExpirationListener;
import org.wildfly.common.function.ExceptionBiFunction;

public class DistributableSessionManagerFactory
implements io.undertow.servlet.api.SessionManagerFactory {
    private static final ContextualizerFactory BATCH_CONTEXTUALIZER_FACTORY = (ContextualizerFactory)ServiceLoader.load(BatchContextualizerFactory.class, BatchContextualizerFactory.class.getClassLoader()).findFirst().orElseThrow();
    private final SessionManagerFactory<ServletContext, Map<String, Object>> factory;
    private final SessionManagerFactoryConfiguration config;

    public DistributableSessionManagerFactory(SessionManagerFactory<ServletContext, Map<String, Object>> factory, SessionManagerFactoryConfiguration config) {
        this.factory = factory;
        this.config = config;
    }

    public SessionManager createSessionManager(final Deployment deployment) {
        final DeploymentInfo info = deployment.getDeploymentInfo();
        boolean statisticsEnabled = info.getMetricsCollector() != null;
        DistributableInactiveSessionStatistics inactiveSessionStatistics = statisticsEnabled ? new DistributableInactiveSessionStatistics() : null;
        final IdentifierFactoryAdapter factory = new IdentifierFactoryAdapter(info.getSessionIdGenerator());
        final SessionListeners listeners = new SessionListeners();
        final UndertowSessionExpirationListener expirationListener = new UndertowSessionExpirationListener(deployment, listeners, inactiveSessionStatistics);
        SessionManagerConfiguration<ServletContext> configuration = new SessionManagerConfiguration<ServletContext>(){

            public ServletContext getContext() {
                return deployment.getServletContext();
            }

            public Supplier<String> getIdentifierFactory() {
                return factory;
            }

            public Consumer<ImmutableSession> getExpirationListener() {
                return expirationListener;
            }

            public Duration getTimeout() {
                return Duration.ofMinutes(this.getContext().getSessionTimeout());
            }
        };
        final org.wildfly.clustering.session.SessionManager manager = this.factory.createSessionManager((SessionManagerConfiguration)configuration);
        final Contextualizer contextualizer = BATCH_CONTEXTUALIZER_FACTORY.createContextualizer(deployment.getServletContext().getClassLoader());
        info.addThreadSetupAction(new ThreadSetupHandler(){

            public <T, C> ThreadSetupHandler.Action<T, C> create(ThreadSetupHandler.Action<T, C> action) {
                ExceptionBiFunction actionCaller = (arg_0, arg_1) -> action.call(arg_0, arg_1);
                final ExceptionBiFunction contextualActionCaller = contextualizer.contextualize(actionCaller);
                return new ThreadSetupHandler.Action<T, C>(){

                    public T call(HttpServerExchange exchange, C context) throws Exception {
                        return contextualActionCaller.apply((Object)exchange, context);
                    }
                };
            }
        });
        final DistributableSessionManagerStatistics statistics = inactiveSessionStatistics != null ? new DistributableSessionManagerStatistics(manager.getStatistics(), inactiveSessionStatistics, this.config.getMaxActiveSessions()) : null;
        DistributableSessionManager result = new DistributableSessionManager(new DistributableSessionManagerConfiguration(){

            @Override
            public String getDeploymentName() {
                return info.getDeploymentName();
            }

            @Override
            public org.wildfly.clustering.session.SessionManager<Map<String, Object>> getSessionManager() {
                return manager;
            }

            @Override
            public SessionListeners getSessionListeners() {
                return listeners;
            }

            @Override
            public RecordableSessionManagerStatistics getStatistics() {
                return statistics;
            }
        });
        result.setDefaultSessionTimeout((int)this.config.getDefaultSessionTimeout().getSeconds());
        return result;
    }
}

