/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.BroadcastGroupConfiguration;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredAddStepHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.wildfly.extension.messaging.activemq.AddIfAbsentStepHandler;
import org.wildfly.extension.messaging.activemq.BroadcastGroupAdd;
import org.wildfly.extension.messaging.activemq.BroadcastGroupDefinition;
import org.wildfly.extension.messaging.activemq.BroadcastGroupWriteAttributeHandler;
import org.wildfly.extension.messaging.activemq.CommonAttributes;
import org.wildfly.extension.messaging.activemq.JGroupsBroadcastGroupDefinition;
import org.wildfly.extension.messaging.activemq._private.MessagingLogger;
import org.wildfly.extension.messaging.activemq.broadcast.BroadcastCommandDispatcherFactory;
import org.wildfly.extension.messaging.activemq.broadcast.CommandDispatcherBroadcastEndpointFactory;

public class JGroupsBroadcastGroupAdd
extends ReloadRequiredAddStepHandler {
    public static final JGroupsBroadcastGroupAdd INSTANCE = new JGroupsBroadcastGroupAdd(true);
    public static final JGroupsBroadcastGroupAdd LEGACY_INSTANCE = new JGroupsBroadcastGroupAdd(false);
    private final boolean needLegacyCall;

    private JGroupsBroadcastGroupAdd(boolean needLegacyCall) {
        super(JGroupsBroadcastGroupDefinition.ATTRIBUTES);
        this.needLegacyCall = needLegacyCall;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        CommonAttributes.renameChannelToCluster(operation);
        if (operation.hasDefined(CommonAttributes.JGROUPS_CLUSTER.getName()) && operation.hasDefined(BroadcastGroupDefinition.JGROUPS_CHANNEL_FACTORY.getName()) && !operation.hasDefined(BroadcastGroupDefinition.JGROUPS_CHANNEL.getName())) {
            String channel = operation.get(CommonAttributes.JGROUPS_CLUSTER.getName()).asString();
            operation.get(BroadcastGroupDefinition.JGROUPS_CHANNEL.getName()).set(channel);
            PathAddress channelAddress = context.getCurrentAddress().getParent().getParent().getParent().append("subsystem", "jgroups").append("channel", channel);
            ModelNode addChannelOperation = Util.createAddOperation((PathAddress)channelAddress);
            addChannelOperation.get("stack").set(operation.get(BroadcastGroupDefinition.JGROUPS_CHANNEL_FACTORY.getName()));
            context.addStep(addChannelOperation, (OperationStepHandler)AddIfAbsentStepHandler.INSTANCE, OperationContext.Stage.MODEL);
        }
        if (this.needLegacyCall) {
            PathAddress target = context.getCurrentAddress().getParent().append("broadcast-group", context.getCurrentAddressValue());
            ModelNode op = operation.clone();
            op.get("address").set(target.toModelNode());
            context.addStep(op, (OperationStepHandler)BroadcastGroupAdd.LEGACY_INSTANCE, OperationContext.Stage.MODEL, true);
        }
        super.execute(context, operation);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.populateModel(context, operation, resource);
        final ModelNode connectorRefs = resource.getModel().require(BroadcastGroupDefinition.CONNECTOR_REFS.getName());
        if (connectorRefs.isDefined()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    BroadcastGroupWriteAttributeHandler.JGROUP_INSTANCE.validateConnectors(context, operation, connectorRefs);
                }
            }, OperationContext.Stage.MODEL);
        }
    }

    static void addBroadcastGroupConfigs(OperationContext context, List<BroadcastGroupConfiguration> configs, Set<String> connectors, ModelNode model) throws OperationFailedException {
        if (model.hasDefined("jgroups-broadcast-group")) {
            for (Property prop : model.get("jgroups-broadcast-group").asPropertyList()) {
                configs.add(JGroupsBroadcastGroupAdd.createBroadcastGroupConfiguration(context, connectors, prop.getName(), prop.getValue()));
            }
        }
    }

    static BroadcastGroupConfiguration createBroadcastGroupConfiguration(OperationContext context, Set<String> connectors, String name, ModelNode model) throws OperationFailedException {
        long broadcastPeriod = BroadcastGroupDefinition.BROADCAST_PERIOD.resolveModelAttribute(context, model).asLong();
        ArrayList<String> connectorRefs = new ArrayList<String>();
        if (model.hasDefined("connectors")) {
            for (ModelNode ref : model.get("connectors").asList()) {
                String refName = ref.asString();
                if (!connectors.contains(refName)) {
                    throw MessagingLogger.ROOT_LOGGER.wrongConnectorRefInBroadCastGroup(name, refName, connectors);
                }
                connectorRefs.add(refName);
            }
        }
        return new BroadcastGroupConfiguration().setName(name).setBroadcastPeriod(broadcastPeriod).setConnectorInfos(connectorRefs);
    }

    static BroadcastGroupConfiguration createBroadcastGroupConfiguration(String name, BroadcastGroupConfiguration config, BroadcastCommandDispatcherFactory commandDispatcherFactory, String channelName) throws Exception {
        long broadcastPeriod = config.getBroadcastPeriod();
        List connectorRefs = config.getConnectorInfos();
        CommandDispatcherBroadcastEndpointFactory endpointFactory = new CommandDispatcherBroadcastEndpointFactory(commandDispatcherFactory, channelName);
        return new BroadcastGroupConfiguration().setName(name).setBroadcastPeriod(broadcastPeriod).setConnectorInfos(connectorRefs).setEndpointFactory((BroadcastEndpointFactory)endpointFactory);
    }
}

