/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration;

import java.util.HashSet;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.logs.AuditLogger;
import org.apache.activemq.artemis.spi.core.security.ActiveMQBasicSecurityManager;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MultiThreadedAuditLoggingTest
extends ActiveMQTestBase {
    protected ActiveMQServer server;
    private static final int MESSAGE_COUNT = 10;
    private static final String MESSAGE_AUDIT_LOGGER_NAME = AuditLogger.MESSAGE_LOGGER.getLogger().getName();
    private static AssertionLoggerHandler.LogLevel previousLevel = null;
    private static AssertionLoggerHandler loggerHandler;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(true, this.createDefaultInVMConfig().setSecurityEnabled(true));
        this.server.setSecurityManager((ActiveMQSecurityManager)new ActiveMQBasicSecurityManager());
        this.server.start();
        HashSet<Role> roles = new HashSet<Role>();
        roles.add(new Role("queue1", true, true, true, true, true, true, true, true, true, true, false, false));
        this.server.getSecurityRepository().addMatch("queue1", roles);
        roles = new HashSet();
        roles.add(new Role("queue2", true, true, true, true, true, true, true, true, true, true, false, false));
        this.server.getSecurityRepository().addMatch("queue2", roles);
        this.server.getActiveMQServerControl().addUser("queue1", "queue1", "queue1", true);
        this.server.getActiveMQServerControl().addUser("queue2", "queue2", "queue2", true);
    }

    @BeforeAll
    public static void prepareLogger() {
        previousLevel = AssertionLoggerHandler.setLevel((String)MESSAGE_AUDIT_LOGGER_NAME, (AssertionLoggerHandler.LogLevel)AssertionLoggerHandler.LogLevel.INFO);
        loggerHandler = new AssertionLoggerHandler();
    }

    @AfterAll
    public static void clearLogger() throws Exception {
        try {
            loggerHandler.close();
        }
        finally {
            AssertionLoggerHandler.setLevel((String)MESSAGE_AUDIT_LOGGER_NAME, (AssertionLoggerHandler.LogLevel)previousLevel);
        }
    }

    @Test
    public void testConcurrentLogging() throws Exception {
        int nThreads = 6;
        SomeConsumer[] consumers = new SomeConsumer[nThreads];
        SomeProducer[] producers = new SomeProducer[nThreads];
        for (int j = 0; j < 8; ++j) {
            int i;
            for (i = 0; i < nThreads / 2; ++i) {
                consumers[i] = new SomeConsumer("queue1");
            }
            for (i = nThreads / 2; i < nThreads; ++i) {
                consumers[i] = new SomeConsumer("queue2");
            }
            for (i = 0; i < nThreads; ++i) {
                consumers[i].start();
            }
            for (i = 0; i < nThreads / 2; ++i) {
                producers[i] = new SomeProducer("queue1");
            }
            for (i = nThreads / 2; i < nThreads; ++i) {
                producers[i] = new SomeProducer("queue2");
            }
            for (i = 0; i < nThreads; ++i) {
                producers[i].start();
            }
            for (SomeConsumer someConsumer : consumers) {
                someConsumer.join();
                Assertions.assertFalse((boolean)someConsumer.failed);
            }
            for (Thread thread : producers) {
                thread.join();
                Assertions.assertFalse((boolean)((SomeProducer)thread).failed);
            }
            Assertions.assertFalse((boolean)loggerHandler.matchText(".*User queue1\\(queue1\\).* is consuming a message from queue2.*"));
            Assertions.assertFalse((boolean)loggerHandler.matchText(".*User queue2\\(queue2\\).* is consuming a message from queue1.*"));
            Assertions.assertTrue((boolean)loggerHandler.matchText(".*User queue2\\(queue2\\).* is consuming a message from queue2.*"));
            Assertions.assertTrue((boolean)loggerHandler.matchText(".*User queue1\\(queue1\\).* is consuming a message from queue1.*"));
        }
    }

    class SomeConsumer
    extends Thread {
        boolean failed = false;
        protected ClientSession session;
        protected ClientSessionFactory sf;
        protected ServerLocator locator;
        String queue;

        SomeConsumer(String queue) throws Exception {
            this.queue = queue;
            this.locator = MultiThreadedAuditLoggingTest.this.createInVMNonHALocator();
            this.sf = MultiThreadedAuditLoggingTest.this.createSessionFactory(this.locator);
            this.session = MultiThreadedAuditLoggingTest.this.addClientSession(this.sf.createSession(queue, queue, false, true, true, false, 0));
        }

        @Override
        public void run() {
            ClientConsumer consumer = null;
            try {
                try {
                    this.session.createQueue(QueueConfiguration.of((String)this.queue).setRoutingType(RoutingType.ANYCAST));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                consumer = this.session.createConsumer(this.queue);
                this.session.start();
                for (int i = 0; i < 10; ++i) {
                    consumer.receive();
                }
            }
            catch (Throwable e) {
                this.failed = true;
            }
            finally {
                try {
                    if (consumer != null) {
                        consumer.close();
                    }
                    if (this.session != null) {
                        this.session.close();
                    }
                    if (this.sf != null) {
                        this.sf.close();
                    }
                    if (this.locator != null) {
                        this.locator.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class SomeProducer
    extends Thread {
        boolean failed = false;
        protected ClientSession session;
        protected ClientSessionFactory sf;
        protected ServerLocator locator;
        String queue;

        SomeProducer(String queue) throws Exception {
            this.queue = queue;
            this.locator = MultiThreadedAuditLoggingTest.this.createInVMNonHALocator();
            this.sf = MultiThreadedAuditLoggingTest.this.createSessionFactory(this.locator);
            this.session = MultiThreadedAuditLoggingTest.this.addClientSession(this.sf.createSession(queue, queue, false, true, true, false, 0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String data = "Simple Text " + UUID.randomUUID().toString();
            ClientProducer producer = null;
            try {
                try {
                    this.session.createQueue(QueueConfiguration.of((String)this.queue).setRoutingType(RoutingType.ANYCAST));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                producer = this.session.createProducer(this.queue);
                ClientMessage message = this.session.createMessage(false);
                message.getBodyBuffer().writeString(data);
                for (int i = 0; i < 10; ++i) {
                    producer.send((Message)message);
                }
            }
            catch (Throwable e) {
                this.failed = true;
            }
            finally {
                try {
                    if (producer != null) {
                        producer.close();
                    }
                    if (this.session != null) {
                        this.session.close();
                    }
                    if (this.sf != null) {
                        this.sf.close();
                    }
                    if (this.locator != null) {
                        this.locator.close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

