/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.activemq.transport.amqp.client.AmqpValidator;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedByte;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.Header;
import org.apache.qpid.proton.amqp.messaging.Section;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.message.Message;
import org.jgroups.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpSendReceiveTest
extends AmqpClientTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected boolean isAutoCreateQueues() {
        return false;
    }

    @Override
    protected boolean isAutoCreateAddresses() {
        return false;
    }

    @Test
    @Timeout(value=60L)
    public void testAcceptWithoutSettling() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        this.sendMessages(this.getQueueName(), 10);
        for (int i = 0; i < 10; ++i) {
            receiver.flow(1);
            AmqpMessage receive = receiver.receive();
            receive.accept(false);
            receive.settle();
        }
        receiver.close();
        connection.close();
        Queue queue = this.getProxyToQueue(this.getQueueName());
        Assertions.assertNotNull((Object)queue);
        Wait.assertEquals((long)0L, () -> ((Queue)queue).getMessageCount());
    }

    @Test
    @Timeout(value=60L)
    public void testQueueReceiverReadMessage() throws Exception {
        this.sendMessages(this.getQueueName(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertEquals((long)1L, (long)queueView.getMessageCount());
        receiver.flow(1);
        Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        receiver.close();
        Assertions.assertEquals((long)1L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testCoreBridge() throws Exception {
        this.server.getRemotingService().createAcceptor("acceptor", "vm://0").start();
        this.server.getConfiguration().addConnectorConfiguration("connector", "vm://0");
        this.server.deployBridge(new BridgeConfiguration().setName(this.getTestName()).setQueueName(this.getQueueName()).setForwardingAddress(this.getQueueName(1)).setConfirmationWindowSize(10).setStaticConnectors(Arrays.asList("connector")));
        this.sendMessages(this.getQueueName(), 1);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName(1));
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((int)1, () -> ((Queue)queueView).getConsumerCount());
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
        queueView = this.getProxyToQueue(this.getQueueName(1));
        Wait.assertEquals((int)1, () -> ((Queue)queueView).getConsumerCount());
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        receiver.flow(1);
        AmqpMessage message = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message);
        message.accept();
        receiver.close();
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testMessageDurableFalse() throws Exception {
        this.sendMessages(this.getQueueName(), 1, false);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertEquals((long)1L, (long)queueView.getMessageCount());
        receiver.flow(1);
        AmqpMessage receive = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)receive);
        Assertions.assertFalse((boolean)receive.isDurable());
        receiver.close();
        Assertions.assertEquals((long)1L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testMessageDurableTrue() throws Exception {
        Assertions.assertNotNull((Object)this.server.locateQueue(this.getQueueName()));
        this.sendMessages(this.getQueueName(), 1, true);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertEquals((long)1L, (long)queueView.getMessageCount());
        receiver.flow(1);
        AmqpMessage receive = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)receive);
        Assertions.assertTrue((boolean)receive.isDurable());
        receiver.close();
        Assertions.assertEquals((long)1L, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testTwoQueueReceiversOnSameConnectionReadMessagesNoDispositions() throws Exception {
        int MSG_COUNT = 4;
        this.sendMessages(this.getQueueName(), MSG_COUNT);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertEquals((long)MSG_COUNT, (long)queueView.getMessageCount());
        receiver1.flow(2);
        Assertions.assertNotNull((Object)receiver1.receive(5L, TimeUnit.SECONDS));
        Assertions.assertNotNull((Object)receiver1.receive(5L, TimeUnit.SECONDS));
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        Assertions.assertEquals((long)2L, (long)this.server.getTotalConsumerCount());
        receiver2.flow(2);
        Assertions.assertNotNull((Object)receiver2.receive(5L, TimeUnit.SECONDS));
        Assertions.assertNotNull((Object)receiver2.receive(5L, TimeUnit.SECONDS));
        Assertions.assertEquals((long)0L, (long)queueView.getMessagesAcknowledged());
        receiver1.close();
        receiver2.close();
        Assertions.assertEquals((long)MSG_COUNT, (long)queueView.getMessageCount());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testTwoQueueReceiversOnSameConnectionReadMessagesAcceptOnEach() throws Exception {
        int MSG_COUNT = 4;
        this.sendMessages(this.getQueueName(), MSG_COUNT);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertEquals((long)MSG_COUNT, (long)queueView.getMessageCount());
        receiver1.flow(2);
        AmqpMessage message = receiver1.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message);
        message.accept();
        message = receiver1.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message);
        message.accept();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> queueView.getMessagesAcknowledged() == 2L, (long)TimeUnit.SECONDS.toMillis(5L), (long)TimeUnit.MILLISECONDS.toMillis(50L)), (String)"Should have ack'd two");
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        Assertions.assertEquals((long)2L, (long)this.server.getTotalConsumerCount());
        receiver2.flow(2);
        message = receiver2.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message);
        message.accept();
        message = receiver2.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message);
        message.accept();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> queueView.getMessagesAcknowledged() == 4L, (long)TimeUnit.SECONDS.toMillis(15L), (long)TimeUnit.MILLISECONDS.toMillis(10L)), (String)"Queue should be empty now");
        receiver1.close();
        receiver2.close();
        Wait.assertEquals((long)0L, () -> ((Queue)queueView).getMessageCount());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSecondReceiverOnQueueGetsAllUnconsumedMessages() throws Exception {
        int MSG_COUNT = 20;
        this.sendMessages(this.getQueueName(), MSG_COUNT);
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Assertions.assertEquals((long)MSG_COUNT, (long)queueView.getMessageCount());
        receiver1.flow(20);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> queueView.getDeliveringCount() >= 2, (long)TimeUnit.SECONDS.toMillis(5L), (long)TimeUnit.MILLISECONDS.toMillis(50L)), (String)"Should have dispatch to prefetch");
        receiver1.close();
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        Assertions.assertEquals((long)1L, (long)this.server.getTotalConsumerCount());
        receiver2.flow(MSG_COUNT * 2);
        AmqpMessage message = receiver2.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message);
        message.accept();
        message = receiver2.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message);
        message.accept();
        Assertions.assertTrue((boolean)Wait.waitFor(() -> queueView.getMessagesAcknowledged() == 2L, (long)TimeUnit.SECONDS.toMillis(5L), (long)TimeUnit.MILLISECONDS.toMillis(50L)), (String)"Should have ack'd two");
        receiver2.close();
        Wait.assertEquals((long)(MSG_COUNT - 2), () -> ((Queue)queueView).getMessageCount());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSimpleSendOneReceiveOne() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg1");
        message.setMessageAnnotation("serialNo", 1);
        message.setText("Test-Message");
        sender.send(message);
        sender.close();
        logger.debug("Attempting to read message with receiver");
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        receiver.flow(2);
        AmqpMessage received = receiver.receive(10L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received, (String)"Should have read message");
        Assertions.assertEquals((Object)"msg1", (Object)received.getMessageId());
        received.accept();
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testSendFilterAnnotation() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg1");
        message.setMessageAnnotation("x-opt-serialNo", 1);
        message.setText("Test-Message");
        sender.send(message);
        message = new AmqpMessage();
        message.setMessageId("msg2");
        message.setMessageAnnotation("x-opt-serialNo", 2);
        message.setText("Test-Message 2");
        sender.send(message);
        sender.close();
        logger.debug("Attempting to read message with receiver");
        AmqpReceiver receiver = session.createReceiver(this.getQueueName(), "\"m.x-opt-serialNo\"=2");
        receiver.flow(2);
        AmqpMessage received = receiver.receive(10L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received, (String)"Should have read message");
        Assertions.assertEquals((Object)"msg2", (Object)received.getMessageId());
        received.accept();
        Assertions.assertNull((Object)receiver.receiveNoWait());
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testCloseBusyReceiver() throws Exception {
        int MSG_COUNT = 20;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        for (int i = 0; i < 20; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("msg" + i);
            message.setMessageAnnotation("serialNo", i);
            message.setText("Test-Message");
            logger.debug("Sending message: {}", (Object)message.getMessageId());
            sender.send(message);
        }
        sender.close();
        Queue queue = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)20L, () -> ((Queue)queue).getMessageCount());
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        receiver1.flow(20);
        AmqpMessage received = receiver1.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received, (String)"Should have got a message");
        Assertions.assertEquals((Object)"msg0", (Object)received.getMessageId());
        receiver1.close();
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        receiver2.flow(200);
        for (int i = 0; i < 20; ++i) {
            received = receiver2.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received, (String)"Should have got a message");
            logger.debug("Read message: {}", (Object)received.getMessageId());
            Assertions.assertEquals((Object)("msg" + i), (Object)received.getMessageId());
        }
        receiver2.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReceiveWithJMSSelectorFilter() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpMessage message1 = new AmqpMessage();
        message1.setGroupId("abcdefg");
        message1.setApplicationProperty("sn", 100);
        AmqpMessage message2 = new AmqpMessage();
        message2.setGroupId("hijklm");
        message2.setApplicationProperty("sn", 200);
        AmqpSender sender = session.createSender(this.getQueueName());
        sender.send(message1);
        sender.send(message2);
        sender.close();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName(), "sn = 100");
        receiver.flow(2);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received, (String)"Should have read a message");
        Assertions.assertEquals((Object)100, (Object)received.getApplicationProperty("sn"));
        Assertions.assertEquals((Object)"abcdefg", (Object)received.getGroupId());
        received.accept();
        Assertions.assertNull((Object)receiver.receive(1L, TimeUnit.SECONDS));
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReceiveWithJMSSelectorFilterOnJMSType() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpMessage message1 = new AmqpMessage();
        message1.setText("msg:1");
        AmqpMessage message2 = new AmqpMessage();
        message2.setSubject("target");
        message2.setText("msg:2");
        AmqpSender sender = session.createSender(this.getQueueName());
        sender.send(message1);
        sender.send(message2);
        sender.close();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName(), "JMSType = 'target'");
        receiver.flow(2);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received, (String)"Should have read a message");
        Assertions.assertEquals((Object)"target", (Object)received.getSubject());
        received.accept();
        Assertions.assertNull((Object)receiver.receive(1L, TimeUnit.SECONDS));
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testAdvancedLinkFlowControl() throws Exception {
        int MSG_COUNT = 20;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        for (int i = 0; i < 20; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("msg" + i);
            message.setMessageAnnotation("serialNo", i);
            message.setText("Test-Message");
            sender.send(message);
        }
        sender.close();
        logger.debug("Attempting to read first two messages with receiver #1");
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        receiver1.flow(2);
        AmqpMessage message1 = receiver1.receive(10L, TimeUnit.SECONDS);
        AmqpMessage message2 = receiver1.receive(10L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message1, (String)"Should have read message 1");
        Assertions.assertNotNull((Object)message2, (String)"Should have read message 2");
        Assertions.assertEquals((Object)"msg0", (Object)message1.getMessageId());
        Assertions.assertEquals((Object)"msg1", (Object)message2.getMessageId());
        message1.accept();
        message2.accept();
        logger.debug("Attempting to read next two messages with receiver #2");
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        receiver2.flow(2);
        AmqpMessage message3 = receiver2.receive(10L, TimeUnit.SECONDS);
        AmqpMessage message4 = receiver2.receive(10L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message3, (String)"Should have read message 3");
        Assertions.assertNotNull((Object)message4, (String)"Should have read message 4");
        Assertions.assertEquals((Object)"msg2", (Object)message3.getMessageId());
        Assertions.assertEquals((Object)"msg3", (Object)message4.getMessageId());
        message3.accept();
        message4.accept();
        logger.debug("Attempting to read remaining messages with receiver #1");
        receiver1.flow(16);
        for (int i = 4; i < 20; ++i) {
            AmqpMessage message = receiver1.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message, (String)"Should have read a message");
            Assertions.assertEquals((Object)("msg" + i), (Object)message.getMessageId());
            message.accept();
        }
        receiver1.close();
        receiver2.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testDispatchOrderWithPrefetchOfOne() throws Exception {
        AmqpMessage message;
        int i;
        int MSG_COUNT = 20;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        for (int i2 = 0; i2 < 20; ++i2) {
            AmqpMessage message2 = new AmqpMessage();
            message2.setMessageId("msg" + i2);
            message2.setMessageAnnotation("serialNo", i2);
            message2.setText("Test-Message");
            sender.send(message2);
        }
        sender.close();
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        receiver1.flow(1);
        AmqpReceiver receiver2 = session.createReceiver(this.getQueueName());
        receiver2.flow(1);
        AmqpMessage message1 = receiver1.receive(10L, TimeUnit.SECONDS);
        AmqpMessage message2 = receiver2.receive(10L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message1, (String)"Should have read message 1");
        Assertions.assertNotNull((Object)message2, (String)"Should have read message 2");
        Assertions.assertEquals((Object)"msg0", (Object)message1.getMessageId());
        Assertions.assertEquals((Object)"msg1", (Object)message2.getMessageId());
        message1.accept();
        message2.accept();
        receiver1.flow(1);
        AmqpMessage message3 = receiver1.receive(10L, TimeUnit.SECONDS);
        receiver2.flow(1);
        AmqpMessage message4 = receiver2.receive(10L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message3, (String)"Should have read message 3");
        Assertions.assertNotNull((Object)message4, (String)"Should have read message 4");
        Assertions.assertEquals((Object)"msg2", (Object)message3.getMessageId());
        Assertions.assertEquals((Object)"msg3", (Object)message4.getMessageId());
        message3.accept();
        message4.accept();
        logger.debug("*** Attempting to read remaining messages with both receivers");
        int splitCredit = 8;
        logger.debug("**** Receiver #1 granting credit[{}] for its block of messages", (Object)splitCredit);
        receiver1.flow(splitCredit);
        for (i = 0; i < splitCredit; ++i) {
            message = receiver1.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message, (String)"Receiver #1 should have read a message");
            logger.debug("Receiver #1 read message: {}", (Object)message.getMessageId());
            message.accept();
        }
        logger.debug("**** Receiver #2 granting credit[{}] for its block of messages", (Object)splitCredit);
        receiver2.flow(splitCredit);
        for (i = 0; i < splitCredit; ++i) {
            message = receiver2.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message, (String)("Receiver #2 should have read message[" + i + "]"));
            logger.debug("Receiver #2 read message: {}", (Object)message.getMessageId());
            message.accept();
        }
        receiver1.close();
        receiver2.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReceiveMessageAndRefillCreditBeforeAccept() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String address = this.getQueueName();
        AmqpReceiver receiver = session.createReceiver(address);
        AmqpSender sender = session.createSender(address);
        for (int i = 0; i < 2; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("msg" + i);
            sender.send(message);
        }
        sender.close();
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        receiver.flow(1);
        received.accept();
        received = receiver.receive(10L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        received.accept();
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReceiveMessageAndRefillCreditBeforeAcceptOnQueueAsync() throws Exception {
        AmqpClient client = this.createAmqpClient();
        LinkedList errors = new LinkedList();
        CountDownLatch receiverReady = new CountDownLatch(1);
        ExecutorService executorService = Executors.newCachedThreadPool();
        String address = this.getQueueName();
        executorService.submit(() -> {
            try {
                logger.debug("Starting consumer connection");
                AmqpConnection connection = this.addConnection(client.connect());
                AmqpSession session = connection.createSession();
                AmqpReceiver receiver = session.createReceiver(address);
                receiver.flow(1);
                receiverReady.countDown();
                AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
                Assertions.assertNotNull((Object)received);
                receiver.flow(1);
                received.accept();
                received = receiver.receive(5L, TimeUnit.SECONDS);
                Assertions.assertNotNull((Object)received);
                received.accept();
                receiver.close();
                connection.close();
            }
            catch (Exception error) {
                errors.add(error);
            }
        });
        executorService.submit(() -> {
            try {
                receiverReady.await(20L, TimeUnit.SECONDS);
                AmqpConnection connection = this.addConnection(client.connect());
                AmqpSession session = connection.createSession();
                AmqpSender sender = session.createSender(address);
                for (int i = 0; i < 2; ++i) {
                    AmqpMessage message = new AmqpMessage();
                    message.setMessageId("msg" + i);
                    sender.send(message);
                }
                sender.close();
                connection.close();
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        });
        executorService.shutdown();
        executorService.awaitTermination(20L, TimeUnit.SECONDS);
        Assertions.assertTrue((boolean)errors.isEmpty(), (String)("no errors: " + errors));
    }

    @Test
    @Timeout(value=60L)
    public void testMessageDurabliltyFollowsSpec() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        AmqpReceiver receiver1 = session.createReceiver(this.getQueueName());
        Queue queue = this.getProxyToQueue(this.getQueueName());
        AmqpMessage message1 = new AmqpMessage();
        message1.setText("Test-Message -> non-durable");
        message1.setDurable(false);
        message1.setMessageId("ID:Message:1");
        sender.send(message1);
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        receiver1.flow(1);
        message1 = receiver1.receive(50L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message1, (String)"Should have read a message");
        Assertions.assertFalse((boolean)message1.isDurable(), (String)"First message sent should not be durable");
        message1.accept();
        AmqpMessage message2 = new AmqpMessage();
        message2.setText("Test-Message -> durable");
        message2.setDurable(true);
        message2.setMessageId("ID:Message:2");
        sender.send(message2);
        Wait.assertEquals((long)1L, () -> ((Queue)queue).getMessageCount());
        receiver1.flow(1);
        message2 = receiver1.receive(50L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message2, (String)"Should have read a message");
        Assertions.assertTrue((boolean)message2.isDurable(), (String)"Second message sent should be durable");
        message2.accept();
        sender.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testMessageWithHeaderMarkedDurableIsPersisted() throws Exception {
        this.doTestBrokerRestartAndDurability(true, true, false);
    }

    @Test
    @Timeout(value=60L)
    public void testMessageWithHeaderMarkedNonDurableIsNotPersisted() throws Exception {
        this.doTestBrokerRestartAndDurability(false, true, true);
    }

    @Test
    @Timeout(value=60L)
    public void testMessageWithHeaderDefaultedNonDurableIsNotPersisted() throws Exception {
        this.doTestBrokerRestartAndDurability(false, true, false);
    }

    @Test
    @Timeout(value=60L)
    public void testMessageWithNoHeaderIsNotPersisted() throws Exception {
        this.doTestBrokerRestartAndDurability(false, false, false);
    }

    private void doTestBrokerRestartAndDurability(boolean durable, boolean enforceHeader, boolean explicitSetNonDurable) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName());
        Queue queueView1 = this.getProxyToQueue(this.getQueueName());
        Message protonMessage = Message.Factory.create();
        protonMessage.setMessageId((Object)"ID:Message:1");
        protonMessage.setBody((Section)new AmqpValue((Object)("Test-Message -> " + (durable ? "durable" : "non-durable"))));
        if (durable || enforceHeader) {
            Header header = new Header();
            if (durable) {
                header.setDurable(Boolean.valueOf(true));
            } else if (explicitSetNonDurable) {
                header.setDurable(Boolean.valueOf(false));
            } else {
                header.setPriority(UnsignedByte.valueOf((byte)5));
                Assertions.assertNull((Object)header.getDurable());
            }
            protonMessage.setHeader(header);
        } else {
            Assertions.assertNull((Object)protonMessage.getHeader(), (String)"Should not have a header");
        }
        AmqpMessage message = new AmqpMessage(protonMessage);
        sender.send(message);
        connection.close();
        Wait.assertEquals((long)1L, () -> ((Queue)queueView1).getMessageCount());
        this.server.stop();
        this.server.start();
        connection = this.addConnection(client.connect());
        session = connection.createSession();
        AmqpReceiver receiver = session.createReceiver(this.getQueueName());
        Queue queueView2 = this.getProxyToQueue(this.getQueueName());
        if (durable) {
            Wait.assertTrue((String)"Message should not have returned", () -> queueView2.getMessageCount() == 1L);
        } else {
            Wait.assertTrue((String)"Message should have been restored", () -> queueView2.getMessageCount() == 0L);
        }
        receiver.flow(1);
        message = receiver.receive(1L, TimeUnit.SECONDS);
        if (durable) {
            Assertions.assertNotNull((Object)message, (String)"Should have read a message");
        } else {
            Assertions.assertNull((Object)message, (String)"Should not have read a message");
        }
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReceiveMessageBeyondAckedAmountQueue() throws Exception {
        int MSG_COUNT = 50;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String address = this.getQueueName();
        AmqpReceiver receiver = session.createReceiver(address);
        AmqpSender sender = session.createSender(address);
        Queue destinationView = this.getProxyToQueue(address);
        for (int i = 0; i < 50; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("msg" + i);
            sender.send(message);
        }
        ArrayList<AmqpMessage> pendingAcks = new ArrayList<AmqpMessage>();
        for (int i = 0; i < 50; ++i) {
            receiver.flow(1);
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received);
            pendingAcks.add(received);
        }
        AmqpMessage message = new AmqpMessage();
        message.setMessageId("msg-final");
        sender.send(message);
        for (AmqpMessage pendingAck : pendingAcks) {
            pendingAck.accept();
        }
        Wait.assertEquals((int)0, () -> ((Queue)destinationView).getDeliveringCount());
        sender.close();
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testTwoPresettledReceiversReceiveAllMessages() throws Exception {
        AmqpMessage message;
        int i;
        int MSG_COUNT = 100;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String address = this.getQueueName();
        AmqpSender sender = session.createSender(address);
        AmqpReceiver receiver1 = session.createReceiver(address, null, false, true);
        AmqpReceiver receiver2 = session.createReceiver(address, null, false, true);
        for (int i2 = 0; i2 < 100; ++i2) {
            AmqpMessage message2 = new AmqpMessage();
            message2.setMessageId("msg" + i2);
            sender.send(message2);
        }
        logger.debug("Attempting to read first two messages with receiver #1");
        receiver1.flow(2);
        AmqpMessage message1 = receiver1.receive(10L, TimeUnit.SECONDS);
        AmqpMessage message2 = receiver1.receive(10L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message1, (String)"Should have read message 1");
        Assertions.assertNotNull((Object)message2, (String)"Should have read message 2");
        Assertions.assertEquals((Object)"msg0", (Object)message1.getMessageId());
        Assertions.assertEquals((Object)"msg1", (Object)message2.getMessageId());
        message1.accept();
        message2.accept();
        logger.debug("Attempting to read next two messages with receiver #2");
        receiver2.flow(2);
        AmqpMessage message3 = receiver2.receive(10L, TimeUnit.SECONDS);
        AmqpMessage message4 = receiver2.receive(10L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)message3, (String)"Should have read message 3");
        Assertions.assertNotNull((Object)message4, (String)"Should have read message 4");
        Assertions.assertEquals((Object)"msg2", (Object)message3.getMessageId());
        Assertions.assertEquals((Object)"msg3", (Object)message4.getMessageId());
        message3.accept();
        message4.accept();
        logger.debug("*** Attempting to read remaining messages with both receivers");
        int splitCredit = 48;
        logger.debug("**** Receiver #1 granting credit[{}] for its block of messages", (Object)splitCredit);
        receiver1.flow(splitCredit);
        for (i = 0; i < splitCredit; ++i) {
            message = receiver1.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message, (String)"Receiver #1 should have read a message");
            logger.debug("Receiver #1 read message: {}", (Object)message.getMessageId());
            message.accept();
        }
        logger.debug("**** Receiver #2 granting credit[{}] for its block of messages", (Object)splitCredit);
        receiver2.flow(splitCredit);
        for (i = 0; i < splitCredit; ++i) {
            message = receiver2.receive(10L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)message, (String)("Receiver #2 should have read a message[" + i + "]"));
            logger.debug("Receiver #2 read message: {}", (Object)message.getMessageId());
            message.accept();
        }
        receiver1.close();
        receiver2.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testDeliveryDelayOfferedWhenRequested() throws Exception {
        AmqpClient client = this.createAmqpClient();
        client.setValidator(new AmqpValidator(){

            @Override
            public void inspectOpenedResource(Sender sender) {
                Symbol[] offered = sender.getRemoteOfferedCapabilities();
                if (!AmqpSupport.contains(offered, org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport.DELAYED_DELIVERY)) {
                    this.markAsInvalid("Broker did not indicate it support delayed message delivery");
                }
            }
        });
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        AmqpSender sender = session.createSender(this.getQueueName(), new Symbol[]{org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport.DELAYED_DELIVERY});
        Assertions.assertNotNull((Object)sender);
        connection.getStateInspector().assertValid();
        sender.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testMessageWithToFieldSetToSenderAddress() throws Exception {
        this.doTestMessageWithToFieldSet(false, this.getQueueName());
    }

    @Test
    @Timeout(value=60L)
    public void testMessageWithToFieldSetToRandomAddress() throws Exception {
        this.doTestMessageWithToFieldSet(false, UUID.randomUUID().toString());
    }

    @Test
    @Timeout(value=60L)
    public void testMessageWithToFieldSetToEmpty() throws Exception {
        this.doTestMessageWithToFieldSet(false, "");
    }

    @Test
    @Timeout(value=60L)
    public void testMessageWithToFieldSetToNull() throws Exception {
        this.doTestMessageWithToFieldSet(false, null);
    }

    @Test
    @Timeout(value=60L)
    public void testMessageWithToFieldSetWithAnonymousSender() throws Exception {
        this.doTestMessageWithToFieldSet(true, this.getQueueName());
    }

    private void doTestMessageWithToFieldSet(boolean anonymous, String expected) throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String address = this.getQueueName();
        AmqpSender sender = session.createSender(anonymous ? null : address);
        AmqpMessage message = new AmqpMessage();
        message.setAddress(expected);
        message.setMessageId("msg:1");
        sender.send(message);
        AmqpReceiver receiver = session.createReceiver(address);
        Queue queueView = this.getProxyToQueue(address);
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        receiver.flow(1);
        AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)received);
        Assertions.assertEquals((Object)expected, (Object)received.getAddress());
        receiver.close();
        Wait.assertEquals((long)1L, () -> ((Queue)queueView).getMessageCount());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testLinkDetatchErrorIsCorrectWhenQueueDoesNotExists() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        Exception expectedException = null;
        try {
            session.createSender("AnAddressThatDoesNotExist");
            Assertions.fail((String)"Creating a sender here on an address that doesn't exist should fail");
        }
        catch (Exception e) {
            expectedException = e;
        }
        Assertions.assertNotNull((Object)expectedException);
        Assertions.assertTrue((boolean)expectedException.getMessage().contains("amqp:not-found"));
        Assertions.assertTrue((boolean)expectedException.getMessage().contains("target address AnAddressThatDoesNotExist does not exist"));
        connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=60L)
    public void testSendingAndReceivingToQueueWithDifferentAddressAndQueueName() throws Exception {
        String queueName = "TestQueueName";
        String address = "TestAddress";
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)address), RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)queueName).setAddress(address).setRoutingType(RoutingType.ANYCAST));
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(address);
            AmqpReceiver receiver = session.createReceiver(address);
            receiver.flow(1);
            AmqpMessage message = new AmqpMessage();
            message.setText("TestPayload");
            sender.send(message);
            AmqpMessage receivedMessage = receiver.receive(5000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)receivedMessage);
        }
    }

    @Test
    @Timeout(value=60L)
    public void testSendReceiveLotsOfDurableMessagesOnQueue() throws Exception {
        this.doTestSendReceiveLotsOfDurableMessages(Queue.class);
    }

    @Test
    @Timeout(value=60L)
    public void testSendReceiveLotsOfDurableMessagesOnTopic() throws Exception {
        this.doTestSendReceiveLotsOfDurableMessages(Topic.class);
    }

    private void doTestSendReceiveLotsOfDurableMessages(Class<?> destType) throws Exception {
        int MSG_COUNT = 1000;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        CountDownLatch done = new CountDownLatch(1000);
        AtomicBoolean error = new AtomicBoolean(false);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        String address = Queue.class.equals(destType) ? this.getQueueName() : this.getTopicName();
        AmqpReceiver receiver = session.createReceiver(address);
        receiver.flow(1000);
        AmqpSender sender = session.createSender(address);
        Queue queueView = this.getProxyToQueue(address);
        executor.execute(() -> {
            for (int i = 0; i < 1000; ++i) {
                try {
                    AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
                    received.accept();
                    done.countDown();
                    continue;
                }
                catch (Exception ex) {
                    logger.debug("Caught error: {}", (Object)ex.getClass().getSimpleName());
                    error.set(true);
                }
            }
        });
        for (int i = 0; i < 1000; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("msg" + i);
            sender.send(message);
        }
        Assertions.assertTrue((boolean)done.await(10L, TimeUnit.SECONDS), (String)("did not read all messages, waiting on: " + done.getCount()));
        Assertions.assertFalse((boolean)error.get(), (String)"should not be any errors on receive");
        Wait.assertEquals((int)0, () -> ((Queue)queueView).getDeliveringCount());
        sender.close();
        receiver.close();
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testReceiveRejecting() throws Exception {
        int MSG_COUNT = 1000;
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String address = this.getQueueName();
        AmqpSender sender = session.createSender(address);
        for (int i = 0; i < 1000; ++i) {
            AmqpMessage message = new AmqpMessage();
            message.setMessageId("msg" + i);
            sender.send(message);
        }
        Queue queueView = this.getProxyToQueue(address);
        for (int i = 0; i < 1000; ++i) {
            AmqpReceiver receiver = session.createReceiver(address);
            receiver.flow(1000);
            AmqpMessage received = receiver.receive(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)received);
            Assertions.assertEquals((Object)("msg" + i), (Object)received.getMessageId());
            received.accept();
            receiver.close();
        }
        AmqpReceiver receiver = session.createReceiver(address);
        receiver.flow(1000);
        Assertions.assertNull((Object)receiver.receive(1L, TimeUnit.MILLISECONDS));
        Wait.assertEquals((int)0, () -> ((Queue)queueView).getDeliveringCount());
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testCreateTopicReceiverOnAddressThatDoesNotExistOnPreviousAttempt() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String address = "test";
        Source source = new Source();
        source.setDurable(TerminusDurability.UNSETTLED_STATE);
        source.setCapabilities(new Symbol[]{Symbol.getSymbol((String)"topic")});
        source.setAddress("test");
        try {
            session.createReceiver(source, "test-receiver-subscription");
            Assertions.fail((String)"Should not be able to create the receiver");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
        AmqpReceiver receiver = null;
        try {
            receiver = session.createReceiver(source, "test-receiver-subscription");
            receiver.flow(1);
        }
        catch (Exception ex) {
            Assertions.fail((String)"Should be able to create the receiver");
        }
        AmqpSender sender = session.createSender("test");
        AmqpMessage message = new AmqpMessage();
        message.setText("TestPayload");
        sender.send(message);
        Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        connection.close();
    }

    @Test
    @Timeout(value=60L)
    public void testCreateQueueReceiverOnAddressThenRedoAsTopicReceiverAfterAddressUpdated() throws Exception {
        AmqpClient client = this.createAmqpClient();
        AmqpConnection connection = this.addConnection(client.connect());
        AmqpSession session = connection.createSession();
        String address = "test";
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.ANYCAST));
        Source source = new Source();
        source.setDurable(TerminusDurability.UNSETTLED_STATE);
        source.setCapabilities(new Symbol[]{Symbol.getSymbol((String)"topic")});
        source.setAddress("test");
        try {
            session.createReceiver(source, "test-receiver-subscription");
            Assertions.fail((String)"Should not be able to create the receiver");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.removeAddressInfo(SimpleString.of((String)"test"), null);
        this.server.addAddressInfo(new AddressInfo(SimpleString.of((String)"test"), RoutingType.MULTICAST));
        AmqpReceiver receiver = null;
        try {
            receiver = session.createReceiver(source, "test-receiver-subscription");
            receiver.flow(1);
        }
        catch (Exception ex) {
            Assertions.fail((String)"Should be able to create the receiver");
        }
        AmqpSender sender = session.createSender("test");
        AmqpMessage message = new AmqpMessage();
        message.setText("TestPayload");
        sender.send(message);
        Assertions.assertNotNull((Object)receiver.receive(5L, TimeUnit.SECONDS));
        connection.close();
    }
}

