/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.bridge;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BridgeRetryFullFailureTest
extends ActiveMQTestBase {
    private ActiveMQServer server0;
    private ActiveMQServer server1;

    private String getServer0URL() {
        return "tcp://localhost:61616";
    }

    private String getServer1URL() {
        return "tcp://localhost:61617";
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server0 = this.createServer(false, (Configuration)this.createBasicConfig());
        this.server1 = this.createServer(false, (Configuration)this.createBasicConfig());
        this.server1.getConfiguration().clearAddressSettings();
        this.server1.getConfiguration().addAddressSetting("#", new AddressSettings().setMaxSizeMessages(10L).setMaxSizeBytes(10000L).setAddressFullMessagePolicy(AddressFullMessagePolicy.FAIL));
        this.server0.getConfiguration().addAcceptorConfiguration("acceptor", this.getServer0URL());
        this.server0.getConfiguration().addConnectorConfiguration("connector", this.getServer1URL());
        this.server1.getConfiguration().addAcceptorConfiguration("acceptor", this.getServer1URL());
        this.server0.start();
        this.server1.start();
    }

    @Test
    public void testFullServer() throws Exception {
        SimpleString source = SimpleString.of((String)"source");
        SimpleString destination = SimpleString.of((String)"destination");
        this.server0.createQueue(QueueConfiguration.of((SimpleString)source).setRoutingType(RoutingType.ANYCAST));
        Queue queueServer1 = this.server1.createQueue(QueueConfiguration.of((SimpleString)destination).setRoutingType(RoutingType.ANYCAST));
        this.server0.deployBridge(new BridgeConfiguration().setRoutingType(ComponentConfigurationRoutingType.ANYCAST).setName("bridge").setForwardingAddress(destination.toString()).setQueueName(source.toString()).setConfirmationWindowSize(10).setStaticConnectors(Arrays.asList("connector")).setRetryInterval(100L).setReconnectAttempts(-1));
        ConnectionFactory factory0 = CFUtil.createConnectionFactory("CORE", this.getServer0URL());
        ConnectionFactory factory1 = CFUtil.createConnectionFactory("CORE", this.getServer1URL());
        int NUMBER_OF_MESSAGES = 1000;
        AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();
        this.runAfter(() -> loggerHandler.close());
        try (Connection connection = factory0.createConnection();){
            Session session = connection.createSession(false, 1);
            MessageProducer producer = session.createProducer((Destination)session.createQueue(source.toString()));
            producer.setDeliveryMode(1);
            for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                Message message = session.createMessage();
                message.setIntProperty("i", i);
                producer.send(message);
            }
        }
        Wait.assertTrue(() -> loggerHandler.findText(new String[]{"AMQ229102"}));
        HashSet<Integer> receivedIntegers = new HashSet<Integer>();
        try (Connection connection = factory1.createConnection();){
            connection.start();
            Session session = connection.createSession(false, 1);
            MessageConsumer consumer = session.createConsumer((Destination)session.createQueue(destination.toString()));
            for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
                Message message = consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertFalse((boolean)receivedIntegers.contains(message.getIntProperty("i")));
                receivedIntegers.add(message.getIntProperty("i"));
            }
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        for (int i = 0; i < NUMBER_OF_MESSAGES; ++i) {
            Assertions.assertTrue((boolean)receivedIntegers.contains(i));
        }
        Assertions.assertEquals((int)NUMBER_OF_MESSAGES, (int)receivedIntegers.size());
    }
}

