/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class QueueBrowserTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private final SimpleString QUEUE = SimpleString.of((String)"ConsumerTestQueue");
    private ServerLocator locator;
    private ClientSessionFactory sf;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
    }

    @Test
    public void testSimpleConsumerBrowser() throws Exception {
        ClientMessage message2;
        int i;
        this.locator.setBlockOnNonDurableSend(true);
        this.sf = this.createSessionFactory(this.locator);
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i2 = 0; i2 < 100; ++i2) {
            ClientMessage message = this.createTextMessage(session, "m" + i2);
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE, null, true);
        for (i = 0; i < 100; ++i) {
            message2 = consumer.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
        }
        consumer.close();
        consumer = session.createConsumer(this.QUEUE, null, true);
        for (i = 0; i < 100; ++i) {
            message2 = consumer.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
        }
        consumer.close();
        session.close();
    }

    @Test
    public void testConsumerBrowserWithSelector() throws Exception {
        ClientMessage message2;
        int i;
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i2 = 0; i2 < 100; ++i2) {
            ClientMessage message = this.createTextMessage(session, "m" + i2);
            message.putIntProperty(SimpleString.of((String)"x"), i2);
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE, SimpleString.of((String)"x >= 50"), true);
        for (i = 50; i < 100; ++i) {
            message2 = consumer.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
        }
        consumer.close();
        consumer = session.createConsumer(this.QUEUE, null, true);
        for (i = 0; i < 100; ++i) {
            message2 = consumer.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
        }
        consumer.close();
        session.close();
    }

    @Test
    public void testConsumerBrowserWithStringSelector() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            if (i % 2 == 0) {
                message.putStringProperty(SimpleString.of((String)"color"), SimpleString.of((String)"RED"));
            }
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE, SimpleString.of((String)"color = 'RED'"), true);
        for (int i = 0; i < 100; i += 2) {
            ClientMessage message2 = consumer.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
        }
        session.close();
    }

    @Test
    public void testConsumerMultipleBrowser() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE, null, true);
        ClientConsumer consumer2 = session.createConsumer(this.QUEUE, null, true);
        ClientConsumer consumer3 = session.createConsumer(this.QUEUE, null, true);
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
            message2 = consumer2.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
            message2 = consumer3.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
        }
        session.close();
    }

    @Test
    public void testConsumerMultipleBrowserWithSelector() throws Exception {
        ClientMessage message2;
        int i;
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i2 = 0; i2 < 100; ++i2) {
            ClientMessage message = this.createTextMessage(session, "m" + i2);
            message.putIntProperty(SimpleString.of((String)"x"), i2);
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE, SimpleString.of((String)"x < 50"), true);
        ClientConsumer consumer2 = session.createConsumer(this.QUEUE, SimpleString.of((String)"x >= 50"), true);
        ClientConsumer consumer3 = session.createConsumer(this.QUEUE, null, true);
        for (i = 0; i < 50; ++i) {
            message2 = consumer.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
        }
        for (i = 50; i < 100; ++i) {
            message2 = consumer2.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
        }
        for (i = 0; i < 100; ++i) {
            message2 = consumer3.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
        }
        session.close();
    }

    @Test
    public void testConsumerBrowserMessages() throws Exception {
        this.testConsumerBrowserMessagesArentAcked(false);
    }

    @Test
    public void testConsumerBrowserMessagesPreACK() throws Exception {
        this.testConsumerBrowserMessagesArentAcked(false);
    }

    private void testConsumerBrowserMessagesArentAcked(boolean preACK) throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(null, null, false, true, true, preACK, 0);
        session.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE, null, true);
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive(1000L);
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
        }
        Assertions.assertEquals((int)0, (int)((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()).getDeliveringCount());
        Assertions.assertEquals((int)100, (int)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()));
        session.close();
    }

    @Test
    public void testConsumerBrowserMessageAckDoesNothing() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = this.createTextMessage(session, "m" + i);
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(this.QUEUE, null, true);
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive(1000L);
            message2.acknowledge();
            Assertions.assertEquals((Object)("m" + i), (Object)message2.getBodyBuffer().readString());
        }
        Assertions.assertEquals((int)0, (int)((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()).getDeliveringCount());
        Assertions.assertEquals((int)100, (int)this.getMessageCount((Queue)this.server.getPostOffice().getBinding(this.QUEUE).getBindable()));
        session.close();
    }

    @Test
    public void testBrowseWithZeroConsumerWindowSize() throws Exception {
        this.locator.setConsumerWindowSize(0);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)this.QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(this.QUEUE);
        int numMessages = 100;
        byte[] bytes = new byte[240];
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage(false);
            message.getBodyBuffer().writeBytes(bytes);
            message.putIntProperty("foo", i);
            producer.send((Message)message);
        }
        session.createConsumer(this.QUEUE);
        session.start();
        ClientConsumer browser = session.createConsumer(this.QUEUE, true);
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = browser.receive(1000L);
            Assertions.assertEquals((int)i, (int)message2.getIntProperty("foo"));
        }
        session.close();
    }
}

