/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.clientcrash;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.tests.integration.clientcrash.ClientTestBase;
import org.apache.activemq.artemis.tests.integration.clientcrash.GracefulClient;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientExitTest
extends ClientTestBase {
    private static final String MESSAGE_TEXT = RandomUtil.randomString();
    private static final SimpleString QUEUE = SimpleString.of((String)"ClientExitTestQueue");
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ClientSession session;
    private ClientConsumer consumer;

    @Test
    public void testGracefulClientExit() throws Exception {
        Process p = SpawnedVMSupport.spawnVM((String)GracefulClient.class.getName(), (String[])new String[]{QUEUE.toString(), MESSAGE_TEXT});
        ClientMessage message = this.consumer.receive(15000L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertEquals((Object)MESSAGE_TEXT, (Object)message.getBodyBuffer().readString());
        logger.debug("waiting for the client VM to exit ...");
        p.waitFor();
        Assertions.assertEquals((int)0, (int)p.exitValue());
        this.session.close();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ServerLocator locator = this.createNettyNonHALocator();
        this.addServerLocator(locator);
        ClientSessionFactory sf = this.createSessionFactory(locator);
        this.session = sf.createSession(false, true, true);
        this.session.createQueue(QueueConfiguration.of((SimpleString)QUEUE).setDurable(Boolean.valueOf(false)));
        this.consumer = this.session.createConsumer(QUEUE);
        this.session.start();
    }
}

