/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.NodeManagerAction;
import org.apache.activemq.artemis.tests.util.SpawnedTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NodeManagerTest
extends SpawnedTestBase {
    @Test
    public void testID() throws Exception {
        NodeManagerAction live1 = new NodeManagerAction(14);
        this.performWork(live1);
    }

    @Test
    public void testPrimary() throws Exception {
        NodeManagerAction live1 = new NodeManagerAction(0, 10, 13, 2, 13, 12, 0, 10, 13, 2, 13, 12);
        this.performWork(live1);
    }

    @Test
    public void testSimplePrimaryAndBackup() throws Exception {
        NodeManagerAction primary1 = new NodeManagerAction(0, 10, 13, 2, 13, 12);
        NodeManagerAction backup1 = new NodeManagerAction(13, 12, 1, 11, 5, 6, 10, 3, 13, 12);
        this.performWork(primary1, backup1);
    }

    @Test
    public void testSimpleBackupAndPrimary() throws Exception {
        NodeManagerAction live1 = new NodeManagerAction(0, 10, 13, 2, 13, 12);
        NodeManagerAction backup1 = new NodeManagerAction(13, 12, 1, 11, 5, 6, 10, 3, 13, 12);
        this.performWork(backup1, live1);
    }

    @Test
    public void testSimplePrimaryAnd2Backups() throws Exception {
        NodeManagerAction live1 = new NodeManagerAction(0, 10, 13, 2, 13, 12);
        NodeManagerAction backup1 = new NodeManagerAction(13, 12, 1, 11, 5, 6, 10, 2, 13, 12);
        NodeManagerAction backup2 = new NodeManagerAction(13, 12, 1, 11, 5, 6, 10, 2, 13, 12);
        this.performWork(live1, backup1, backup2);
    }

    @Test
    public void testSimple2BackupsAndPrimary() throws Exception {
        NodeManagerAction live1 = new NodeManagerAction(0, 10, 13, 2, 13, 12);
        NodeManagerAction backup1 = new NodeManagerAction(13, 12, 1, 11, 5, 6, 10, 2, 13, 12);
        NodeManagerAction backup2 = new NodeManagerAction(13, 12, 1, 11, 5, 6, 10, 2, 13, 12);
        this.performWork(backup1, backup2, live1);
    }

    @Test
    public void testSimplePrimaryAnd2BackupsPaused() throws Exception {
        NodeManagerAction primary1 = new NodeManagerAction(0, 10, 13, 2, 13, 12);
        NodeManagerAction backup1 = new NodeManagerAction(13, 12, 1, 11, 5, 6, 10, 3, 0, 10, 13, 2, 13, 12);
        NodeManagerAction backup2 = new NodeManagerAction(13, 12, 1, 11, 5, 6, 10, 3, 0, 10, 13, 2, 13, 12);
        this.performWork(primary1, backup1, backup2);
    }

    @Test
    public void testSimple2BackupsPausedAndPrimary() throws Exception {
        NodeManagerAction live1 = new NodeManagerAction(0, 10, 13, 2, 13, 12);
        NodeManagerAction backup1 = new NodeManagerAction(13, 12, 1, 11, 5, 6, 10, 3, 0, 10, 13, 2, 13, 12);
        NodeManagerAction backup2 = new NodeManagerAction(13, 12, 1, 11, 5, 6, 10, 3, 0, 10, 13, 2, 13, 12);
        this.performWork(backup1, backup2, live1);
    }

    @Test
    public void testBackupsOnly() throws Exception {
        NodeManagerAction backup1 = new NodeManagerAction(13, 12, 1, 11, 4, 13, 12);
        NodeManagerAction backup2 = new NodeManagerAction(13, 12, 1, 11, 4, 13, 12);
        NodeManagerAction backup3 = new NodeManagerAction(13, 12, 1, 11, 4, 13, 12);
        NodeManagerAction backup4 = new NodeManagerAction(13, 12, 1, 11, 4, 13, 12);
        NodeManagerAction backup5 = new NodeManagerAction(13, 12, 1, 11, 4, 13, 12);
        NodeManagerAction backup6 = new NodeManagerAction(13, 12, 1, 11, 4, 13, 12);
        NodeManagerAction backup7 = new NodeManagerAction(13, 12, 1, 11, 4, 13, 12);
        NodeManagerAction backup8 = new NodeManagerAction(13, 12, 1, 11, 4, 13, 12);
        NodeManagerAction backup9 = new NodeManagerAction(13, 12, 1, 11, 4, 13, 12);
        NodeManagerAction backup10 = new NodeManagerAction(13, 12, 1, 11, 4, 13, 12);
        NodeManagerAction backup11 = new NodeManagerAction(13, 12, 1, 11, 4, 13, 12);
        this.performWork(backup1, backup2, backup3, backup4, backup5, backup6, backup7, backup8, backup9, backup10, backup11);
    }

    @Test
    public void testPrimaryAndBackupActiveForcesFailback() throws Exception {
        NodeManagerAction primary1 = new NodeManagerAction(0, 10, 13, 2, 13, 12, 0, 10, 13, 2);
        NodeManagerAction backup1 = new NodeManagerAction(13, 12, 1, 11, 5, 6, 10, 2, 13, 12, 5, 10, 3);
        this.performWork(primary1, backup1);
    }

    @Test
    public void testPrimaryAnd2BackupsActiveForcesFailback() throws Exception {
        NodeManagerAction primary1 = new NodeManagerAction(0, 10, 13, 2, 13, 12, 0, 10, 13, 2);
        NodeManagerAction backup1 = new NodeManagerAction(13, 12, 1, 11, 5, 6, 10, 2, 13, 12, 5, 6, 10, 2);
        NodeManagerAction backup2 = new NodeManagerAction(13, 12, 1, 11, 5, 6, 10, 2, 13, 12, 5, 6, 10, 2);
        this.performWork(primary1, backup1, backup2);
    }

    public void performWork(NodeManagerAction ... actions) throws Exception {
        InVMNodeManager nodeManager = new InVMNodeManager(false);
        ArrayList<NodeRunner> nodeRunners = new ArrayList<NodeRunner>();
        Thread[] threads = new Thread[actions.length];
        NodeManagerAction[] nodeManagerActionArray = actions;
        int n = nodeManagerActionArray.length;
        for (int i = 0; i < n; ++i) {
            NodeManagerAction action = nodeManagerActionArray[i];
            NodeRunner nodeRunner = new NodeRunner((NodeManager)nodeManager, action);
            nodeRunners.add(nodeRunner);
        }
        int nodeRunnersSize = nodeRunners.size();
        for (int i = 0; i < nodeRunnersSize; ++i) {
            NodeRunner nodeRunner = (NodeRunner)nodeRunners.get(i);
            threads[i] = new Thread(nodeRunner);
            threads[i].start();
        }
        for (Thread thread : threads) {
            try {
                thread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!thread.isAlive()) continue;
            thread.interrupt();
            Assertions.fail((String)"thread still running");
        }
        for (NodeRunner nodeRunner : nodeRunners) {
            if (nodeRunner.e == null) continue;
            nodeRunner.e.printStackTrace();
            Assertions.fail((String)nodeRunner.e.getMessage());
        }
    }

    protected static boolean isDebug() {
        return ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");
    }

    static class NodeRunner
    implements Runnable {
        private NodeManagerAction action;
        private NodeManager manager;
        Throwable e;

        NodeRunner(NodeManager nodeManager, NodeManagerAction action) {
            this.manager = nodeManager;
            this.action = action;
        }

        @Override
        public void run() {
            try {
                this.action.performWork(this.manager);
            }
            catch (Throwable e) {
                this.e = e;
            }
        }
    }
}

