/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.io.File;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.tests.integration.cluster.failover.BackupSyncJournalTest;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class BackupSyncLargeMessageTest
extends BackupSyncJournalTest {
    @Override
    protected void assertMessageBody(int i, ClientMessage message) {
        BackupSyncLargeMessageTest.assertLargeMessageBody(i, message);
    }

    @Override
    protected ServerLocatorInternal getServerLocator() throws Exception {
        return (ServerLocatorInternal)super.getServerLocator().setMinLargeMessageSize(1024);
    }

    @Override
    protected boolean supportsRetention() {
        return false;
    }

    @Override
    protected void setBody(int i, ClientMessage message) {
        BackupSyncLargeMessageTest.setLargeMessageBody(i, message);
    }

    @Test
    public void testDeleteLargeMessages() throws Exception {
        this.setNumberOfMessages(200);
        File dir = new File(this.backupServer.getServer().getConfiguration().getLargeMessagesDirectory());
        Assertions.assertEquals((int)0, (int)this.getAllMessageFileIds(dir).size(), (String)"Should not have any large messages... previous test failed to clean up?");
        this.createProducerSendSomeMessages();
        this.startBackupFinishSyncing();
        this.receiveMsgsInRange(0, this.getNumberOfMessages() / 2);
        this.finishSyncAndFailover();
        int target = this.getNumberOfMessages() / 2;
        long timeout = System.currentTimeMillis() + 5000L;
        while (this.getAllMessageFileIds(dir).size() != target && System.currentTimeMillis() < timeout) {
            Thread.sleep(50L);
        }
        Assertions.assertEquals((int)target, (int)this.getAllMessageFileIds(dir).size(), (String)"we really ought to delete these after delivery");
    }

    @Test
    public void testDeleteLargeMessagesDuringSync() throws Exception {
        this.setNumberOfMessages(200);
        File backupLMdir = new File(this.backupServer.getServer().getConfiguration().getLargeMessagesDirectory());
        File primaryLMDir = new File(this.primaryServer.getServer().getConfiguration().getLargeMessagesDirectory());
        Assertions.assertEquals((int)0, (int)this.getAllMessageFileIds(backupLMdir).size(), (String)"Should not have any large messages... previous test failed to clean up?");
        this.createProducerSendSomeMessages();
        this.backupServer.start();
        BackupSyncLargeMessageTest.waitForComponent((ActiveMQComponent)this.backupServer.getServer(), 5L);
        this.receiveMsgsInRange(0, this.getNumberOfMessages() / 2);
        this.startBackupFinishSyncing();
        Thread.sleep(500L);
        this.primaryServer.getServer().stop();
        this.backupServer.getServer().waitForActivation(10L, TimeUnit.SECONDS);
        this.backupServer.stop();
        Set<Long> backupLM = this.getAllMessageFileIds(backupLMdir);
        Set<Long> primaryLM = this.getAllMessageFileIds(primaryLMDir);
        Assertions.assertEquals(primaryLM, backupLM, (String)"primary and backup should have the same files ");
        Assertions.assertEquals((int)(this.getNumberOfMessages() / 2), (int)backupLM.size(), (String)("we really ought to delete these after delivery: " + backupLM));
        Assertions.assertEquals((int)(this.getNumberOfMessages() / 2), (int)this.getAllMessageFileIds(backupLMdir).size(), (String)"we really ought to delete these after delivery");
    }

    @Test
    public void testBackupStartsWhenPrimaryIsReceivingLargeMessage() throws Exception {
        ClientSession session = this.addClientSession(this.sessionFactory.createSession(true, true));
        session.createQueue(QueueConfiguration.of((SimpleString)FailoverTestBase.ADDRESS));
        ClientProducer producer = session.createProducer(FailoverTestBase.ADDRESS);
        ClientMessage message = session.createMessage(true);
        int largeMessageSize = 1024000;
        message.setBodyInputStream(ActiveMQTestBase.createFakeLargeStream(1024000L));
        AtomicBoolean caughtException = new AtomicBoolean(false);
        CountDownLatch latch = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        Runnable r = () -> {
            try {
                latch.countDown();
                producer.send((Message)message);
                this.sendMessages(session, producer, 20);
                session.commit();
            }
            catch (ActiveMQException e) {
                e.printStackTrace();
                caughtException.set(true);
            }
            finally {
                latch2.countDown();
            }
        };
        Executors.defaultThreadFactory().newThread(r).start();
        BackupSyncLargeMessageTest.waitForLatch(latch);
        this.startBackupFinishSyncing();
        ActiveMQTestBase.waitForLatch(latch2);
        this.crash(session);
        Assertions.assertFalse((boolean)caughtException.get(), (String)"no exceptions while sending message");
        session.start();
        ClientConsumer consumer = session.createConsumer(FailoverTestBase.ADDRESS);
        ClientMessage msg = consumer.receive(2000L);
        ActiveMQBuffer buffer = msg.getBodyBuffer();
        for (int j = 0; j < 1024000; ++j) {
            Assertions.assertTrue((boolean)buffer.readable(), (String)("large msg , expecting 1024000 bytes, got " + j));
            Assertions.assertEquals((byte)ActiveMQTestBase.getSamplebyte(j), (byte)buffer.readByte(), (String)("equal at " + j));
        }
        this.receiveMessages(consumer, 0, 20, true);
        Assertions.assertNull((Object)consumer.receiveImmediate(), (String)"there should be no more messages!");
        consumer.close();
        session.commit();
    }

    private Set<Long> getAllMessageFileIds(File dir) {
        TreeSet<Long> idsOnBkp = new TreeSet<Long>();
        String[] fileList = dir.list();
        if (fileList != null) {
            for (String filename : fileList) {
                if (!filename.endsWith(".msg")) continue;
                idsOnBkp.add(Long.valueOf(filename.split("\\.")[0]));
            }
        }
        return idsOnBkp;
    }
}

