/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.FailoverEventListener;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.util.TransportConfigurationUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FailoverListenerTest
extends FailoverTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private ServerLocatorInternal locator;
    private ClientSessionFactoryInternal sf;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.getServerLocator();
    }

    @Test
    public void testFailoverListenerCall() throws Exception {
        this.createSessionFactory(2);
        CountDownLatch failureLatch = new CountDownLatch(1);
        CountDownLatch failureDoneLatch = new CountDownLatch(1);
        SessionFactoryFailoverListener listener = new SessionFactoryFailoverListener(failureLatch, failureDoneLatch);
        this.sf.addFailoverListener((FailoverEventListener)listener);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        this.primaryServer.crash(new ClientSession[0]);
        Assertions.assertTrue((boolean)failureLatch.await(5L, TimeUnit.SECONDS));
        Assertions.assertEquals((Object)FailoverEventType.FAILURE_DETECTED, (Object)listener.getFailoverEventType().get(0));
        logger.debug("backup (now primary) topology = {}", (Object)this.backupServer.getServer().getClusterManager().getDefaultConnection(null).getTopology().describe());
        logger.debug("Server Crash!!!");
        Assertions.assertTrue((boolean)failureDoneLatch.await(5L, TimeUnit.SECONDS));
        Assertions.assertEquals((Object)FailoverEventType.FAILOVER_COMPLETED, (Object)listener.getFailoverEventType().get(1));
        ClientProducer producer = session.createProducer(ADDRESS);
        ClientMessage message = session.createMessage(true);
        this.setBody(0, message);
        producer.send((Message)message);
        this.verifyMessageOnServer(1, 1);
        logger.debug("******* starting primary server back");
        this.primaryServer.start();
        Thread.sleep(1000L);
        Assertions.assertEquals((Object)FailoverEventType.FAILURE_DETECTED, (Object)listener.getFailoverEventType().get(2));
        Assertions.assertEquals((Object)FailoverEventType.FAILOVER_COMPLETED, (Object)listener.getFailoverEventType().get(3));
        logger.debug("After failback: {}", (Object)this.locator.getTopology().describe());
        message = session.createMessage(true);
        this.setBody(1, message);
        producer.send((Message)message);
        session.close();
        this.verifyMessageOnServer(0, 1);
        this.wrapUpSessionFactory();
        Assertions.assertEquals((int)4, (int)listener.getFailoverEventType().size(), (String)"Expected 4 FailoverEvents to be triggered");
    }

    private void verifyMessageOnServer(int server, int numberOfMessages) throws Exception {
        ServerLocator backupLocator = this.createInVMLocator(server);
        ClientSessionFactory factorybkp = this.addSessionFactory(this.createSessionFactory(backupLocator));
        ClientSession sessionbkp = factorybkp.createSession(false, false);
        sessionbkp.start();
        ClientConsumer consumerbkp = sessionbkp.createConsumer(ADDRESS);
        for (int i = 0; i < numberOfMessages; ++i) {
            ClientMessage msg = consumerbkp.receive(1000L);
            Assertions.assertNotNull((Object)msg);
            msg.acknowledge();
            sessionbkp.commit();
        }
        sessionbkp.close();
        factorybkp.close();
        backupLocator.close();
    }

    @Test
    public void testFailoverFailed() throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(1);
        this.sf = this.createSessionFactoryAndWaitForTopology((ServerLocator)this.locator, 2);
        this.backupServer.stop();
        CountDownLatch failureLatch = new CountDownLatch(1);
        CountDownLatch failureDoneLatch = new CountDownLatch(1);
        SessionFactoryFailoverListener listener = new SessionFactoryFailoverListener(failureLatch, failureDoneLatch);
        this.sf.addFailoverListener((FailoverEventListener)listener);
        ClientSession session = this.sendAndConsume((ClientSessionFactory)this.sf, true);
        this.primaryServer.crash(session);
        Assertions.assertTrue((boolean)failureLatch.await(5L, TimeUnit.SECONDS));
        Assertions.assertEquals((Object)FailoverEventType.FAILURE_DETECTED, (Object)listener.getFailoverEventType().get(0));
        Assertions.assertTrue((boolean)failureDoneLatch.await(5L, TimeUnit.SECONDS));
        Assertions.assertEquals((Object)FailoverEventType.FAILOVER_FAILED, (Object)listener.getFailoverEventType().get(1));
        Assertions.assertEquals((int)2, (int)listener.getFailoverEventType().size(), (String)"Expected 2 FailoverEvents to be triggered");
        session.close();
        this.wrapUpSessionFactory();
    }

    private void createSessionFactory(int members) throws Exception {
        this.locator.setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setReconnectAttempts(15);
        this.sf = this.createSessionFactoryAndWaitForTopology((ServerLocator)this.locator, members);
    }

    private void wrapUpSessionFactory() {
        this.sf.close();
        Assertions.assertEquals((int)0, (int)this.sf.numSessions(), (String)"Expecting 0 sessions");
        Assertions.assertEquals((int)0, (int)this.sf.numConnections(), (String)"Expecting 0 connections");
    }

    @Override
    protected void createConfigs() throws Exception {
        this.nodeManager = new InVMNodeManager(false);
        TransportConfiguration primaryConnector = this.getConnectorTransportConfiguration(true);
        TransportConfiguration backupConnector = this.getConnectorTransportConfiguration(false);
        this.backupConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(false)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreBackupPolicyConfiguration()).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector).addClusterConfiguration(FailoverListenerTest.basicClusterConnectionConfig(backupConnector.getName(), primaryConnector.getName()));
        this.backupServer = this.createTestableServer(this.backupConfig);
        this.primaryConfig = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(this.getAcceptorTransportConfiguration(true)).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).addClusterConfiguration(FailoverListenerTest.basicClusterConnectionConfig(primaryConnector.getName(), backupConnector.getName())).addConnectorConfiguration(primaryConnector.getName(), primaryConnector).addConnectorConfiguration(backupConnector.getName(), backupConnector);
        this.primaryServer = this.createTestableServer(this.primaryConfig);
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean primary) {
        return TransportConfigurationUtils.getInVMAcceptor(primary);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean primary) {
        return TransportConfigurationUtils.getInVMConnector(primary);
    }

    private ClientSession sendAndConsume(ClientSessionFactory sf, boolean createQueue) throws Exception {
        ClientSession session = sf.createSession(false, true, true);
        if (createQueue) {
            session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
        }
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 1000;
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.putIntProperty(SimpleString.of((String)"count"), i);
            message.getBodyBuffer().writeString("aardvarks");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        for (int i = 0; i < 1000; ++i) {
            ClientMessage message2 = consumer.receive();
            Assertions.assertEquals((Object)"aardvarks", (Object)message2.getBodyBuffer().readString());
            Assertions.assertEquals((Object)i, (Object)message2.getObjectProperty(SimpleString.of((String)"count")));
            message2.acknowledge();
        }
        ClientMessage message3 = consumer.receiveImmediate();
        consumer.close();
        Assertions.assertNull((Object)message3);
        return session;
    }

    public class SessionFactoryFailoverListener
    implements FailoverEventListener {
        private final ArrayList<FailoverEventType> failoverTypeEvent = new ArrayList();
        private final CountDownLatch failureLatch;
        private final CountDownLatch failureDoneLatch;

        public SessionFactoryFailoverListener(CountDownLatch failureLatch, CountDownLatch failureDoneLatch) {
            this.failureLatch = failureLatch;
            this.failureDoneLatch = failureDoneLatch;
        }

        public ArrayList<FailoverEventType> getFailoverEventType() {
            return this.failoverTypeEvent;
        }

        public void failoverEvent(FailoverEventType eventType) {
            this.failoverTypeEvent.add(eventType);
            logger.debug("Failover event just happen : {}", (Object)eventType.toString());
            if (eventType == FailoverEventType.FAILURE_DETECTED) {
                this.failureLatch.countDown();
            } else if (eventType == FailoverEventType.FAILOVER_COMPLETED || eventType == FailoverEventType.FAILOVER_FAILED) {
                this.failureDoneLatch.countDown();
            }
        }
    }
}

