/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.storage.DatabaseStorageConfiguration;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.core.server.impl.jdbc.JdbcNodeManager;
import org.apache.activemq.artemis.tests.extensions.ThreadLeakCheckExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameter;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.apache.activemq.artemis.utils.ExecutorFactory;
import org.apache.activemq.artemis.utils.actors.OrderedExecutorFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class FileLockNodeManagerTest
extends FailoverTestBase {
    @Parameter(index=0)
    public NodeManagerType nodeManagerType;
    @Parameter(index=1)
    public boolean useSeparateLockFolder;
    private List<ScheduledExecutorService> scheduledExecutorServices = new ArrayList<ScheduledExecutorService>();
    private List<ExecutorService> executors = new ArrayList<ExecutorService>();

    protected ClientSession createSession(ClientSessionFactory sf1, boolean autoCommitSends, boolean autoCommitAcks, int ackBatchSize) throws Exception {
        return this.addClientSession(sf1.createSession(autoCommitSends, autoCommitAcks, ackBatchSize));
    }

    protected ClientSession createSession(ClientSessionFactory sf1, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.addClientSession(sf1.createSession(autoCommitSends, autoCommitAcks));
    }

    protected ClientSession createSession(ClientSessionFactory sf1) throws Exception {
        return this.addClientSession(sf1.createSession());
    }

    protected ClientSession createSession(ClientSessionFactory sf1, boolean xa, boolean autoCommitSends, boolean autoCommitAcks) throws Exception {
        return this.addClientSession(sf1.createSession(xa, autoCommitSends, autoCommitAcks));
    }

    @Parameters(name="{0} Node Manager, Use Separate Lock Folder = {1}")
    public static Iterable<? extends Object> nodeManagerTypes() {
        return Arrays.asList({NodeManagerType.File, false}, {NodeManagerType.File, true});
    }

    @Override
    protected TransportConfiguration getAcceptorTransportConfiguration(boolean live) {
        return this.getNettyAcceptorTransportConfiguration(live);
    }

    @Override
    protected TransportConfiguration getConnectorTransportConfiguration(boolean live) {
        return this.getNettyConnectorTransportConfiguration(live);
    }

    @Override
    protected NodeManager createReplicatedBackupNodeManager(Configuration backupConfig) {
        Assumptions.assumeTrue((this.nodeManagerType == NodeManagerType.InVM ? 1 : 0) != 0, (String)("Replicated backup is supported only by " + NodeManagerType.InVM + " Node Manager"));
        return super.createReplicatedBackupNodeManager(backupConfig);
    }

    @Override
    protected Configuration createDefaultInVMConfig() throws Exception {
        Configuration config = super.createDefaultInVMConfig();
        if (this.useSeparateLockFolder) {
            config.setNodeManagerLockDirectory(this.getTestDir() + "/nm_lock");
        }
        return config;
    }

    @Override
    protected NodeManager createNodeManager() throws Exception {
        switch (this.nodeManagerType) {
            case InVM: {
                return new InVMNodeManager(false);
            }
            case Jdbc: {
                ThreadFactory daemonThreadFactory = t -> {
                    Thread th = new Thread(t);
                    th.setDaemon(true);
                    return th;
                };
                ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(daemonThreadFactory);
                this.scheduledExecutorServices.add(scheduledExecutorService);
                ExecutorService executor = Executors.newFixedThreadPool(2, daemonThreadFactory);
                this.executors.add(executor);
                DatabaseStorageConfiguration dbConf = this.createDefaultDatabaseStorageConfiguration();
                OrderedExecutorFactory executorFactory = new OrderedExecutorFactory((Executor)executor);
                return JdbcNodeManager.with((DatabaseStorageConfiguration)dbConf, (ScheduledExecutorService)scheduledExecutorService, (ExecutorFactory)executorFactory);
            }
            case File: {
                Configuration config = this.createDefaultInVMConfig();
                if (this.useSeparateLockFolder) {
                    config.getNodeManagerLockLocation().mkdirs();
                }
                return new FileLockNodeManager(config.getNodeManagerLockLocation(), false);
            }
        }
        throw new AssertionError((Object)"enum type not supported!");
    }

    @Override
    protected TestableServer createTestableServer(Configuration config) throws Exception {
        boolean isBackup = config.getHAPolicyConfiguration() instanceof ReplicaPolicyConfiguration || config.getHAPolicyConfiguration() instanceof SharedStoreBackupPolicyConfiguration;
        NodeManager nodeManager = this.nodeManager;
        if (isBackup && (this.nodeManagerType == NodeManagerType.Jdbc || this.nodeManagerType == NodeManagerType.File)) {
            nodeManager = this.createNodeManager();
        }
        return new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config, nodeManager, isBackup ? 2 : 1));
    }

    @AfterEach
    public void shutDownExecutors() {
        if (!this.scheduledExecutorServices.isEmpty()) {
            ThreadLeakCheckExtension.addKownThread((String)"oracle.jdbc.driver.BlockSource.ThreadedCachingBlockSource.BlockReleaser");
            this.executors.forEach(ExecutorService::shutdown);
            this.scheduledExecutorServices.forEach(ExecutorService::shutdown);
            this.executors.clear();
            this.scheduledExecutorServices.clear();
        }
    }

    @TestTemplate
    @Timeout(value=120L)
    public void testSimpleFailover() throws Exception {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", "127.0.0.1");
        TransportConfiguration tc = FileLockNodeManagerTest.createTransportConfiguration(true, false, params);
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithHA((TransportConfiguration[])new TransportConfiguration[]{tc})).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(150).setRetryInterval(10L);
        ClientSessionFactoryInternal sf = this.createSessionFactoryAndWaitForTopology(locator, 2);
        ClientSession session = this.createSession((ClientSessionFactory)sf, true, true, 0);
        session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
        ClientProducer producer = session.createProducer(ADDRESS);
        int numMessages = 10;
        ClientConsumer consumer = session.createConsumer(ADDRESS);
        session.start();
        this.crash(session);
        this.sendMessages(session, producer, 10);
        this.receiveMessages(consumer, 0, 10, true);
        session.close();
        sf.close();
        Assertions.assertEquals((int)0, (int)sf.numSessions());
        Assertions.assertEquals((int)0, (int)sf.numConnections());
    }

    public static enum NodeManagerType {
        InVM,
        Jdbc,
        File;

    }
}

