/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.impl.InVMNodeManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.MultipleBackupsFailoverTestBase;
import org.apache.activemq.artemis.tests.integration.cluster.util.SameProcessActiveMQServer;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiplePrimariesMultipleBackupsFailoverTest
extends MultipleBackupsFailoverTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Map<Integer, TestableServer> servers = new HashMap<Integer, TestableServer>();
    private ServerLocator locator2;
    private ServerLocator locator;
    private final boolean sharedStore = true;

    @Test
    public void testMultipleFailovers2PrimaryServers() throws Exception {
        InVMNodeManager nodeManager1 = new InVMNodeManager(false);
        InVMNodeManager nodeManager2 = new InVMNodeManager(false);
        this.createPrimaryConfig((NodeManager)nodeManager1, 0, 3, 4, 5);
        this.createBackupConfig((NodeManager)nodeManager1, 0, 1, true, new int[]{0, 2}, 3, 4, 5);
        this.createBackupConfig((NodeManager)nodeManager1, 0, 2, true, new int[]{0, 1}, 3, 4, 5);
        this.createPrimaryConfig((NodeManager)nodeManager2, 3, 0);
        this.createBackupConfig((NodeManager)nodeManager2, 3, 4, true, new int[]{3, 5}, 0, 1, 2);
        this.createBackupConfig((NodeManager)nodeManager2, 3, 5, true, new int[]{3, 4}, 0, 1, 2);
        this.servers.get(0).start();
        this.waitForServerToStart(this.servers.get(0).getServer());
        this.servers.get(3).start();
        this.waitForServerToStart(this.servers.get(3).getServer());
        this.servers.get(1).start();
        this.waitForServerToStart(this.servers.get(1).getServer());
        this.servers.get(2).start();
        this.servers.get(4).start();
        this.waitForServerToStart(this.servers.get(4).getServer());
        this.servers.get(5).start();
        this.waitForServerToStart(this.servers.get(4).getServer());
        this.locator = this.getServerLocator(0).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(15);
        ClientSessionFactoryInternal sf = this.createSessionFactoryAndWaitForTopology(this.locator, 4, this.servers.get(0).getServer());
        ClientSession session = this.sendAndConsume((ClientSessionFactory)sf, true);
        logger.debug(((ServerLocatorInternal)this.locator).getTopology().describe());
        Thread.sleep(500L);
        this.servers.get(0).crash(session);
        int primaryAfter0 = this.waitForNewPrimary(10000L, true, this.servers, 1, 2);
        this.locator2 = this.getServerLocator(3).setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true).setReconnectAttempts(15);
        ClientSessionFactoryInternal sf2 = this.createSessionFactoryAndWaitForTopology(this.locator2, 4);
        ClientSession session2 = this.sendAndConsume((ClientSessionFactory)sf2, true);
        System.setProperty("foo", "bar");
        this.servers.get(3).crash(session2);
        int liveAfter3 = this.waitForNewPrimary(10000L, true, this.servers, 4, 5);
        this.locator.close();
        this.locator2.close();
        if (primaryAfter0 == 2) {
            Thread.sleep(500L);
            this.servers.get(1).stop();
            Thread.sleep(500L);
            this.servers.get(2).stop();
        } else {
            Thread.sleep(500L);
            this.servers.get(2).stop();
            Thread.sleep(500L);
            this.servers.get(1).stop();
        }
        if (liveAfter3 == 4) {
            Thread.sleep(500L);
            this.servers.get(5).stop();
            Thread.sleep(500L);
            this.servers.get(4).stop();
        } else {
            Thread.sleep(500L);
            this.servers.get(4).stop();
            Thread.sleep(500L);
            this.servers.get(5).stop();
        }
    }

    protected void createBackupConfig(NodeManager nodeManager, int primaryNode, int nodeid, boolean createClusterConnections, int[] otherBackupNodes, int ... otherClusterNodes) throws Exception {
        Configuration config1 = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(MultiplePrimariesMultipleBackupsFailoverTest.createTransportConfiguration(this.isNetty(), true, MultiplePrimariesMultipleBackupsFailoverTest.generateParams(nodeid, this.isNetty()))).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreBackupPolicyConfiguration()).setBindingsDirectory(this.getBindingsDir() + "_" + primaryNode).setJournalDirectory(this.getJournalDir() + "_" + primaryNode).setPagingDirectory(this.getPageDir() + "_" + primaryNode).setLargeMessagesDirectory(this.getLargeMessagesDir() + "_" + primaryNode);
        for (int node : otherBackupNodes) {
            TransportConfiguration primaryConnector = MultiplePrimariesMultipleBackupsFailoverTest.createTransportConfiguration(this.isNetty(), false, MultiplePrimariesMultipleBackupsFailoverTest.generateParams(node, this.isNetty()));
            config1.addConnectorConfiguration(primaryConnector.getName(), primaryConnector);
        }
        TransportConfiguration backupConnector = MultiplePrimariesMultipleBackupsFailoverTest.createTransportConfiguration(this.isNetty(), false, MultiplePrimariesMultipleBackupsFailoverTest.generateParams(nodeid, this.isNetty()));
        config1.addConnectorConfiguration(backupConnector.getName(), backupConnector);
        String[] clusterNodes = new String[otherClusterNodes.length];
        for (int i = 0; i < otherClusterNodes.length; ++i) {
            TransportConfiguration connector = MultiplePrimariesMultipleBackupsFailoverTest.createTransportConfiguration(this.isNetty(), false, MultiplePrimariesMultipleBackupsFailoverTest.generateParams(otherClusterNodes[i], this.isNetty()));
            config1.addConnectorConfiguration(connector.getName(), connector);
            clusterNodes[i] = connector.getName();
        }
        config1.addClusterConfiguration(MultiplePrimariesMultipleBackupsFailoverTest.basicClusterConnectionConfig(backupConnector.getName(), clusterNodes));
        this.servers.put(nodeid, new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config1, nodeManager, primaryNode)));
    }

    protected void createPrimaryConfig(NodeManager nodeManager, int primaryNode, int ... otherPrimaryNodes) throws Exception {
        TransportConfiguration primaryConnector = MultiplePrimariesMultipleBackupsFailoverTest.createTransportConfiguration(this.isNetty(), false, MultiplePrimariesMultipleBackupsFailoverTest.generateParams(primaryNode, this.isNetty()));
        Configuration config0 = super.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(MultiplePrimariesMultipleBackupsFailoverTest.createTransportConfiguration(this.isNetty(), true, MultiplePrimariesMultipleBackupsFailoverTest.generateParams(primaryNode, this.isNetty()))).setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration()).setBindingsDirectory(this.getBindingsDir() + "_" + primaryNode).setJournalDirectory(this.getJournalDir() + "_" + primaryNode).setPagingDirectory(this.getPageDir() + "_" + primaryNode).setLargeMessagesDirectory(this.getLargeMessagesDir() + "_" + primaryNode).addConnectorConfiguration(primaryConnector.getName(), primaryConnector);
        String[] pairs = new String[otherPrimaryNodes.length];
        for (int i = 0; i < otherPrimaryNodes.length; ++i) {
            TransportConfiguration otherPrimaryConnector = MultiplePrimariesMultipleBackupsFailoverTest.createTransportConfiguration(this.isNetty(), false, MultiplePrimariesMultipleBackupsFailoverTest.generateParams(otherPrimaryNodes[i], this.isNetty()));
            config0.addConnectorConfiguration(otherPrimaryConnector.getName(), otherPrimaryConnector);
            pairs[i] = otherPrimaryConnector.getName();
        }
        config0.addClusterConfiguration(MultiplePrimariesMultipleBackupsFailoverTest.basicClusterConnectionConfig(primaryConnector.getName(), pairs));
        this.servers.put(primaryNode, new SameProcessActiveMQServer(this.createInVMFailoverServer(true, config0, nodeManager, primaryNode)));
    }

    @Override
    protected boolean isNetty() {
        return false;
    }
}

