/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.discovery;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.BroadcastEndpoint;
import org.apache.activemq.artemis.api.core.BroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.JGroupsFileBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.jgroups.JChannelManager;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.core.cluster.DiscoveryGroup;
import org.apache.activemq.artemis.core.cluster.DiscoveryListener;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.core.server.cluster.BroadcastGroup;
import org.apache.activemq.artemis.core.server.cluster.impl.BroadcastGroupImpl;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationService;
import org.apache.activemq.artemis.tests.integration.SimpleNotificationService;
import org.apache.activemq.artemis.tests.integration.discovery.DiscoveryBaseTest;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryTest
extends DiscoveryBaseTest {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String TEST_JGROUPS_CONF_FILE = "test-jgroups-file_ping.xml";
    BroadcastGroup bg = null;
    BroadcastGroup bg1 = null;
    BroadcastGroup bg2 = null;
    BroadcastGroup bg3 = null;
    DiscoveryGroup dg = null;
    DiscoveryGroup dg1 = null;
    DiscoveryGroup dg2 = null;
    DiscoveryGroup dg3 = null;

    @BeforeEach
    public void prepareLoopback() {
        JChannelManager.getInstance().setLoopbackMessages(true);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        JChannelManager.getInstance().clear().setLoopbackMessages(false);
        DiscoveryTest.deleteDirectory(new File("./target/tmp/amqtest.ping.dir"));
        for (ActiveMQComponent component : new ActiveMQComponent[]{this.bg, this.bg1, this.bg2, this.bg3, this.dg, this.dg1, this.dg2, this.dg3}) {
            DiscoveryTest.stopComponent(component);
        }
        super.tearDown();
    }

    @Test
    public void testSimpleBroadcast() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        String nodeID = RandomUtil.randomString();
        this.bg = this.newBroadcast(nodeID, RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        this.dg.start();
        DiscoveryTest.verifyBroadcast(this.bg, this.dg);
        List entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
    }

    @Test
    public void testSimpleBroadcastJGropus() throws Exception {
        String nodeID = RandomUtil.randomString();
        this.bg = new BroadcastGroupImpl((NodeManager)new DiscoveryBaseTest.FakeNodeManager(nodeID), "broadcast", 100L, null, (BroadcastEndpointFactory)new JGroupsFileBroadcastEndpointFactory().setChannelName("tst").setFile(TEST_JGROUPS_CONF_FILE));
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        this.dg = new DiscoveryGroup(nodeID + "1", "broadcast", 5000L, (BroadcastEndpointFactory)new JGroupsFileBroadcastEndpointFactory().setChannelName("tst").setFile(TEST_JGROUPS_CONF_FILE), null);
        this.dg.start();
        DiscoveryTest.verifyBroadcast(this.bg, this.dg);
        List entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
    }

    @Test
    public void testJGroupsOpenClientInitializesChannel() throws Exception {
        JGroupsFileBroadcastEndpointFactory factory = new JGroupsFileBroadcastEndpointFactory().setFile(TEST_JGROUPS_CONF_FILE).setChannelName("tst");
        BroadcastEndpoint endpoint = factory.createBroadcastEndpoint();
        endpoint.close(false);
        endpoint.openClient();
        endpoint.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJGropusChannelReferenceCounting() throws Exception {
        JGroupsFileBroadcastEndpointFactory factory = new JGroupsFileBroadcastEndpointFactory().setChannelName("tst").setFile(TEST_JGROUPS_CONF_FILE);
        BroadcastEndpoint broadcaster = factory.createBroadcastEndpoint();
        broadcaster.openBroadcaster();
        try {
            int i;
            int num = 100;
            BroadcastEndpoint[] receivers = new BroadcastEndpoint[num];
            for (int i2 = 0; i2 < num; ++i2) {
                receivers[i2] = factory.createBroadcastEndpoint();
                receivers[i2].openClient();
            }
            byte[] data = new byte[]{1, 2, 3, 4, 5};
            broadcaster.broadcast(data);
            for (i = 0; i < num; ++i) {
                byte[] received = receivers[i].receiveBroadcast(5000L, TimeUnit.MILLISECONDS);
                Assertions.assertNotNull((Object)received);
                Assertions.assertEquals((int)5, (int)received.length);
                Assertions.assertEquals((int)1, (int)received[0]);
                Assertions.assertEquals((int)2, (int)received[1]);
                Assertions.assertEquals((int)3, (int)received[2]);
                Assertions.assertEquals((int)4, (int)received[3]);
                Assertions.assertEquals((int)5, (int)received[4]);
            }
            for (i = 0; i < num - 1; ++i) {
                receivers[i].close(false);
            }
            byte[] data1 = receivers[num - 1].receiveBroadcast(5L, TimeUnit.SECONDS);
            Assertions.assertNull((Object)data1);
            broadcaster.broadcast(data);
            data1 = receivers[num - 1].receiveBroadcast(5L, TimeUnit.SECONDS);
            Assertions.assertNotNull((Object)data1);
            Assertions.assertEquals((int)5, (int)data1.length);
            Assertions.assertEquals((int)1, (int)data1[0]);
            Assertions.assertEquals((int)2, (int)data1[1]);
            Assertions.assertEquals((int)3, (int)data1[2]);
            Assertions.assertEquals((int)4, (int)data1[3]);
            Assertions.assertEquals((int)5, (int)data1[4]);
            receivers[num - 1].close(false);
        }
        finally {
            broadcaster.close(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJGropusChannelReferenceCounting1() throws Exception {
        JGroupsFileBroadcastEndpointFactory factory = new JGroupsFileBroadcastEndpointFactory().setChannelName("tst").setFile(TEST_JGROUPS_CONF_FILE);
        BroadcastEndpoint broadcaster = factory.createBroadcastEndpoint();
        broadcaster.openBroadcaster();
        int num = 50;
        BroadcastEndpoint[] receivers = new BroadcastEndpoint[num];
        for (int i = 0; i < num; ++i) {
            receivers[i] = factory.createBroadcastEndpoint();
            receivers[i].openClient();
        }
        try {
            byte[] received;
            int i;
            byte[] data = new byte[]{1, 2, 3, 4, 5};
            broadcaster.broadcast(data);
            for (i = 0; i < num; ++i) {
                received = receivers[i].receiveBroadcast(5000L, TimeUnit.MILLISECONDS);
                Assertions.assertNotNull((Object)received);
                Assertions.assertEquals((int)5, (int)received.length);
                Assertions.assertEquals((int)1, (int)received[0]);
                Assertions.assertEquals((int)2, (int)received[1]);
                Assertions.assertEquals((int)3, (int)received[2]);
                Assertions.assertEquals((int)4, (int)received[3]);
                Assertions.assertEquals((int)5, (int)received[4]);
            }
            for (i = 0; i < num; ++i) {
                receivers[i].close(false);
            }
            for (i = 0; i < num; ++i) {
                receivers[i] = factory.createBroadcastEndpoint();
                receivers[i].openClient();
            }
            broadcaster.broadcast(data);
            for (i = 0; i < num; ++i) {
                received = receivers[i].receiveBroadcast(5000L, TimeUnit.MILLISECONDS);
                Assertions.assertNotNull((Object)received);
                Assertions.assertEquals((int)5, (int)received.length);
                Assertions.assertEquals((int)1, (int)received[0]);
                Assertions.assertEquals((int)2, (int)received[1]);
                Assertions.assertEquals((int)3, (int)received[2]);
                Assertions.assertEquals((int)4, (int)received[3]);
                Assertions.assertEquals((int)5, (int)received[4]);
            }
        }
        finally {
            for (int i = 0; i < num; ++i) {
                receivers[i].close(false);
            }
            broadcaster.close(true);
        }
    }

    @Test
    public void testJGropusChannelReferenceCounting2() throws Exception {
        byte[] received;
        int i;
        int i2;
        JGroupsFileBroadcastEndpointFactory factory = new JGroupsFileBroadcastEndpointFactory().setChannelName("tst").setFile(TEST_JGROUPS_CONF_FILE);
        BroadcastEndpoint broadcaster = factory.createBroadcastEndpoint();
        broadcaster.openBroadcaster();
        int num = 50;
        BroadcastEndpoint[] receivers = new BroadcastEndpoint[num];
        for (i2 = 0; i2 < num; ++i2) {
            receivers[i2] = factory.createBroadcastEndpoint();
            receivers[i2].openClient();
        }
        for (i2 = 0; i2 < num / 2; ++i2) {
            receivers[i2].close(false);
        }
        for (i2 = 0; i2 < num / 2; ++i2) {
            receivers[i2] = factory.createBroadcastEndpoint();
            receivers[i2].openClient();
        }
        int num2 = 10;
        BroadcastEndpoint[] moreReceivers = new BroadcastEndpoint[num2];
        for (int i3 = 0; i3 < num2; ++i3) {
            moreReceivers[i3] = factory.createBroadcastEndpoint();
            moreReceivers[i3].openClient();
        }
        byte[] data = new byte[]{1, 2, 3, 4, 5};
        broadcaster.broadcast(data);
        for (i = 0; i < num; ++i) {
            received = receivers[i].receiveBroadcast(5000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)received);
            Assertions.assertEquals((int)5, (int)received.length);
            Assertions.assertEquals((int)1, (int)received[0]);
            Assertions.assertEquals((int)2, (int)received[1]);
            Assertions.assertEquals((int)3, (int)received[2]);
            Assertions.assertEquals((int)4, (int)received[3]);
            Assertions.assertEquals((int)5, (int)received[4]);
        }
        for (i = 0; i < num2; ++i) {
            received = moreReceivers[i].receiveBroadcast(5000L, TimeUnit.MILLISECONDS);
            Assertions.assertNotNull((Object)received);
            Assertions.assertEquals((int)5, (int)received.length);
            Assertions.assertEquals((int)1, (int)received[0]);
            Assertions.assertEquals((int)2, (int)received[1]);
            Assertions.assertEquals((int)3, (int)received[2]);
            Assertions.assertEquals((int)4, (int)received[3]);
            Assertions.assertEquals((int)5, (int)received[4]);
        }
        for (i = 0; i < num; ++i) {
            receivers[i].close(false);
        }
        for (i = 0; i < num2; ++i) {
            moreReceivers[i].close(false);
        }
        broadcaster.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStraightSendReceiveJGroups() throws Exception {
        BroadcastEndpoint broadcaster = null;
        BroadcastEndpoint client = null;
        try {
            JGroupsFileBroadcastEndpointFactory endpointFactory = new JGroupsFileBroadcastEndpointFactory().setChannelName("tst").setFile(TEST_JGROUPS_CONF_FILE);
            broadcaster = endpointFactory.createBroadcastEndpoint();
            broadcaster.openBroadcaster();
            client = endpointFactory.createBroadcastEndpoint();
            client.openClient();
            Thread.sleep(1000L);
            byte[] randomBytes = "PQP".getBytes();
            broadcaster.broadcast(randomBytes);
            byte[] btreceived = client.receiveBroadcast(5L, TimeUnit.SECONDS);
            logger.debug("BTReceived = {}", (Object)Arrays.toString(btreceived));
            Assertions.assertNotNull((Object)btreceived);
            Assertions.assertEquals((int)randomBytes.length, (int)btreceived.length);
            for (int i = 0; i < randomBytes.length; ++i) {
                Assertions.assertEquals((byte)randomBytes[i], (byte)btreceived[i]);
            }
        }
        finally {
            try {
                if (broadcaster != null) {
                    broadcaster.close(true);
                }
                if (client != null) {
                    client.close(false);
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
    }

    @Test
    public void testSimpleBroadcastSpecificNIC() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        String nodeID = RandomUtil.randomString();
        Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
        InetAddress localAddress = InetAddress.getLoopbackAddress();
        logger.debug("Local address is {}", (Object)localAddress);
        this.bg = this.newBroadcast(nodeID, RandomUtil.randomString(), localAddress, -1, groupAddress, groupPort);
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), localAddress, groupAddress, groupPort, 500L);
        this.dg.start();
        DiscoveryTest.verifyBroadcast(this.bg, this.dg);
        List entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
    }

    @Test
    public void testSimpleBroadcastWithStopStartDiscoveryGroup() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        String nodeID = RandomUtil.randomString();
        this.bg = this.newBroadcast(nodeID, RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        this.dg.start();
        DiscoveryTest.verifyBroadcast(this.bg, this.dg);
        List entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
        this.bg.stop();
        this.dg.stop();
        this.dg.start();
        this.bg.start();
        DiscoveryTest.verifyBroadcast(this.bg, this.dg);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
    }

    @Test
    public void testIgnoreTrafficFromOwnNode() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        String nodeID = RandomUtil.randomString();
        this.bg = this.newBroadcast(nodeID, RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        this.dg = this.newDiscoveryGroup(nodeID, RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        this.dg.start();
        DiscoveryTest.verifyNonBroadcast(this.bg, this.dg);
        List entries = this.dg.getDiscoveryEntries();
        Assertions.assertNotNull((Object)entries);
        Assertions.assertEquals((int)0, (int)entries.size());
    }

    @Test
    public void testSimpleBroadcastDifferentPort() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(DiscoveryTest.getUDPDiscoveryAddress());
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        this.bg = this.newBroadcast(RandomUtil.randomString(), RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        int port2 = DiscoveryTest.getUDPDiscoveryPort(1);
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, port2, 500L);
        this.dg.start();
        DiscoveryTest.verifyNonBroadcast(this.bg, this.dg);
    }

    @Test
    public void testSimpleBroadcastDifferentAddressAndPort() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        this.bg = this.newBroadcast(RandomUtil.randomString(), RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        InetAddress groupAddress2 = InetAddress.getByName(this.address2);
        int port2 = DiscoveryTest.getUDPDiscoveryPort(1);
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress2, port2, 500L);
        this.dg.start();
        DiscoveryTest.verifyNonBroadcast(this.bg, this.dg);
    }

    @Test
    public void testMultipleGroups() throws Exception {
        int groupPort1 = DiscoveryTest.getUDPDiscoveryPort();
        int groupPort2 = DiscoveryTest.getUDPDiscoveryPort(1);
        int groupPort3 = DiscoveryTest.getUDPDiscoveryPort(2);
        InetAddress groupAddress1 = InetAddress.getByName(this.address1);
        InetAddress groupAddress2 = InetAddress.getByName(this.address2);
        InetAddress groupAddress3 = InetAddress.getByName(this.address3);
        int timeout = 5000;
        String node1 = UUIDGenerator.getInstance().generateStringUUID();
        String node2 = UUIDGenerator.getInstance().generateStringUUID();
        String node3 = UUIDGenerator.getInstance().generateStringUUID();
        this.bg1 = this.newBroadcast(node1, RandomUtil.randomString(), null, -1, groupAddress1, groupPort1);
        this.bg2 = this.newBroadcast(node2, RandomUtil.randomString(), null, -1, groupAddress2, groupPort2);
        this.bg3 = this.newBroadcast(node3, RandomUtil.randomString(), null, -1, groupAddress3, groupPort3);
        this.bg2.start();
        this.bg1.start();
        this.bg3.start();
        TransportConfiguration live1 = this.generateTC("live1");
        TransportConfiguration live2 = this.generateTC("live2");
        TransportConfiguration live3 = this.generateTC("live3");
        this.bg1.addConnector(live1);
        this.bg2.addConnector(live2);
        this.bg3.addConnector(live3);
        this.dg1 = this.newDiscoveryGroup("group-1::" + RandomUtil.randomString(), "group-1::" + RandomUtil.randomString(), null, groupAddress1, groupPort1, 5000L);
        this.dg1.start();
        this.dg2 = this.newDiscoveryGroup("group-2::" + RandomUtil.randomString(), "group-2::" + RandomUtil.randomString(), null, groupAddress2, groupPort2, 5000L);
        this.dg2.start();
        this.dg3 = this.newDiscoveryGroup("group-3::" + RandomUtil.randomString(), "group-3::" + RandomUtil.randomString(), null, groupAddress3, groupPort3, 5000L);
        this.dg3.start();
        this.bg1.broadcastConnectors();
        this.bg2.broadcastConnectors();
        this.bg3.broadcastConnectors();
        boolean ok = this.dg1.waitForBroadcast(5000L);
        Assertions.assertTrue((boolean)ok);
        List entries = this.dg1.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
        ok = this.dg2.waitForBroadcast(5000L);
        Assertions.assertTrue((boolean)ok);
        entries = this.dg2.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live2), entries);
        ok = this.dg3.waitForBroadcast(5000L);
        Assertions.assertTrue((boolean)ok);
        entries = this.dg3.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live3), entries);
    }

    @Test
    public void testDiscoveryListenersCalled() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        String nodeID = RandomUtil.randomString();
        this.bg = this.newBroadcast(nodeID, RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        DiscoveryBaseTest.MyListener listener1 = new DiscoveryBaseTest.MyListener();
        DiscoveryBaseTest.MyListener listener2 = new DiscoveryBaseTest.MyListener();
        DiscoveryBaseTest.MyListener listener3 = new DiscoveryBaseTest.MyListener();
        this.dg.registerListener((DiscoveryListener)listener1);
        this.dg.registerListener((DiscoveryListener)listener2);
        this.dg.registerListener((DiscoveryListener)listener3);
        this.dg.start();
        DiscoveryTest.verifyBroadcast(this.bg, this.dg);
        Assertions.assertTrue((boolean)listener1.called);
        Assertions.assertTrue((boolean)listener2.called);
        Assertions.assertTrue((boolean)listener3.called);
        listener1.called = false;
        listener2.called = false;
        listener3.called = false;
        DiscoveryTest.verifyBroadcast(this.bg, this.dg);
        Assertions.assertFalse((boolean)listener1.called);
        Assertions.assertFalse((boolean)listener2.called);
        Assertions.assertFalse((boolean)listener3.called);
    }

    @Test
    public void testConnectorsUpdatedMultipleBroadcasters() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        String node1 = RandomUtil.randomString();
        String node2 = RandomUtil.randomString();
        String node3 = RandomUtil.randomString();
        this.bg1 = this.newBroadcast(node1, RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg1.start();
        this.bg2 = this.newBroadcast(node2, RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg2.start();
        this.bg3 = this.newBroadcast(node3, RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg3.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg1.addConnector(live1);
        TransportConfiguration live2 = this.generateTC();
        this.bg2.addConnector(live2);
        TransportConfiguration live3 = this.generateTC();
        this.bg3.addConnector(live3);
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        DiscoveryBaseTest.MyListener listener1 = new DiscoveryBaseTest.MyListener();
        this.dg.registerListener((DiscoveryListener)listener1);
        DiscoveryBaseTest.MyListener listener2 = new DiscoveryBaseTest.MyListener();
        this.dg.registerListener((DiscoveryListener)listener2);
        this.dg.start();
        DiscoveryTest.verifyBroadcast(this.bg1, this.dg);
        List entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
        Assertions.assertTrue((boolean)listener1.called);
        Assertions.assertTrue((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        DiscoveryTest.verifyBroadcast(this.bg2, this.dg);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1, live2), entries);
        Assertions.assertTrue((boolean)listener1.called);
        Assertions.assertTrue((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        DiscoveryTest.verifyBroadcast(this.bg3, this.dg);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1, live2, live3), entries);
        Assertions.assertTrue((boolean)listener1.called);
        Assertions.assertTrue((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        DiscoveryTest.verifyBroadcast(this.bg1, this.dg);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1, live2, live3), entries);
        Assertions.assertFalse((boolean)listener1.called);
        Assertions.assertFalse((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        DiscoveryTest.verifyBroadcast(this.bg2, this.dg);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1, live2, live3), entries);
        Assertions.assertFalse((boolean)listener1.called);
        Assertions.assertFalse((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        DiscoveryTest.verifyBroadcast(this.bg3, this.dg);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1, live2, live3), entries);
        Assertions.assertFalse((boolean)listener1.called);
        Assertions.assertFalse((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        this.bg2.removeConnector(live2);
        DiscoveryTest.verifyBroadcast(this.bg2, this.dg);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1, live2, live3), entries);
        Assertions.assertFalse((boolean)listener1.called);
        Assertions.assertFalse((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        Thread.sleep(1000L);
        this.bg1.broadcastConnectors();
        boolean ok = this.dg.waitForBroadcast(1000L);
        this.bg2.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        this.bg3.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        entries = this.dg.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1, live3), entries);
        Assertions.assertTrue((boolean)listener1.called);
        Assertions.assertTrue((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        this.bg1.removeConnector(live1);
        this.bg3.removeConnector(live3);
        Thread.sleep(1000L);
        this.bg1.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        this.bg2.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        this.bg3.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        entries = this.dg.getDiscoveryEntries();
        Assertions.assertNotNull((Object)entries);
        Assertions.assertEquals((int)0, (int)entries.size());
        Assertions.assertTrue((boolean)listener1.called);
        Assertions.assertTrue((boolean)listener2.called);
        listener1.called = false;
        listener2.called = false;
        this.bg1.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        this.bg2.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        this.bg3.broadcastConnectors();
        ok = this.dg.waitForBroadcast(1000L);
        entries = this.dg.getDiscoveryEntries();
        Assertions.assertNotNull((Object)entries);
        Assertions.assertEquals((int)0, (int)entries.size());
        Assertions.assertFalse((boolean)listener1.called);
        Assertions.assertFalse((boolean)listener2.called);
    }

    @Test
    public void testMultipleDiscoveryGroups() throws Exception {
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        String nodeID = RandomUtil.randomString();
        this.bg = this.newBroadcast(nodeID, RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg.start();
        TransportConfiguration live1 = this.generateTC();
        this.bg.addConnector(live1);
        this.dg1 = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        this.dg2 = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        this.dg3 = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L);
        this.dg1.start();
        this.dg2.start();
        this.dg3.start();
        this.bg.broadcastConnectors();
        boolean ok = this.dg1.waitForBroadcast(1000L);
        Assertions.assertTrue((boolean)ok);
        List entries = this.dg1.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
        ok = this.dg2.waitForBroadcast(1000L);
        Assertions.assertTrue((boolean)ok);
        entries = this.dg2.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
        ok = this.dg3.waitForBroadcast(1000L);
        Assertions.assertTrue((boolean)ok);
        entries = this.dg3.getDiscoveryEntries();
        DiscoveryTest.assertEqualsDiscoveryEntries(Arrays.asList(live1), entries);
        this.bg.stop();
        this.dg1.stop();
        this.dg2.stop();
        this.dg3.stop();
    }

    @Test
    public void testDiscoveryGroupNotifications() throws Exception {
        SimpleNotificationService notifService = new SimpleNotificationService();
        SimpleNotificationService.Listener notifListener = new SimpleNotificationService.Listener();
        notifService.addNotificationListener(notifListener);
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        int timeout = 500;
        this.dg = this.newDiscoveryGroup(RandomUtil.randomString(), RandomUtil.randomString(), null, groupAddress, groupPort, 500L, notifService);
        Assertions.assertEquals((int)0, (int)notifListener.getNotifications().size());
        this.dg.start();
        Assertions.assertEquals((int)1, (int)notifListener.getNotifications().size());
        Notification notif = notifListener.getNotifications().get(0);
        Assertions.assertEquals((Object)CoreNotificationType.DISCOVERY_GROUP_STARTED, (Object)notif.getType());
        Assertions.assertEquals((Object)this.dg.getName(), (Object)notif.getProperties().getSimpleStringProperty(SimpleString.of((String)"name")).toString());
        this.dg.stop();
        Assertions.assertEquals((int)2, (int)notifListener.getNotifications().size());
        notif = notifListener.getNotifications().get(1);
        Assertions.assertEquals((Object)CoreNotificationType.DISCOVERY_GROUP_STOPPED, (Object)notif.getType());
        Assertions.assertEquals((Object)this.dg.getName(), (Object)notif.getProperties().getSimpleStringProperty(SimpleString.of((String)"name")).toString());
    }

    @Test
    public void testBroadcastGroupNotifications() throws Exception {
        SimpleNotificationService notifService = new SimpleNotificationService();
        SimpleNotificationService.Listener notifListener = new SimpleNotificationService.Listener();
        notifService.addNotificationListener(notifListener);
        InetAddress groupAddress = InetAddress.getByName(this.address1);
        int groupPort = DiscoveryTest.getUDPDiscoveryPort();
        this.bg = this.newBroadcast(RandomUtil.randomString(), RandomUtil.randomString(), null, -1, groupAddress, groupPort);
        this.bg.setNotificationService((NotificationService)notifService);
        Assertions.assertEquals((int)0, (int)notifListener.getNotifications().size());
        this.bg.start();
        Assertions.assertEquals((int)1, (int)notifListener.getNotifications().size());
        Notification notif = notifListener.getNotifications().get(0);
        Assertions.assertEquals((Object)CoreNotificationType.BROADCAST_GROUP_STARTED, (Object)notif.getType());
        Assertions.assertEquals((Object)this.bg.getName(), (Object)notif.getProperties().getSimpleStringProperty(SimpleString.of((String)"name")).toString());
        this.bg.stop();
        Assertions.assertEquals((int)2, (int)notifListener.getNotifications().size());
        notif = notifListener.getNotifications().get(1);
        Assertions.assertEquals((Object)CoreNotificationType.BROADCAST_GROUP_STOPPED, (Object)notif.getType());
        Assertions.assertEquals((Object)this.bg.getName(), (Object)notif.getProperties().getSimpleStringProperty(SimpleString.of((String)"name")).toString());
    }
}

