/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.journal;

import java.io.File;
import java.nio.ByteBuffer;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.aio.AIOSequentialFileFactory;
import org.apache.activemq.artemis.tests.unit.core.journal.impl.SequentialFileFactoryTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class AIOSequentialFileFactoryTest
extends SequentialFileFactoryTestBase {
    @BeforeAll
    public static void hasAIO() {
        Assumptions.assumeTrue((boolean)AIOSequentialFileFactory.isSupported(), (String)"Test case needs AIO to run");
    }

    @Override
    protected SequentialFileFactory createFactory(String folder) {
        return new AIOSequentialFileFactory(new File(folder), 10);
    }

    @Test
    public void canCreateFactoryWithMaxIOLessThenTwo() {
        AIOSequentialFileFactory factory = new AIOSequentialFileFactory(new File("ignore"), 1);
    }

    @Test
    public void testBuffer() throws Exception {
        SequentialFile file = this.factory.createSequentialFile("filtetmp.log");
        file.open();
        ByteBuffer buff = this.factory.newBuffer(10);
        Assertions.assertEquals((int)this.factory.getAlignment(), (int)buff.limit());
        file.close();
        this.factory.releaseBuffer(buff);
    }
}

