/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.JsonUtil;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.core.management.ResourceNames;
import org.apache.activemq.artemis.api.core.management.RoleInfo;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.RemoteQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.cluster.impl.RemoteQueueBindingImpl;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonString;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.Base64;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class AddressControlTest
extends ManagementTestBase {
    private ActiveMQServer server;
    protected ClientSession session;
    private ServerLocator locator;
    private ClientSessionFactory sf;

    public boolean usingCore() {
        return false;
    }

    @Test
    public void testManagementAddressAlwaysExists() throws Exception {
        ClientSession.AddressQuery query = this.session.addressQuery(SimpleString.of((String)"activemq.management"));
        Assertions.assertTrue((boolean)query.isExists());
    }

    @Test
    public void testGetAddress() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        AddressControl addressControl = this.createManagementControl(address);
        Assertions.assertEquals((Object)address.toString(), (Object)addressControl.getAddress());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testIsRetroactiveResource() throws Exception {
        SimpleString baseAddress = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString address = ResourceNames.getRetroactiveResourceAddressName((String)this.server.getInternalNamingPrefix(), (String)this.server.getConfiguration().getWildcardConfiguration().getDelimiterString(), (SimpleString)baseAddress);
        this.session.createAddress(address, RoutingType.MULTICAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        Assertions.assertTrue((boolean)addressControl.isRetroactiveResource());
    }

    @Test
    public void testGetLocalQueueNames() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString anotherQueue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address));
        RemoteQueueBindingImpl binding = new RemoteQueueBindingImpl(this.server.getStorageManager().generateID(), address, org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString(), org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString(), Long.valueOf(org.apache.activemq.artemis.utils.RandomUtil.randomLong()), null, null, org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString(), org.apache.activemq.artemis.utils.RandomUtil.randomInt() + 1, MessageLoadBalancingType.OFF);
        this.server.getPostOffice().addBinding((Binding)binding);
        AddressControl addressControl = this.createManagementControl(address);
        String[] queueNames = addressControl.getQueueNames();
        Assertions.assertEquals((int)1, (int)queueNames.length);
        Assertions.assertEquals((Object)queue.toString(), (Object)queueNames[0]);
        this.session.createQueue(QueueConfiguration.of((SimpleString)anotherQueue).setAddress(address).setDurable(Boolean.valueOf(false)));
        queueNames = addressControl.getQueueNames();
        Assertions.assertEquals((int)2, (int)queueNames.length);
        this.session.deleteQueue(queue);
        queueNames = addressControl.getQueueNames();
        Assertions.assertEquals((int)1, (int)queueNames.length);
        Assertions.assertEquals((Object)anotherQueue.toString(), (Object)queueNames[0]);
        this.session.deleteQueue(anotherQueue);
    }

    @Test
    public void testGetRemoteQueueNames() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.MULTICAST, false);
        RemoteQueueBindingImpl binding = new RemoteQueueBindingImpl(this.server.getStorageManager().generateID(), address, queue, org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString(), Long.valueOf(org.apache.activemq.artemis.utils.RandomUtil.randomLong()), null, null, org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString(), org.apache.activemq.artemis.utils.RandomUtil.randomInt() + 1, MessageLoadBalancingType.OFF);
        this.server.getPostOffice().addBinding((Binding)binding);
        AddressControl addressControl = this.createManagementControl(address);
        String[] queueNames = addressControl.getRemoteQueueNames();
        Assertions.assertEquals((int)1, (int)queueNames.length);
        Assertions.assertEquals((Object)queue.toString(), (Object)queueNames[0]);
    }

    @Test
    public void testGetAllQueueNames() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString anotherQueue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString remoteQueue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address));
        RemoteQueueBindingImpl binding = new RemoteQueueBindingImpl(this.server.getStorageManager().generateID(), address, remoteQueue, org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString(), Long.valueOf(org.apache.activemq.artemis.utils.RandomUtil.randomLong()), null, null, org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString(), org.apache.activemq.artemis.utils.RandomUtil.randomInt() + 1, MessageLoadBalancingType.OFF);
        this.server.getPostOffice().addBinding((Binding)binding);
        AddressControl addressControl = this.createManagementControl(address);
        String[] queueNames = addressControl.getAllQueueNames();
        Assertions.assertEquals((int)2, (int)queueNames.length);
        Assertions.assertTrue((boolean)Arrays.asList(queueNames).contains(queue.toString()));
        Assertions.assertTrue((boolean)Arrays.asList(queueNames).contains(remoteQueue.toString()));
        this.session.createQueue(QueueConfiguration.of((SimpleString)anotherQueue).setAddress(address).setDurable(Boolean.valueOf(false)));
        queueNames = addressControl.getAllQueueNames();
        Assertions.assertEquals((int)3, (int)queueNames.length);
        Assertions.assertTrue((boolean)Arrays.asList(queueNames).contains(anotherQueue.toString()));
        this.session.deleteQueue(queue);
        queueNames = addressControl.getAllQueueNames();
        Assertions.assertEquals((int)2, (int)queueNames.length);
        Assertions.assertTrue((boolean)Arrays.asList(queueNames).contains(anotherQueue.toString()));
        Assertions.assertFalse((boolean)Arrays.asList(queueNames).contains(queue.toString()));
        this.session.deleteQueue(anotherQueue);
    }

    @Test
    public void testGetBindingNames() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        String divertName = org.apache.activemq.artemis.utils.RandomUtil.randomString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setDurable(Boolean.valueOf(false)));
        AddressControl addressControl = this.createManagementControl(address);
        String[] bindingNames = addressControl.getBindingNames();
        Assertions.assertEquals((int)1, (int)bindingNames.length);
        Assertions.assertEquals((Object)queue.toString(), (Object)bindingNames[0]);
        this.server.getActiveMQServerControl().createDivert(divertName, RandomUtil.randomString(), address.toString(), org.apache.activemq.artemis.utils.RandomUtil.randomString(), false, null, null);
        bindingNames = addressControl.getBindingNames();
        Assertions.assertEquals((int)2, (int)bindingNames.length);
        this.session.deleteQueue(queue);
        bindingNames = addressControl.getBindingNames();
        Assertions.assertEquals((int)1, (int)bindingNames.length);
        Assertions.assertEquals((Object)divertName.toString(), (Object)bindingNames[0]);
    }

    @Test
    public void testGetRoles() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        Role role = new Role(org.apache.activemq.artemis.utils.RandomUtil.randomString(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), false, false);
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address));
        AddressControl addressControl = this.createManagementControl(address);
        Object[] roles = addressControl.getRoles();
        Assertions.assertEquals((int)0, (int)roles.length);
        HashSet<Role> newRoles = new HashSet<Role>();
        newRoles.add(role);
        this.server.getSecurityRepository().addMatch(address.toString(), newRoles);
        roles = addressControl.getRoles();
        Assertions.assertEquals((int)1, (int)roles.length);
        Object[] r = (Object[])roles[0];
        Assertions.assertEquals((Object)role.getName(), (Object)r[0]);
        Assertions.assertEquals((Object)CheckType.SEND.hasRole(role), (Object)((Boolean)r[1]));
        Assertions.assertEquals((Object)CheckType.CONSUME.hasRole(role), (Object)((Boolean)r[2]));
        Assertions.assertEquals((Object)CheckType.CREATE_DURABLE_QUEUE.hasRole(role), (Object)((Boolean)r[3]));
        Assertions.assertEquals((Object)CheckType.DELETE_DURABLE_QUEUE.hasRole(role), (Object)((Boolean)r[4]));
        Assertions.assertEquals((Object)CheckType.CREATE_NON_DURABLE_QUEUE.hasRole(role), (Object)((Boolean)r[5]));
        Assertions.assertEquals((Object)CheckType.DELETE_NON_DURABLE_QUEUE.hasRole(role), (Object)((Boolean)r[6]));
        Assertions.assertEquals((Object)CheckType.MANAGE.hasRole(role), (Object)((Boolean)r[7]));
        Assertions.assertEquals((Object)CheckType.BROWSE.hasRole(role), (Object)((Boolean)r[8]));
        Assertions.assertEquals((Object)CheckType.CREATE_ADDRESS.hasRole(role), (Object)((Boolean)r[9]));
        Assertions.assertEquals((Object)CheckType.DELETE_ADDRESS.hasRole(role), (Object)((Boolean)r[10]));
        Assertions.assertEquals((int)(CheckType.values().length + 1), (int)r.length);
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetRolesAsJSON() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        SimpleString queue = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        Role role = new Role(org.apache.activemq.artemis.utils.RandomUtil.randomString(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), org.apache.activemq.artemis.utils.RandomUtil.randomBoolean(), false, false);
        this.session.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address));
        AddressControl addressControl = this.createManagementControl(address);
        String jsonString = addressControl.getRolesAsJSON();
        Assertions.assertNotNull((Object)jsonString);
        RoleInfo[] roles = RoleInfo.from((String)jsonString);
        Assertions.assertEquals((int)0, (int)roles.length);
        HashSet<Role> newRoles = new HashSet<Role>();
        newRoles.add(role);
        this.server.getSecurityRepository().addMatch(address.toString(), newRoles);
        jsonString = addressControl.getRolesAsJSON();
        Assertions.assertNotNull((Object)jsonString);
        roles = RoleInfo.from((String)jsonString);
        Assertions.assertEquals((int)1, (int)roles.length);
        RoleInfo r = roles[0];
        Assertions.assertEquals((Object)role.getName(), (Object)roles[0].getName());
        Assertions.assertEquals((Object)role.isSend(), (Object)r.isSend());
        Assertions.assertEquals((Object)role.isConsume(), (Object)r.isConsume());
        Assertions.assertEquals((Object)role.isCreateDurableQueue(), (Object)r.isCreateDurableQueue());
        Assertions.assertEquals((Object)role.isDeleteDurableQueue(), (Object)r.isDeleteDurableQueue());
        Assertions.assertEquals((Object)role.isCreateNonDurableQueue(), (Object)r.isCreateNonDurableQueue());
        Assertions.assertEquals((Object)role.isDeleteNonDurableQueue(), (Object)r.isDeleteNonDurableQueue());
        Assertions.assertEquals((Object)role.isManage(), (Object)r.isManage());
        this.session.deleteQueue(queue);
    }

    @Test
    public void testGetNumberOfPages() throws Exception {
        ClientMessage msg;
        this.session.close();
        this.server.stop();
        this.server.getConfiguration().setPersistenceEnabled(true);
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        AddressSettings addressSettings = new AddressSettings().setPageSizeBytes(1024).setMaxSizeBytes(10240L);
        int NUMBER_MESSAGES_BEFORE_PAGING = 7;
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.server.start();
        ServerLocator locator2 = this.createInVMNonHALocator();
        this.addServerLocator(locator2);
        ClientSessionFactory sf2 = this.createSessionFactory(locator2);
        this.session = sf2.createSession(false, true, false);
        this.session.start();
        this.session.createQueue(QueueConfiguration.of((SimpleString)address));
        QueueImpl serverQueue = (QueueImpl)this.server.locateQueue(address);
        ClientProducer producer = this.session.createProducer(address);
        for (int i = 0; i < 7; ++i) {
            msg = this.session.createMessage(true);
            msg.getBodyBuffer().writeBytes(new byte[896]);
            producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        }
        this.session.commit();
        AddressControl addressControl = this.createManagementControl(address);
        Assertions.assertEquals((long)0L, (long)addressControl.getNumberOfPages());
        msg = this.session.createMessage(true);
        msg.getBodyBuffer().writeBytes(new byte[896]);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        this.session.commit();
        Assertions.assertEquals((long)1L, (long)addressControl.getNumberOfPages());
        msg = this.session.createMessage(true);
        msg.getBodyBuffer().writeBytes(new byte[896]);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        this.session.commit();
        Assertions.assertEquals((long)1L, (long)addressControl.getNumberOfPages());
        msg = this.session.createMessage(true);
        msg.getBodyBuffer().writeBytes(new byte[896]);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        this.session.commit();
        Assertions.assertEquals((long)2L, (long)addressControl.getNumberOfPages(), (String)"# of pages is 2");
        Assertions.assertEquals((long)serverQueue.getPageSubscription().getPagingStore().getAddressSize(), (long)addressControl.getAddressSize());
    }

    @Test
    public void testScheduleCleanup() throws Exception {
        this.server.getConfiguration().setPersistenceEnabled(true);
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        AddressSettings addressSettings = new AddressSettings().setPageSizeBytes(1024).setMaxSizeBytes(10240L);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.server.addAddressInfo(new AddressInfo(address).addRoutingType(RoutingType.MULTICAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)address).setName(address).setDurable(Boolean.valueOf(true)));
        AddressControl addressControl = this.createManagementControl(address);
        Queue queue = this.server.locateQueue(address);
        queue.getPagingStore().startPaging();
        Assertions.assertTrue((boolean)addressControl.isPaging());
        addressControl.schedulePageCleanup();
        Wait.assertFalse(() -> ((AddressControl)addressControl).isPaging(), (long)2000L, (long)10L);
        Wait.assertFalse(() -> ((PagingStore)queue.getPagingStore()).isPaging());
    }

    @Test
    public void testGetNumberOfBytesPerPage() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createQueue(QueueConfiguration.of((SimpleString)address));
        AddressControl addressControl = this.createManagementControl(address);
        Assertions.assertEquals((long)0xA00000L, (long)addressControl.getNumberOfBytesPerPage());
        this.session.close();
        this.server.stop();
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setPageSizeBytes(1024);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.server.start();
        ServerLocator locator2 = this.createInVMNonHALocator();
        ClientSessionFactory sf2 = this.createSessionFactory(locator2);
        this.session = sf2.createSession(false, true, false);
        Assertions.assertEquals((long)1024L, (long)addressControl.getNumberOfBytesPerPage());
    }

    @Test
    public void testGetRoutingTypes() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        String[] routingTypes = addressControl.getRoutingTypes();
        Assertions.assertEquals((int)1, (int)routingTypes.length);
        Assertions.assertEquals((Object)RoutingType.ANYCAST.toString(), (Object)routingTypes[0]);
        address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        EnumSet<RoutingType> types = EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST);
        this.session.createAddress(address, types, false);
        addressControl = this.createManagementControl(address);
        routingTypes = addressControl.getRoutingTypes();
        HashSet<String> strings = new HashSet<String>(Arrays.asList(routingTypes));
        Assertions.assertEquals((int)2, (int)strings.size());
        Assertions.assertTrue((boolean)strings.contains(RoutingType.ANYCAST.toString()));
        Assertions.assertTrue((boolean)strings.contains(RoutingType.MULTICAST.toString()));
    }

    @Test
    public void testGetRoutingTypesAsJSON() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        JsonArray jsonArray = JsonUtil.readJsonArray((String)addressControl.getRoutingTypesAsJSON());
        Assertions.assertEquals((int)1, (int)jsonArray.size());
        Assertions.assertEquals((Object)RoutingType.ANYCAST.toString(), (Object)((JsonString)jsonArray.get(0)).getString());
    }

    @Test
    public void testGetMessageCount() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        Assertions.assertEquals((long)0L, (long)addressControl.getMessageCount());
        ClientProducer producer = this.session.createProducer(address.toString());
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false));
        Assertions.assertEquals((long)0L, (long)addressControl.getMessageCount());
        this.session.createQueue(QueueConfiguration.of((SimpleString)address).setRoutingType(RoutingType.ANYCAST));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> addressControl.getMessageCount() == 1L, (long)2000L, (long)100L));
        this.session.createQueue(QueueConfiguration.of((SimpleString)address.concat('2')).setAddress(address).setRoutingType(RoutingType.ANYCAST));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> addressControl.getMessageCount() == 2L, (long)2000L, (long)100L));
    }

    @Test
    public void testNumberOfMessages() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        Assertions.assertEquals((long)0L, (long)addressControl.getNumberOfMessages());
        ClientProducer producer = this.session.createProducer(address.toString());
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false));
        Assertions.assertEquals((long)0L, (long)addressControl.getNumberOfMessages());
        this.session.createQueue(QueueConfiguration.of((SimpleString)address).setRoutingType(RoutingType.ANYCAST));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false));
        Wait.assertTrue(() -> addressControl.getNumberOfMessages() == 1L, (long)2000L, (long)100L);
        RemoteQueueBinding binding = (RemoteQueueBinding)Mockito.mock(RemoteQueueBinding.class);
        Mockito.when((Object)binding.getAddress()).thenReturn((Object)address);
        Queue queue = (Queue)Mockito.mock(Queue.class);
        Mockito.when((Object)queue.getMessageCount()).thenReturn((Object)999L);
        Mockito.when((Object)binding.getQueue()).thenReturn((Object)queue);
        Mockito.when((Object)binding.getUniqueName()).thenReturn((Object)org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString());
        Mockito.when((Object)binding.getRoutingName()).thenReturn((Object)org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString());
        Mockito.when((Object)binding.getClusterName()).thenReturn((Object)org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString());
        Mockito.when((Object)binding.getType()).thenReturn((Object)BindingType.REMOTE_QUEUE);
        this.server.getPostOffice().addBinding((Binding)binding);
        Assertions.assertEquals((long)1L, (long)addressControl.getNumberOfMessages());
    }

    @Test
    public void testGetRoutedMessageCounts() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        Assertions.assertEquals((long)0L, (long)addressControl.getMessageCount());
        ClientProducer producer = this.session.createProducer(address.toString());
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> addressControl.getRoutedMessageCount() == 0L, (long)2000L, (long)100L));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> addressControl.getUnRoutedMessageCount() == 1L, (long)2000L, (long)100L));
        this.session.createQueue(QueueConfiguration.of((SimpleString)address).setRoutingType(RoutingType.ANYCAST));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> addressControl.getRoutedMessageCount() == 1L, (long)2000L, (long)100L));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> addressControl.getUnRoutedMessageCount() == 1L, (long)2000L, (long)100L));
        this.session.createQueue(QueueConfiguration.of((SimpleString)address.concat('2')).setAddress(address).setRoutingType(RoutingType.ANYCAST));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> addressControl.getRoutedMessageCount() == 2L, (long)2000L, (long)100L));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> addressControl.getUnRoutedMessageCount() == 1L, (long)2000L, (long)100L));
        this.session.deleteQueue(address);
        this.session.deleteQueue(address.concat('2'));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> addressControl.getRoutedMessageCount() == 2L, (long)2000L, (long)100L));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> addressControl.getUnRoutedMessageCount() == 2L, (long)2000L, (long)100L));
    }

    @Test
    public void testSendMessage() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        Assertions.assertEquals((int)0, (int)addressControl.getQueueNames().length);
        this.session.createQueue(QueueConfiguration.of((SimpleString)address).setRoutingType(RoutingType.ANYCAST));
        Assertions.assertEquals((int)1, (int)addressControl.getQueueNames().length);
        addressControl.sendMessage(null, 4, Base64.encodeBytes((byte[])"test".getBytes()), false, null, null);
        Wait.waitFor(() -> addressControl.getMessageCount() == 1L);
        Assertions.assertEquals((long)1L, (long)addressControl.getMessageCount());
        ClientConsumer consumer = this.session.createConsumer(address);
        ClientMessage message = consumer.receive(500L);
        Assertions.assertNotNull((Object)message);
        byte[] buffer = new byte[message.getBodyBuffer().readableBytes()];
        message.getBodyBuffer().readBytes(buffer);
        Assertions.assertEquals((Object)"test", (Object)new String(buffer));
    }

    @Test
    public void testSendMessageWithProperties() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        Assertions.assertEquals((int)0, (int)addressControl.getQueueNames().length);
        this.session.createQueue(QueueConfiguration.of((SimpleString)address).setRoutingType(RoutingType.ANYCAST));
        Assertions.assertEquals((int)1, (int)addressControl.getQueueNames().length);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("myProp1", "myValue1");
        headers.put("myProp2", "myValue2");
        addressControl.sendMessage(headers, 4, Base64.encodeBytes((byte[])"test".getBytes()), false, null, null);
        Wait.waitFor(() -> addressControl.getMessageCount() == 1L);
        Assertions.assertEquals((long)1L, (long)addressControl.getMessageCount());
        ClientConsumer consumer = this.session.createConsumer(address);
        ClientMessage message = consumer.receive(500L);
        Assertions.assertNotNull((Object)message);
        byte[] buffer = new byte[message.getBodyBuffer().readableBytes()];
        message.getBodyBuffer().readBytes(buffer);
        Assertions.assertEquals((Object)"test", (Object)new String(buffer));
        Assertions.assertEquals((Object)"myValue1", (Object)message.getStringProperty("myProp1"));
        Assertions.assertEquals((Object)"myValue2", (Object)message.getStringProperty("myProp2"));
    }

    @Test
    public void testSendMessageWithMessageId() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        Assertions.assertEquals((int)0, (int)addressControl.getQueueNames().length);
        this.session.createQueue(QueueConfiguration.of((SimpleString)address).setRoutingType(RoutingType.ANYCAST));
        Assertions.assertEquals((int)1, (int)addressControl.getQueueNames().length);
        addressControl.sendMessage(null, 4, Base64.encodeBytes((byte[])"test".getBytes()), false, null, null, true);
        addressControl.sendMessage(null, 4, Base64.encodeBytes((byte[])"test".getBytes()), false, null, null, false);
        Wait.waitFor(() -> addressControl.getMessageCount() == 2L);
        Assertions.assertEquals((long)2L, (long)addressControl.getMessageCount());
        ClientConsumer consumer = this.session.createConsumer(address);
        ClientMessage message = consumer.receive(500L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertNotNull((Object)message.getUserID());
        byte[] buffer = new byte[message.getBodyBuffer().readableBytes()];
        message.getBodyBuffer().readBytes(buffer);
        Assertions.assertEquals((Object)"test", (Object)new String(buffer));
        message = consumer.receive(500L);
        Assertions.assertNotNull((Object)message);
        Assertions.assertNull((Object)message.getUserID());
        buffer = new byte[message.getBodyBuffer().readableBytes()];
        message.getBodyBuffer().readBytes(buffer);
        Assertions.assertEquals((Object)"test", (Object)new String(buffer));
    }

    @Test
    public void testGetCurrentDuplicateIdCacheSize() throws Exception {
        this.internalDuplicateIdTest(false);
    }

    @Test
    public void testClearDuplicateIdCache() throws Exception {
        this.internalDuplicateIdTest(true);
    }

    private void internalDuplicateIdTest(boolean clear) throws Exception {
        this.server.getConfiguration().setPersistIDCache(false);
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        Assertions.assertEquals((int)0, (int)addressControl.getQueueNames().length);
        this.session.createQueue(address, RoutingType.ANYCAST, address);
        Assertions.assertEquals((int)1, (int)addressControl.getQueueNames().length);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put(org.apache.activemq.artemis.api.core.Message.HDR_DUPLICATE_DETECTION_ID.toString(), UUID.randomUUID().toString());
        addressControl.sendMessage(headers, 4, Base64.encodeBytes((byte[])"test".getBytes()), false, null, null);
        addressControl.sendMessage(headers, 4, Base64.encodeBytes((byte[])"test".getBytes()), false, null, null);
        headers.clear();
        headers.put(org.apache.activemq.artemis.api.core.Message.HDR_DUPLICATE_DETECTION_ID.toString(), UUID.randomUUID().toString());
        addressControl.sendMessage(headers, 4, Base64.encodeBytes((byte[])"test".getBytes()), false, null, null);
        Wait.assertTrue(() -> addressControl.getCurrentDuplicateIdCacheSize() == 2L);
        if (clear) {
            Assertions.assertTrue((boolean)addressControl.clearDuplicateIdCache());
            Wait.assertTrue(() -> addressControl.getCurrentDuplicateIdCacheSize() == 0L);
        }
    }

    @Test
    public void testPurge() throws Exception {
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.session.createAddress(address, RoutingType.ANYCAST, false);
        AddressControl addressControl = this.createManagementControl(address);
        Assertions.assertNotNull((Object)addressControl);
        Assertions.assertEquals((long)0L, (long)addressControl.getMessageCount());
        ClientProducer producer = this.session.createProducer(address.toString());
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false));
        Assertions.assertEquals((long)0L, (long)addressControl.getMessageCount());
        this.session.createQueue(QueueConfiguration.of((SimpleString)address).setRoutingType(RoutingType.ANYCAST));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> addressControl.getMessageCount() == 1L, (long)2000L, (long)100L));
        this.session.createQueue(QueueConfiguration.of((SimpleString)address.concat('2')).setAddress(address).setRoutingType(RoutingType.ANYCAST));
        producer.send((org.apache.activemq.artemis.api.core.Message)this.session.createMessage(false));
        Assertions.assertTrue((boolean)Wait.waitFor(() -> addressControl.getMessageCount() == 2L, (long)2000L, (long)100L));
        Assertions.assertEquals((long)2L, (long)addressControl.purge());
        Wait.assertEquals((Long)0L, () -> addressControl.getMessageCount(), (long)2000L, (long)100L);
    }

    @Test
    public void testReplayWithoutDate() throws Exception {
        this.testReplaySimple(false);
    }

    @Test
    public void testReplayWithDate() throws Exception {
        this.testReplaySimple(true);
    }

    private void testReplaySimple(boolean useDate) throws Exception {
        String queue = "testQueue" + org.apache.activemq.artemis.utils.RandomUtil.randomString();
        this.server.addAddressInfo(new AddressInfo(queue).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)queue).setRoutingType(RoutingType.ANYCAST).setAddress(queue));
        AddressControl addressControl = this.createManagementControl(SimpleString.of((String)queue));
        ConnectionFactory factory = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue jmsQueue = session.createQueue(queue);
            MessageProducer producer = session.createProducer((Destination)jmsQueue);
            producer.send((Message)session.createTextMessage("before"));
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)jmsQueue);
            Assertions.assertNotNull((Object)consumer.receive(5000L));
            Assertions.assertNull((Object)consumer.receiveNoWait());
            addressControl.replay(queue, null);
            Assertions.assertNotNull((Object)consumer.receive(5000L));
            Assertions.assertNull((Object)consumer.receiveNoWait());
            if (useDate) {
                int i;
                addressControl.replay("dontexist", null);
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                Thread.sleep(1000L);
                String dateEnd = format.format(new Date());
                Thread.sleep(1000L);
                String dateStart = "19800101000000";
                for (i = 0; i < 100; ++i) {
                    producer.send((Message)session.createTextMessage("after receiving"));
                }
                for (i = 0; i < 100; ++i) {
                    Assertions.assertNotNull((Object)consumer.receive());
                }
                Assertions.assertNull((Object)consumer.receiveNoWait());
                addressControl.replay(dateStart, dateEnd, queue, null);
                for (i = 0; i < 2; ++i) {
                    TextMessage message = (TextMessage)consumer.receive(5000L);
                    Assertions.assertNotNull((Object)message);
                    Assertions.assertEquals((Object)"before", (Object)message.getText());
                }
                Assertions.assertNull((Object)consumer.receiveNoWait());
            } else {
                addressControl.replay(queue, null);
                for (int i = 0; i < 2; ++i) {
                    Assertions.assertNotNull((Object)consumer.receive(5000L));
                }
                Assertions.assertNull((Object)consumer.receiveNoWait());
            }
        }
    }

    @Test
    public void testReplayFilter() throws Exception {
        String queue = "testQueue" + org.apache.activemq.artemis.utils.RandomUtil.randomString();
        this.server.addAddressInfo(new AddressInfo(queue).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)queue).setRoutingType(RoutingType.ANYCAST).setAddress(queue));
        AddressControl addressControl = this.createManagementControl(SimpleString.of((String)queue));
        ConnectionFactory factory = CFUtil.createConnectionFactory("core", "tcp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue jmsQueue = session.createQueue(queue);
            MessageProducer producer = session.createProducer((Destination)jmsQueue);
            for (int i = 0; i < 10; ++i) {
                TextMessage message = session.createTextMessage("message " + i);
                message.setIntProperty("i", i);
                producer.send((Message)message);
            }
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)jmsQueue);
            for (int i = 0; i < 10; ++i) {
                Assertions.assertNotNull((Object)consumer.receive(5000L));
            }
            Assertions.assertNull((Object)consumer.receiveNoWait());
            addressControl.replay(queue, "i=5");
            TextMessage message = (TextMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)message);
            Assertions.assertEquals((int)5, (int)message.getIntProperty("i"));
            Assertions.assertEquals((Object)"message 5", (Object)message.getText());
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
    }

    @Test
    public void testAddressSizeAfterRestart() throws Exception {
        this.session.close();
        this.server.stop();
        this.server.getConfiguration().setPersistenceEnabled(true);
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        this.server.start();
        ServerLocator locator2 = this.createInVMNonHALocator();
        this.addServerLocator(locator2);
        ClientSessionFactory sf2 = this.createSessionFactory(locator2);
        this.session = sf2.createSession(false, true, false);
        this.session.start();
        this.session.createQueue(QueueConfiguration.of((SimpleString)address));
        ClientProducer producer = this.session.createProducer(address);
        int numMessages = 10;
        int payLoadSize = 896;
        for (int i = 0; i < 10; ++i) {
            ClientMessage msg = this.session.createMessage(true);
            msg.getBodyBuffer().writeBytes(new byte[896]);
            producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        }
        this.session.commit();
        AddressControl addressControl = this.createManagementControl(address);
        Assertions.assertTrue((addressControl.getAddressSize() > 8960L ? (byte)1 : 0) != 0);
        this.server.stop();
        this.server.start();
        addressControl = this.createManagementControl(address);
        Assertions.assertTrue((addressControl.getAddressSize() > 8960L ? (byte)1 : 0) != 0);
    }

    @Test
    public void testAddressSizeAfterRestartWithPaging() throws Exception {
        this.session.close();
        this.server.stop();
        this.server.getConfiguration().setPersistenceEnabled(true);
        int payLoadSize = 896;
        int pageLimitNumberOfMessages = 4;
        SimpleString address = org.apache.activemq.artemis.utils.RandomUtil.randomSimpleString();
        AddressSettings addressSettings = new AddressSettings().setPageSizeBytes(1792).setMaxSizeBytes(3584L);
        this.server.getAddressSettingsRepository().addMatch(address.toString(), (Object)addressSettings);
        this.server.start();
        ServerLocator locator2 = this.createInVMNonHALocator();
        this.addServerLocator(locator2);
        ClientSessionFactory sf2 = this.createSessionFactory(locator2);
        this.session = sf2.createSession(false, true, false);
        this.session.start();
        this.session.createQueue(QueueConfiguration.of((SimpleString)address));
        ClientProducer producer = this.session.createProducer(address);
        int numMessages = 8;
        for (int i = 0; i < 8; ++i) {
            ClientMessage msg = this.session.createMessage(true);
            msg.getBodyBuffer().writeBytes(new byte[896]);
            producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        }
        this.session.commit();
        AddressControl addressControl = this.createManagementControl(address);
        Assertions.assertTrue((addressControl.getAddressSize() > 3584L ? (byte)1 : 0) != 0);
        long exactSizeValueBeforeRestart = addressControl.getAddressSize();
        int exactPercentBeforeRestart = addressControl.getAddressLimitPercent();
        this.server.stop();
        this.server.start();
        addressControl = this.createManagementControl(address);
        Assertions.assertTrue((addressControl.getAddressSize() > 3584L ? (byte)1 : 0) != 0);
        Assertions.assertEquals((long)exactSizeValueBeforeRestart, (long)addressControl.getAddressSize());
        Assertions.assertEquals((int)exactPercentBeforeRestart, (int)addressControl.getAddressLimitPercent());
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultNettyConfig().setJMXManagementEnabled(true);
        config.setJournalRetentionDirectory(config.getJournalDirectory() + "_ret");
        this.server = this.createServer(true, config);
        this.server.setMBeanServer(this.mbeanServer);
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true);
        this.sf = this.createSessionFactory(this.locator);
        this.session = this.sf.createSession(false, true, false);
        this.session.start();
        this.addClientSession(this.session);
    }

    protected AddressControl createManagementControl(SimpleString address) throws Exception {
        return ManagementControlHelper.createAddressControl(address, this.mbeanServer);
    }
}

