/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.integration.management.CoreMessagingProxy;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BridgeControlUsingCoreTest
extends ManagementTestBase {
    private ActiveMQServer server_0;
    private BridgeConfiguration bridgeConfig;
    private ActiveMQServer server_1;

    @Test
    public void testAttributes() throws Exception {
        this.checkResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(this.bridgeConfig.getName()));
        CoreMessagingProxy proxy = this.createProxy(this.bridgeConfig.getName());
        Assertions.assertEquals((Object)this.bridgeConfig.getName(), (Object)proxy.retrieveAttributeValue("name"));
        Assertions.assertEquals((Object)this.bridgeConfig.getDiscoveryGroupName(), (Object)proxy.retrieveAttributeValue("discoveryGroupName"));
        Assertions.assertEquals((Object)this.bridgeConfig.getQueueName(), (Object)proxy.retrieveAttributeValue("queueName"));
        Assertions.assertEquals((Object)this.bridgeConfig.getForwardingAddress(), (Object)proxy.retrieveAttributeValue("forwardingAddress"));
        Assertions.assertEquals((Object)this.bridgeConfig.getFilterString(), (Object)proxy.retrieveAttributeValue("filterString"));
        Assertions.assertEquals((Object)this.bridgeConfig.getRetryInterval(), (Object)proxy.retrieveAttributeValue("retryInterval", Long.class));
        Assertions.assertEquals((Object)this.bridgeConfig.getRetryIntervalMultiplier(), (Object)proxy.retrieveAttributeValue("retryIntervalMultiplier", Double.class));
        Assertions.assertEquals((Object)this.bridgeConfig.getMaxRetryInterval(), (Object)proxy.retrieveAttributeValue("maxRetryInterval", Long.class));
        Assertions.assertEquals((Object)this.bridgeConfig.getReconnectAttempts(), (Object)proxy.retrieveAttributeValue("reconnectAttempts", Integer.class));
        Assertions.assertEquals((Object)this.bridgeConfig.isUseDuplicateDetection(), (Object)proxy.retrieveAttributeValue("useDuplicateDetection", Boolean.class));
        Map bridgeMetrics = (Map)proxy.retrieveAttributeValue("metrics", Map.class);
        Assertions.assertEquals((Object)0L, (Object)proxy.retrieveAttributeValue("messagesPendingAcknowledgement", Long.class));
        Assertions.assertEquals((Object)0L, (Object)proxy.retrieveAttributeValue("messagesAcknowledged", Long.class));
        Assertions.assertEquals((Object)0L, bridgeMetrics.get("messagesPendingAcknowledgement"));
        Assertions.assertEquals((Object)0L, bridgeMetrics.get("messagesAcknowledged"));
        Object[] data = (Object[])proxy.retrieveAttributeValue("staticConnectors");
        Assertions.assertEquals(this.bridgeConfig.getStaticConnectors().get(0), (Object)data[0]);
        Assertions.assertTrue((boolean)((Boolean)proxy.retrieveAttributeValue("started")));
    }

    @Test
    public void testStartStop() throws Exception {
        this.checkResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(this.bridgeConfig.getName()));
        CoreMessagingProxy proxy = this.createProxy(this.bridgeConfig.getName());
        Assertions.assertTrue((boolean)((Boolean)proxy.retrieveAttributeValue("Started")));
        proxy.invokeOperation("stop", new Object[0]);
        Assertions.assertFalse((boolean)((Boolean)proxy.retrieveAttributeValue("Started")));
        proxy.invokeOperation("start", new Object[0]);
        Assertions.assertTrue((boolean)((Boolean)proxy.retrieveAttributeValue("Started")));
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, Integer> acceptorParams = new HashMap<String, Integer>();
        acceptorParams.put("serverId", 1);
        TransportConfiguration acceptorConfig = new TransportConfiguration(InVMAcceptorFactory.class.getName(), acceptorParams, RandomUtil.randomString());
        TransportConfiguration connectorConfig = new TransportConfiguration(InVMConnectorFactory.class.getName(), acceptorParams, RandomUtil.randomString());
        QueueConfiguration sourceQueueConfig = QueueConfiguration.of((String)RandomUtil.randomString()).setDurable(Boolean.valueOf(false));
        QueueConfiguration targetQueueConfig = QueueConfiguration.of((String)RandomUtil.randomString()).setDurable(Boolean.valueOf(false));
        ArrayList<String> connectors = new ArrayList<String>();
        connectors.add(connectorConfig.getName());
        this.bridgeConfig = new BridgeConfiguration().setName(RandomUtil.randomString()).setQueueName(sourceQueueConfig.getName().toString()).setForwardingAddress(targetQueueConfig.getAddress().toString()).setRetryInterval(RandomUtil.randomPositiveLong()).setRetryIntervalMultiplier(RandomUtil.randomDouble()).setInitialConnectAttempts(RandomUtil.randomPositiveInt()).setReconnectAttempts(RandomUtil.randomPositiveInt()).setReconnectAttemptsOnSameNode(RandomUtil.randomPositiveInt()).setUseDuplicateDetection(RandomUtil.randomBoolean()).setConfirmationWindowSize(RandomUtil.randomPositiveInt()).setStaticConnectors(connectors);
        ConfigurationImpl conf_1 = this.createBasicConfig().addAcceptorConfiguration(acceptorConfig).addQueueConfiguration(targetQueueConfig);
        ConfigurationImpl conf_0 = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(INVM_ACCEPTOR_FACTORY)).addConnectorConfiguration(connectorConfig.getName(), connectorConfig).addQueueConfiguration(sourceQueueConfig).addBridgeConfiguration(this.bridgeConfig);
        this.server_1 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf_1, (MBeanServer)this.createMBeanServer(), (boolean)false));
        this.server_1.start();
        this.server_0 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf_0, (MBeanServer)this.mbeanServer, (boolean)false));
        this.server_0.start();
    }

    protected CoreMessagingProxy createProxy(String name) throws Exception {
        CoreMessagingProxy proxy = new CoreMessagingProxy(this.addServerLocator(this.createInVMNonHALocator()), "bridge." + name);
        return proxy;
    }
}

