/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.protocol.mqtt.MQTTConnection;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.core.server.plugin.ActiveMQServerBindingPlugin;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTTestSupport;
import org.apache.activemq.artemis.utils.Wait;
import org.fusesource.mqtt.client.BlockingConnection;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MQTTConnnectionCleanupTest
extends MQTTTestSupport {
    @Override
    protected void addMQTTConnector() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("port", "" + this.port);
        params.put("protocols", "MQTT");
        params.put("connectionsAllowed", 1);
        params.put("host", "localhost");
        TransportConfiguration mqtt = new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params, "MQTT");
        this.server.getConfiguration().addAcceptorConfiguration(mqtt);
    }

    @Test
    @Timeout(value=30L)
    public void testBadClient() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("");
        mqtt.setCleanSession(true);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        try {
            connection = mqtt.blockingConnection();
            connection.connect();
            Assertions.fail((String)"second connection shouldn't be allowed");
        }
        catch (Exception exception) {
            // empty catch block
        }
        NettyAcceptor acceptor = (NettyAcceptor)this.server.getRemotingService().getAcceptor("MQTT");
        Assertions.assertEquals((int)1, (int)acceptor.getConnections().size());
        RemotingConnection conn = (RemotingConnection)this.server.getRemotingService().getConnections().iterator().next();
        Assertions.assertTrue((boolean)(conn instanceof MQTTConnection));
        conn.fail(new ActiveMQException("testBadClient"));
        Wait.assertEquals((int)0, () -> acceptor.getConnections().size());
        connection = mqtt.blockingConnection();
        connection.connect();
        connection.disconnect();
    }

    @Test
    @Timeout(value=30L)
    public void testSlowSubscribeWontBlockKeepAlive() throws Exception {
        MQTT mqtt = this.createMQTTConnection();
        mqtt.setClientId("");
        mqtt.setKeepAlive((short)1);
        mqtt.setCleanSession(true);
        BlockingConnection connection = mqtt.blockingConnection();
        connection.connect();
        NettyAcceptor acceptor = (NettyAcceptor)this.server.getRemotingService().getAcceptor("MQTT");
        Assertions.assertEquals((int)1, (int)acceptor.getConnections().size());
        this.server.getConfiguration().getBrokerBindingPlugins().add(new ActiveMQServerBindingPlugin(){

            public void beforeAddBinding(Binding binding) throws ActiveMQException {
                try {
                    TimeUnit.SECONDS.sleep(3L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        connection.subscribe(new Topic[]{new Topic("T.x", QoS.AT_LEAST_ONCE)});
        Assertions.assertEquals((int)1, (int)acceptor.getConnections().size());
        connection.disconnect();
    }
}

