/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt;

import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Random;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTClientProvider;
import org.apache.activemq.artemis.tests.integration.mqtt.MQTTTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MQTTQueueCleanTest
extends MQTTTestSupport {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Test
    public void testQueueClean() throws Exception {
        this.testQueueClean(false);
    }

    @Test
    public void testManagedQueueClean() throws Exception {
        this.testQueueClean(true);
    }

    private void testQueueClean(boolean managed) throws Exception {
        String address = "clean/test";
        String clientId = "mqtt-client";
        String queueName = "::mqtt-client.clean.test";
        if (managed) {
            this.server.addAddressInfo(new AddressInfo(address).addRoutingType(RoutingType.MULTICAST));
            this.server.createQueue(QueueConfiguration.of((String)queueName).setAddress(address).setRoutingType(RoutingType.MULTICAST).setConfigurationManaged(Boolean.valueOf(true)));
        }
        MQTTClientProvider clientProvider = this.getMQTTClientProvider();
        clientProvider.setClientId(clientId);
        this.initializeConnection(clientProvider);
        clientProvider.subscribe(address, 1);
        clientProvider.disconnect();
        if (managed) {
            Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(SimpleString.of((String)queueName)) != null && this.server.locateQueue(SimpleString.of((String)queueName)).getConsumerCount() == 0, (long)5000L, (long)10L));
        } else {
            Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(SimpleString.of((String)queueName)) == null, (long)5000L, (long)10L));
        }
    }

    @Test
    public void testQueueCleanOnRestart() throws Exception {
        String topic = "clean/test";
        String clientId = "mqtt-client";
        String queueName = "mqtt-client.clean.test";
        MQTTClientProvider clientProvider = this.getMQTTClientProvider();
        clientProvider.setClientId(clientId);
        this.initializeConnection(clientProvider);
        clientProvider.subscribe(topic, 1);
        this.server.stop();
        this.server.start();
        Wait.assertTrue(() -> this.server.locateQueue(SimpleString.of((String)queueName)) == null, (long)5000L, (long)10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testQueueCleanWhenConnectionSynExeConnectAndDisconnect() throws Exception {
        Random random = new Random();
        HashSet<Object> clientProviders = new HashSet<Object>(11);
        int repeatCount = 0;
        String address = "clean/test";
        String clientId = "sameClientId";
        String queueName = "::sameClientId.clean.test";
        while (repeatCount < 100) {
            ++repeatCount;
            int subConnectionCount = random.nextInt(50) + 1;
            try {
                for (int sC = 0; sC < subConnectionCount; ++sC) {
                    MQTTClientProvider clientProvider = this.getMQTTClientProvider();
                    clientProvider.setClientId(clientId);
                    this.initializeConnection(clientProvider);
                    clientProviders.add(clientProvider);
                    clientProvider.subscribe(address, 1);
                }
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
            finally {
                for (MQTTClientProvider mQTTClientProvider : clientProviders) {
                    mQTTClientProvider.disconnect();
                }
                clientProviders.clear();
                Assertions.assertTrue((boolean)Wait.waitFor(() -> this.server.locateQueue(SimpleString.of((String)queueName)) == null, (long)5000L, (long)10L));
            }
        }
    }
}

