/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.ssl;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.common.MqttMessage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class BasicSslTests
extends MQTT5TestSupport {
    protected String protocol;

    public BasicSslTests(String protocol) {
        this.protocol = protocol;
    }

    @Parameters(name="protocol={0}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({"ssl"}, {"wss"});
    }

    @Override
    public boolean isUseSsl() {
        return true;
    }

    @TestTemplate
    @Timeout(value=60L)
    public void testSimpleSendReceive() throws Exception {
        String topic = RandomUtil.randomString();
        final byte[] body = RandomUtil.randomBytes((int)32);
        final CountDownLatch latch = new CountDownLatch(1);
        MqttClient subscriber = this.createPahoClient(this.protocol, "subscriber");
        subscriber.connect(this.getSslMqttConnectOptions());
        subscriber.setCallback((MqttCallback)new MQTT5TestSupport.DefaultMqttCallback(){

            @Override
            public void messageArrived(String topic, MqttMessage message) {
                ActiveMQTestBase.assertEqualsByteArrays(body, message.getPayload());
                latch.countDown();
            }
        });
        subscriber.subscribe(topic, 1);
        MqttClient producer = this.createPahoClient(this.protocol, "producer");
        producer.connect(this.getSslMqttConnectOptions());
        producer.publish(topic, body, 1, false);
        Assertions.assertTrue((boolean)latch.await(500L, TimeUnit.MILLISECONDS));
    }
}

