/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.activemq.artemis.core.protocol.openwire.OpenWireConnection;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.state.ConnectionState;
import org.apache.activemq.state.SessionState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SessionHandlingOpenWireTest
extends BasicOpenWireTest {
    @Test
    public void testInternalSessionHandling() throws Exception {
        try (Connection conn = this.factory.createConnection();
             AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            conn.start();
            try (Session session = conn.createSession(false, 1);){
                ActiveMQDestination dest = this.createDestination(session, (byte)1);
                this.sendMessages(session, (Destination)dest, 1);
                MessageConsumer consumer = session.createConsumer((Destination)dest);
                Message m = consumer.receive(2000L);
                Assertions.assertNotNull((Object)m);
            }
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"Client connection failed, clearing up resources for session"}));
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"Cleared up resources for session"}));
        }
    }

    @Test
    public void testInternalSessionHandlingNoSessionClose() throws Exception {
        try (Connection conn = this.factory.createConnection();
             AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
            conn.start();
            for (int i = 0; i < 100; ++i) {
                Session session = conn.createSession(false, 1);
                ActiveMQDestination dest = this.createDestination(session, (byte)1);
                this.sendMessages(session, (Destination)dest, 1);
                MessageConsumer consumer = session.createConsumer((Destination)dest);
                Message m = consumer.receive(2000L);
                consumer.close();
                Assertions.assertNotNull((Object)m);
                if (i % 2 != 1) continue;
                session.close();
            }
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"Client connection failed, clearing up resources for session"}));
            Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"Cleared up resources for session"}));
        }
    }

    @Test
    public void testProducerState() throws Exception {
        try (Connection conn = this.factory.createConnection();){
            conn.start();
            Session session = conn.createSession(false, 1);
            ActiveMQDestination dest = this.createDestination(session, (byte)1);
            for (int i = 0; i < 10; ++i) {
                MessageProducer messageProducer = session.createProducer((Destination)dest);
                messageProducer.close();
            }
            for (RemotingConnection remotingConnection : this.server.getRemotingService().getConnections()) {
                OpenWireConnection openWireConnection;
                ConnectionState connectionState;
                if (!(remotingConnection instanceof OpenWireConnection) || (connectionState = (openWireConnection = (OpenWireConnection)remotingConnection).getState()) == null) continue;
                for (SessionState sessionState : connectionState.getSessionStates()) {
                    Assertions.assertTrue((boolean)Wait.waitFor(() -> sessionState.getProducerIds().isEmpty()), (String)"no producer states leaked");
                }
            }
        }
    }
}

