/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import java.io.IOException;
import java.net.Socket;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQMessageConsumer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.apache.activemq.artemis.utils.Wait;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.util.IdGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JMSConsumer2Test
extends BasicOpenWireTest {
    @Test
    public void testMessageListenerWithConsumerCanBeStoppedConcurently() throws Exception {
        final AtomicInteger counter = new AtomicInteger(0);
        final CountDownLatch closeDone = new CountDownLatch(1);
        this.connection.start();
        Session session = this.connection.createSession(false, 2);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        this.sendMessages(session, (Destination)destination, 2000);
        final ActiveMQMessageConsumer consumer = (ActiveMQMessageConsumer)session.createConsumer((Destination)destination);
        final Map exceptions = Collections.synchronizedMap(new HashMap());
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> exceptions.put(t, e));
        ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        consumer.setMessageListener(m -> {
            final class AckAndClose
            implements Runnable {
                private final Message message;

                AckAndClose(Message m) {
                    this.message = m;
                }

                @Override
                public void run() {
                    block4: {
                        try {
                            int count = counter.incrementAndGet();
                            if (count == 590) {
                                consumer.close();
                                closeDone.countDown();
                            }
                            if (count % 200 == 0) {
                                this.message.acknowledge();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (e instanceof IllegalStateException) break block4;
                            exceptions.put(Thread.currentThread(), e);
                        }
                    }
                }
            }
            executor.execute(new AckAndClose(m));
        });
        Assertions.assertTrue((boolean)closeDone.await(20L, TimeUnit.SECONDS));
        Thread.sleep(1000L);
        Assertions.assertTrue((boolean)exceptions.isEmpty(), (String)("no exceptions: " + exceptions));
        executor.shutdown();
    }

    @Test
    public void testDupsOkConsumer() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(false, 3);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.sendMessages(session, (Destination)destination, 4);
        for (int i = 0; i < 4; ++i) {
            Message m = consumer.receive(1000L);
            Assertions.assertNotNull((Object)m);
        }
        Assertions.assertNull((Object)consumer.receive(1000L));
        consumer.close();
        consumer = session.createConsumer((Destination)destination);
        Assertions.assertNull((Object)consumer.receive(1000L));
    }

    @Test
    public void testRedispatchOfUncommittedTx() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        this.sendMessages((Connection)this.connection, (Destination)destination, 2);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        Message m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        m = consumer.receive(5000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertFalse((boolean)m.getJMSRedelivered(), (String)"redelivered flag set");
        Session redispatchSession = this.connection.createSession(true, 0);
        MessageConsumer redispatchConsumer = redispatchSession.createConsumer((Destination)destination);
        session.close();
        Message msg = redispatchConsumer.receive(3000L);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertTrue((boolean)msg.getJMSRedelivered(), (String)"redelivered flag set");
        Assertions.assertEquals((long)2L, (long)msg.getLongProperty("JMSXDeliveryCount"));
        msg = redispatchConsumer.receive(1000L);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertTrue((boolean)msg.getJMSRedelivered());
        Assertions.assertEquals((long)2L, (long)msg.getLongProperty("JMSXDeliveryCount"));
        redispatchSession.commit();
        Assertions.assertNull((Object)redispatchConsumer.receive(500L));
        redispatchSession.close();
    }

    @Test
    public void testRedispatchOfRolledbackTx() throws Exception {
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        this.sendMessages((Connection)this.connection, (Destination)destination, 2);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        Assertions.assertNotNull((Object)consumer.receive(1000L));
        Assertions.assertNotNull((Object)consumer.receive(1000L));
        Session redispatchSession = this.connection.createSession(true, 0);
        MessageConsumer redispatchConsumer = redispatchSession.createConsumer((Destination)destination);
        session.rollback();
        session.close();
        Message msg = redispatchConsumer.receive(1000L);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertTrue((boolean)msg.getJMSRedelivered());
        Assertions.assertEquals((long)2L, (long)msg.getLongProperty("JMSXDeliveryCount"));
        msg = redispatchConsumer.receive(1000L);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertTrue((boolean)msg.getJMSRedelivered());
        Assertions.assertEquals((long)2L, (long)msg.getLongProperty("JMSXDeliveryCount"));
        redispatchSession.commit();
        Assertions.assertNull((Object)redispatchConsumer.receive(500L));
        redispatchSession.close();
    }

    @Test
    public void testRedeliveryOnServerConnectionFailWithPendingAckInLocalTx() throws Exception {
        this.connection.start();
        this.sendMessages((Connection)this.connection, (Destination)new ActiveMQQueue(this.queueName), 1);
        this.connection.close();
        this.factory.setWatchTopicAdvisories(false);
        this.factory.setNonBlockingRedelivery(true);
        this.connection = (ActiveMQConnection)this.factory.createConnection();
        this.connection.start();
        Session session = this.connection.createSession(true, 0);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        CountDownLatch gotMessage = new CountDownLatch(1);
        consumer.setMessageListener(message -> gotMessage.countDown());
        Assertions.assertTrue((boolean)gotMessage.await(1L, TimeUnit.SECONDS));
        Queue queueInstance = this.server.locateQueue(SimpleString.of((String)this.queueName));
        Wait.waitFor(() -> queueInstance.getAcknowledgeAttempts() > 0L);
        try {
            ((Socket)this.connection.getTransport().narrow(Socket.class)).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection = (ActiveMQConnection)this.factory.createConnection();
        this.connection.start();
        session = this.connection.createSession(true, 0);
        consumer = session.createConsumer((Destination)destination);
        Assertions.assertNotNull((Object)consumer.receive(2000L));
        session.commit();
        this.connection.close();
    }

    @Test
    public void testSelectorWithJMSMessageID() throws Exception {
        Session session = this.connection.createSession(true, 0);
        ActiveMQDestination destination = this.createDestination(session, (byte)1);
        this.sendMessages((Connection)this.connection, (Destination)destination, 1);
        MessageConsumer consumer = session.createConsumer((Destination)destination, "JMSMessageID like '%" + IdGenerator.getHostName() + "%'");
        this.connection.start();
        Message m = consumer.receive(500L);
        Assertions.assertNotNull((Object)m);
    }
}

