/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import org.apache.activemq.artemis.tests.integration.openwire.amq.JmsTopicSendReceiveTest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class JmsDurableTopicSendReceiveTest
extends JmsTopicSendReceiveTest {
    protected Connection connection2;
    protected Session session2;
    protected Session consumeSession2;
    protected MessageConsumer consumer2;
    protected MessageProducer producer2;
    protected Destination consumerDestination2;
    protected Destination producerDestination2;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        this.durable = true;
        super.setUp();
    }

    @Test
    public void testSendWhileClosed() throws Exception {
        this.connection2 = this.factory.createConnection();
        this.connection2.setClientID("test");
        this.connection2.start();
        this.session2 = this.connection2.createSession(false, 1);
        this.producer2 = this.session2.createProducer(null);
        this.producer2.setDeliveryMode(this.deliveryMode);
        this.producerDestination2 = this.createDestination2(this.session2, (byte)2);
        Thread.sleep(1000L);
        this.consumeSession2 = this.connection2.createSession(false, 1);
        this.consumerDestination2 = this.createDestination2(this.session2, (byte)2);
        this.consumer2 = this.consumeSession2.createDurableSubscriber((Topic)this.consumerDestination2, this.getName());
        Thread.sleep(1000L);
        this.consumer2.close();
        TextMessage message = this.session2.createTextMessage("test");
        message.setStringProperty("test", "test");
        message.setJMSType("test");
        this.producer2.send(this.producerDestination2, (Message)message);
        this.consumer2 = this.consumeSession2.createDurableSubscriber((Topic)this.consumerDestination2, this.getName());
        Message msg = this.consumer2.receive(1000L);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertEquals((Object)((TextMessage)msg).getText(), (Object)"test");
        Assertions.assertEquals((Object)msg.getJMSType(), (Object)"test");
        Assertions.assertEquals((Object)msg.getStringProperty("test"), (Object)"test");
        this.connection2.stop();
        this.connection2.close();
    }

    @Override
    protected String getName() {
        return "testSendWhileClosed";
    }
}

