/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class IndividualAckPagingTest
extends ActiveMQTestBase {
    protected final boolean paging;
    protected final boolean restartServerBeforeConsume;
    private static final String ADDRESS = "IndividualAckPagingTest";
    ActiveMQServer server;
    protected static final int PAGE_MAX = 10240;
    protected static final int PAGE_SIZE = 5120;

    @Parameters(name="paging={0}, restartServerBeforeConsume={1}")
    public static Collection getParams() {
        return Arrays.asList({true, false}, {true, true}, {false, false});
    }

    public IndividualAckPagingTest(boolean paging, boolean restartServerBeforeConsume) {
        this.paging = paging;
        this.restartServerBeforeConsume = restartServerBeforeConsume;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        Configuration config = this.createDefaultConfig(0, true).setJournalSyncNonTransactional(false);
        config.setMessageExpiryScanPeriod(-1L);
        if (this.paging) {
            this.server = this.createServer(true, config, 5120, 10240L);
            this.server.getAddressSettingsRepository().clear();
            AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(5120).setMaxSizeBytes(10240L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false)).setMaxReadPageBytes(-1).setMaxReadPageMessages(-1);
            this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        } else {
            this.server = this.createServer(true, config, 0xA00000, -1L);
            this.server.getAddressSettingsRepository().clear();
            AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(0xA00000).setMaxSizeBytes(-1L).setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE).setAutoCreateAddresses(Boolean.valueOf(false)).setAutoCreateQueues(Boolean.valueOf(false)).setMaxReadPageBytes(-1).setMaxReadPageMessages(-1);
            this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        }
        this.server.start();
        this.server.addAddressInfo(new AddressInfo(ADDRESS).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)ADDRESS).setRoutingType(RoutingType.ANYCAST));
    }

    @TestTemplate
    public void testIndividualAckCore() throws Exception {
        this.testIndividualAck("CORE", 1024);
    }

    @TestTemplate
    public void testIndividualAckAMQP() throws Exception {
        this.testIndividualAck("AMQP", 1024);
    }

    public void testIndividualAck(String protocol, int bodySize) throws Exception {
        MessageConsumer consumer;
        TextMessage message;
        int i;
        jakarta.jms.Queue jmsQueue;
        Session session;
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        StringBuffer buffer = new StringBuffer();
        for (int i2 = 0; i2 < bodySize; ++i2) {
            buffer.append("*");
        }
        String extraBody = buffer.toString();
        Queue queue = this.server.locateQueue(ADDRESS);
        try (Connection connection = factory.createConnection();){
            session = connection.createSession(true, 0);
            jmsQueue = session.createQueue(ADDRESS);
            MessageProducer producer = session.createProducer((Destination)jmsQueue);
            for (i = 0; i < 100; ++i) {
                message = session.createTextMessage(extraBody);
                message.setIntProperty("i", i);
                producer.send((Message)message);
            }
            session.commit();
        }
        connection = factory.createConnection();
        try {
            session = connection.createSession(false, 101);
            jmsQueue = session.createQueue(ADDRESS);
            connection.start();
            consumer = session.createConsumer((Destination)jmsQueue);
            for (i = 0; i < 100; ++i) {
                message = (TextMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                if (message.getIntProperty("i") != 77) continue;
                message.acknowledge();
            }
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        if (this.restartServerBeforeConsume) {
            this.server.stop();
            this.server.start();
        }
        connection = factory.createConnection();
        try {
            session = connection.createSession(false, 1);
            jmsQueue = session.createQueue(ADDRESS);
            connection.start();
            consumer = session.createConsumer((Destination)jmsQueue);
            for (i = 0; i < 99; ++i) {
                message = (TextMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertNotEquals((int)77, (int)message.getIntProperty("i"));
            }
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }
}

