/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagingLimitTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    ActiveMQServer server;

    @Test
    public void testPageLimitMessageCoreFail() throws Exception {
        this.testPageLimitMessage("CORE", false);
    }

    @Test
    public void testPageLimitAMQPFail() throws Exception {
        this.testPageLimitMessage("AMQP", false);
    }

    @Test
    public void testPageLimitMessagesOpenWireFail() throws Exception {
        this.testPageLimitMessage("OPENWIRE", false);
    }

    @Test
    public void testPageLimitMessageCoreDrop() throws Exception {
        this.testPageLimitMessage("CORE", false);
    }

    @Test
    public void testPageLimitAMQPDrop() throws Exception {
        this.testPageLimitMessage("AMQP", false);
    }

    @Test
    public void testPageLimitMessagesOpenWireDrop() throws Exception {
        this.testPageLimitMessage("OPENWIRE", false);
    }

    public void testPageLimitMessage(String protocol, boolean drop) throws Exception {
        String queueNameTX = this.getName() + "_TX";
        String queueNameNonTX = this.getName() + "_NONTX";
        Configuration config = this.createDefaultConfig(true);
        config.setJournalSyncTransactional(false).setJournalSyncTransactional(false);
        int PAGE_MAX = 20480;
        int PAGE_SIZE = 10240;
        this.server = this.createServer(true, config, 10240, 20480L, -1, -1, null, 300L, drop ? "DROP" : "FAIL", null);
        this.server.start();
        this.server.addAddressInfo(new AddressInfo(queueNameTX).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)queueNameTX).setRoutingType(RoutingType.ANYCAST));
        this.server.addAddressInfo(new AddressInfo(queueNameNonTX).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)queueNameNonTX).setRoutingType(RoutingType.ANYCAST));
        Wait.assertTrue(() -> this.server.locateQueue(queueNameNonTX) != null);
        Wait.assertTrue(() -> this.server.locateQueue(queueNameTX) != null);
        this.testPageLimitMessageFailInternal(queueNameTX, protocol, true, drop);
        this.testPageLimitMessageFailInternal(queueNameNonTX, protocol, false, drop);
    }

    private void testPageLimitMessageFailInternal(String queueName, String protocol, boolean transacted, boolean drop) throws Exception {
        Queue serverQueue = this.server.locateQueue(queueName);
        Assertions.assertNotNull((Object)serverQueue);
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            TextMessage message;
            TextMessage message2;
            int i;
            Session session = connection.createSession(transacted, transacted ? 0 : 1);
            jakarta.jms.Queue queue = session.createQueue(queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            connection.start();
            for (i = 0; i < 100; ++i) {
                message2 = session.createTextMessage("initial " + i);
                message2.setIntProperty("i", i);
                producer.send((Message)message2);
            }
            if (transacted) {
                session.commit();
                Assertions.assertTrue((boolean)serverQueue.getPagingStore().isPaging());
            }
            for (i = 0; i < 300; ++i) {
                if (i == 200) {
                    try (MessageConsumer consumer = session.createConsumer((Destination)queue);){
                        for (int initI = 0; initI < 100; ++initI) {
                            TextMessage recMessage = (TextMessage)consumer.receive(1000L);
                            Assertions.assertEquals((Object)("initial " + initI), (Object)recMessage.getText());
                        }
                    }
                    if (transacted) {
                        session.commit();
                    }
                    Wait.assertEquals((long)200L, () -> ((Queue)serverQueue).getMessageCount());
                }
                try {
                    message2 = session.createTextMessage("hello world " + i);
                    message2.setIntProperty("i", i);
                    producer.send((Message)message2);
                    if (i % 100 == 0) {
                        logger.info("sent " + i);
                    }
                    if (!transacted || i % 100 != 0 || i <= 0) continue;
                    session.commit();
                    continue;
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                    Assertions.fail((String)("Exception happened at " + i));
                }
            }
            if (transacted) {
                session.commit();
            }
            try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
                producer.send((Message)session.createTextMessage("should not complete"));
                if (transacted) {
                    session.commit();
                }
                if (!drop) {
                    Assertions.fail((String)"an Exception was expected");
                }
                Assertions.assertTrue((boolean)loggerHandler.findText(new String[]{"AMQ224120"}));
            }
            catch (JMSException e) {
                logger.debug("Expected exception, ok!", (Throwable)e);
            }
            Assertions.assertTrue((boolean)serverQueue.getPagingStore().isPaging());
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            for (int i2 = 0; i2 < 150; ++i2) {
                TextMessage message3 = (TextMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)message3);
                Assertions.assertEquals((Object)("hello world " + i2), (Object)message3.getText());
                Assertions.assertEquals((int)i2, (int)message3.getIntProperty("i"));
                if (!transacted || i2 % 100 != 0 || i2 <= 0) continue;
                session.commit();
            }
            if (transacted) {
                session.commit();
            }
            Future cleanupDone = serverQueue.getPagingStore().getCursorProvider().scheduleCleanup();
            Assertions.assertTrue((boolean)((Boolean)cleanupDone.get(30L, TimeUnit.SECONDS)));
            for (int i3 = 300; i3 < 450; ++i3) {
                try {
                    message = session.createTextMessage("hello world " + i3);
                    message.setIntProperty("i", i3);
                    producer.send((Message)message);
                    if (i3 % 100 == 0) {
                        logger.info("sent " + i3);
                    }
                    if (!transacted || i3 % 10 != 0 || i3 <= 0) continue;
                    session.commit();
                    continue;
                }
                catch (Exception e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                    Assertions.fail((String)("Exception happened at " + i3));
                }
            }
            if (transacted) {
                session.commit();
            }
            try (AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();){
                producer.send((Message)session.createTextMessage("should not complete"));
                if (transacted) {
                    session.commit();
                }
                if (!drop) {
                    Assertions.fail((String)"an Exception was expected");
                } else {
                    Assertions.assertFalse((boolean)loggerHandler.findText(new String[]{"AMQ224120"}));
                }
            }
            catch (JMSException e) {
                logger.debug("Expected exception, ok!", (Throwable)e);
            }
            for (int i4 = 150; i4 < 450; ++i4) {
                message = (TextMessage)consumer.receive(5000L);
                Assertions.assertNotNull((Object)message);
                Assertions.assertEquals((Object)("hello world " + i4), (Object)message.getText());
                Assertions.assertEquals((int)i4, (int)message.getIntProperty("i"));
                if (!transacted || i4 % 100 != 0 || i4 <= 0) continue;
                session.commit();
            }
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
    }

    @Test
    public void testPageLimitBytesAMQP() throws Exception {
        this.testPageLimitBytes("AMQP");
    }

    @Test
    public void testPageLimitBytesCore() throws Exception {
        this.testPageLimitBytes("CORE");
    }

    @Test
    public void testPageLimitBytesOpenWire() throws Exception {
        this.testPageLimitBytes("OPENWIRE");
    }

    public void testPageLimitBytes(String protocol) throws Exception {
        String queueNameTX = this.getName() + "_TX";
        String queueNameNonTX = this.getName() + "_NONTX";
        Configuration config = this.createDefaultConfig(true);
        config.setJournalSyncTransactional(false).setJournalSyncTransactional(false);
        int PAGE_MAX = 20480;
        int PAGE_SIZE = 10240;
        this.server = this.createServer(true, config, 10240, 20480L, -1, -1, 204800L, null, "FAIL", null);
        this.server.start();
        this.server.addAddressInfo(new AddressInfo(queueNameTX).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)queueNameTX).setRoutingType(RoutingType.ANYCAST));
        this.server.addAddressInfo(new AddressInfo(queueNameNonTX).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)queueNameNonTX).setRoutingType(RoutingType.ANYCAST));
        Wait.assertTrue(() -> this.server.locateQueue(queueNameNonTX) != null);
        Wait.assertTrue(() -> this.server.locateQueue(queueNameTX) != null);
        this.testPageLimitBytesFailInternal(queueNameTX, protocol, true);
        this.testPageLimitBytesFailInternal(queueNameNonTX, protocol, false);
    }

    private void testPageLimitBytesFailInternal(String queueName, String protocol, boolean transacted) throws Exception {
        Queue serverQueue = this.server.locateQueue(queueName);
        Assertions.assertNotNull((Object)serverQueue);
        ConnectionFactory factory = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        try (Connection connection = factory.createConnection();){
            Session session = connection.createSession(transacted, transacted ? 0 : 1);
            jakarta.jms.Queue queue = session.createQueue(queueName);
            MessageProducer producer = session.createProducer((Destination)queue);
            connection.start();
            int successfullSends = 0;
            boolean failed = false;
            for (int i = 0; i < 1000; ++i) {
                block28: {
                    try {
                        TextMessage message = session.createTextMessage("hello world " + i);
                        message.setIntProperty("i", i);
                        producer.send((Message)message);
                        if (!transacted) break block28;
                        session.commit();
                    }
                    catch (Exception e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                        failed = true;
                        break;
                    }
                }
                ++successfullSends;
            }
            Wait.assertEquals((long)successfullSends, () -> ((Queue)serverQueue).getMessageCount());
            Assertions.assertTrue((boolean)failed);
            int reads = successfullSends / 2;
            connection.start();
            try (MessageConsumer consumer = session.createConsumer((Destination)queue);){
                for (int i = 0; i < reads; ++i) {
                    TextMessage message = (TextMessage)consumer.receive(5000L);
                    Assertions.assertNotNull((Object)message);
                    Assertions.assertEquals((Object)("hello world " + i), (Object)message.getText());
                    Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
                    if (!transacted || i % 100 != 0 || i <= 0) continue;
                    session.commit();
                }
                if (transacted) {
                    session.commit();
                }
            }
            failed = false;
            int originalSuccess = successfullSends;
            Future result = serverQueue.getPagingStore().getCursorProvider().scheduleCleanup();
            Assertions.assertTrue((boolean)((Boolean)result.get(10L, TimeUnit.SECONDS)));
            for (int i = successfullSends; i < 1000; ++i) {
                block30: {
                    try {
                        TextMessage message = session.createTextMessage("hello world " + i);
                        message.setIntProperty("i", i);
                        producer.send((Message)message);
                        if (!transacted) break block30;
                        session.commit();
                    }
                    catch (Exception e) {
                        logger.debug(e.getMessage(), (Throwable)e);
                        failed = true;
                        break;
                    }
                }
                ++successfullSends;
            }
            Assertions.assertTrue((boolean)failed);
            Assertions.assertTrue((successfullSends > originalSuccess ? (byte)1 : 0) != 0);
            try (MessageConsumer consumer = session.createConsumer((Destination)queue);){
                for (int i = reads; i < successfullSends; ++i) {
                    TextMessage message = (TextMessage)consumer.receive(5000L);
                    Assertions.assertNotNull((Object)message);
                    Assertions.assertEquals((Object)("hello world " + i), (Object)message.getText());
                    Assertions.assertEquals((int)i, (int)message.getIntProperty("i"));
                    if (!transacted || i % 100 != 0 || i <= 0) continue;
                    session.commit();
                }
                if (transacted) {
                    session.commit();
                }
                Assertions.assertNull((Object)consumer.receiveNoWait());
            }
        }
    }
}

