/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ssl;

import java.util.Map;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyAcceptor;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.ssl.SSLTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class SSLProviderTwoWayTest
extends SSLTestBase {
    public SSLProviderTwoWayTest(String sslProvider, String clientSslProvider) {
        super(sslProvider, clientSslProvider);
    }

    @Override
    protected void configureSSLParameters(Map<String, Object> params) {
        super.configureSSLParameters(params);
        params.put("trustStorePath", this.SERVER_SIDE_TRUSTSTORE);
        params.put("trustStorePassword", "securepass");
        params.put("trustStoreType", "JKS");
        params.put("needClientAuth", true);
    }

    @TestTemplate
    public void testProviderConfig() {
        NettyAcceptor acceptor = (NettyAcceptor)this.server.getRemotingService().getAcceptor(this.getNettyAcceptorName());
        Assertions.assertNotNull((Object)acceptor);
        String sslProviderInUse = (String)acceptor.getConfiguration().get("sslProvider");
        Assertions.assertEquals((Object)this.sslProvider, (Object)sslProviderInUse);
        Assertions.assertTrue((boolean)((Boolean)acceptor.getConfiguration().get("needClientAuth")));
    }

    @TestTemplate
    public void testProviderLoading2Way() throws Exception {
        Assumptions.assumeTrue((boolean)this.isOpenSSLSupported());
        String text = "Hello SSL!";
        StringBuilder uri = new StringBuilder("tcp://" + this.tc.getParams().get("host").toString() + ":" + this.tc.getParams().get("port").toString());
        uri.append("?").append("sslEnabled").append("=true");
        uri.append("&").append("sslProvider").append("=").append(this.clientSslProvider);
        uri.append("&").append("keyStoreType").append("=").append("JKS");
        uri.append("&").append("keyStorePath").append("=").append(this.CLIENT_SIDE_KEYSTORE);
        uri.append("&").append("keyStorePassword").append("=").append("securepass");
        uri.append("&").append("trustStoreType").append("=JKS");
        uri.append("&").append("trustStorePath").append("=").append(this.CLIENT_SIDE_TRUSTSTORE);
        uri.append("&").append("trustStorePassword").append("=").append("securepass");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocator((String)uri.toString()));
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession session = this.addClientSession(sf.createSession(false, true, true));
        session.createQueue(QueueConfiguration.of((String)"ssl.test.queue").setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = this.addClientProducer(session.createProducer("ssl.test.queue"));
        ClientMessage message = this.createTextMessage(session, "Hello SSL!");
        producer.send((Message)message);
        ClientConsumer consumer = this.addClientConsumer(session.createConsumer("ssl.test.queue"));
        session.start();
        ClientMessage m = consumer.receive(1000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"Hello SSL!", (Object)m.getBodyBuffer().readString());
    }
}

