/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.config.impl;

import java.util.HashMap;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.remoting.impl.TransportConfigurationUtil;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TransportConfigurationTest
extends ActiveMQTestBase {
    @Test
    public void testSplitNullAddress() throws Exception {
        String[] addresses = TransportConfiguration.splitHosts(null);
        Assertions.assertNotNull((Object)addresses);
        Assertions.assertEquals((int)0, (int)addresses.length);
    }

    @Test
    public void testSplitSingleAddress() throws Exception {
        String[] addresses = TransportConfiguration.splitHosts((String)"localhost");
        Assertions.assertNotNull((Object)addresses);
        Assertions.assertEquals((int)1, (int)addresses.length);
        Assertions.assertEquals((Object)"localhost", (Object)addresses[0]);
    }

    @Test
    public void testSplitManyAddresses() throws Exception {
        String[] addresses = TransportConfiguration.splitHosts((String)"localhost, 127.0.0.1, 192.168.0.10");
        Assertions.assertNotNull((Object)addresses);
        Assertions.assertEquals((int)3, (int)addresses.length);
        Assertions.assertEquals((Object)"localhost", (Object)addresses[0]);
        Assertions.assertEquals((Object)"127.0.0.1", (Object)addresses[1]);
        Assertions.assertEquals((Object)"192.168.0.10", (Object)addresses[2]);
    }

    @Test
    public void testSameHostNettyTrue() {
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("host", "blah");
        params1.put("port", "5467");
        TransportConfiguration tc1 = new TransportConfiguration(NettyConnectorFactory.class.getName(), params1);
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("host", "blah");
        params2.put("port", "5467");
        TransportConfiguration tc2 = new TransportConfiguration(NettyConnectorFactory.class.getName(), params2);
        Assertions.assertTrue((boolean)TransportConfigurationUtil.isSameHost((TransportConfiguration)tc1, (TransportConfiguration)tc2));
    }

    @Test
    public void testSameHostNettyFalse() {
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("host", "blah");
        params1.put("port", "5467");
        TransportConfiguration tc1 = new TransportConfiguration(NettyConnectorFactory.class.getName(), params1);
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("host", "blah2");
        params2.put("port", "5467");
        TransportConfiguration tc2 = new TransportConfiguration(NettyConnectorFactory.class.getName(), params2);
        Assertions.assertFalse((boolean)TransportConfigurationUtil.isSameHost((TransportConfiguration)tc1, (TransportConfiguration)tc2));
    }

    @Test
    public void testSameHostNettyTrueDefault() {
        HashMap<String, Object> params1 = new HashMap<String, Object>();
        params1.put("host", "localhost");
        params1.put("port", 61616);
        TransportConfiguration tc1 = new TransportConfiguration(NettyConnectorFactory.class.getName(), params1);
        HashMap params2 = new HashMap();
        TransportConfiguration tc2 = new TransportConfiguration(NettyConnectorFactory.class.getName(), params2);
        Assertions.assertTrue((boolean)TransportConfigurationUtil.isSameHost((TransportConfiguration)tc1, (TransportConfiguration)tc2));
    }

    @Test
    public void testSameHostInVMTrue() {
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("serverId", "blah");
        TransportConfiguration tc1 = new TransportConfiguration(INVM_CONNECTOR_FACTORY, params1);
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("serverId", "blah");
        TransportConfiguration tc2 = new TransportConfiguration(NettyConnectorFactory.class.getName(), params2);
        Assertions.assertTrue((boolean)TransportConfigurationUtil.isSameHost((TransportConfiguration)tc1, (TransportConfiguration)tc2));
    }

    @Test
    public void testSameHostInVMFalse() {
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("serverId", "blah");
        TransportConfiguration tc1 = new TransportConfiguration(INVM_CONNECTOR_FACTORY, params1);
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("serverId", "blah3");
        TransportConfiguration tc2 = new TransportConfiguration(NettyConnectorFactory.class.getName(), params2);
        Assertions.assertFalse((boolean)TransportConfigurationUtil.isSameHost((TransportConfiguration)tc1, (TransportConfiguration)tc2));
    }

    @Test
    public void testSameHostInVMTrueDefault() {
        HashMap<String, String> params1 = new HashMap<String, String>();
        params1.put("serverId", "0");
        TransportConfiguration tc1 = new TransportConfiguration(INVM_CONNECTOR_FACTORY, params1);
        HashMap params2 = new HashMap();
        TransportConfiguration tc2 = new TransportConfiguration(NettyConnectorFactory.class.getName(), params2);
        Assertions.assertTrue((boolean)TransportConfigurationUtil.isSameHost((TransportConfiguration)tc1, (TransportConfiguration)tc2));
    }
}

