/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.ra;

import java.util.HashMap;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQXAResourceWrapper;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.apache.activemq.artemis.tests.unit.ra.BootstrapContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ActiveMQXAResourceWrapperTest
extends ActiveMQTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMe() throws Exception {
        ActiveMQServer server = this.createServer(false, true);
        ActiveMQResourceAdapter ra = null;
        ClientSession cs = null;
        try {
            server.getConfiguration().setSecurityEnabled(false);
            server.start();
            ra = new ActiveMQResourceAdapter();
            ra.setConnectorClassName(NETTY_CONNECTOR_FACTORY);
            ra.setConnectionTTL(Long.valueOf(4000L));
            ra.start((jakarta.resource.spi.BootstrapContext)new BootstrapContext());
            XARecoveryConfig[] configs = ra.getRecoveryManager().getResources().toArray(new XARecoveryConfig[0]);
            TestActiveMQXAResourceWrapper wrapper = new TestActiveMQXAResourceWrapper(configs);
            XAResource res = wrapper.connect();
            if (!(res instanceof ClientSession)) {
                Assertions.fail((String)"Unexpected XAResource type");
            }
            cs = (ClientSession)res;
            Assertions.assertEquals((long)4000L, (long)cs.getSessionFactory().getServerLocator().getConnectionTTL());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("host", "localhost");
            params.put("port", 61616);
            params.put("connectionTtl", 60000L);
            XARecoveryConfig backup = new XARecoveryConfig(true, new TransportConfiguration[]{new TransportConfiguration(NETTY_CONNECTOR_FACTORY, params)}, null, null, null, configs[0].getClientProtocolManager());
            wrapper.updateRecoveryConfig(new XARecoveryConfig[]{backup});
            res = wrapper.connect();
            if (!(res instanceof ClientSession)) {
                Assertions.fail((String)"Unexpected XAResource type");
            }
            cs = (ClientSession)res;
            Assertions.assertEquals((long)60000L, (long)cs.getSessionFactory().getServerLocator().getConnectionTTL());
        }
        finally {
            if (cs != null) {
                cs.close();
            }
            if (ra != null) {
                ra.stop();
            }
            server.stop();
        }
    }

    class TestActiveMQXAResourceWrapper
    extends ActiveMQXAResourceWrapper {
        TestActiveMQXAResourceWrapper(XARecoveryConfig[] configs) {
            super(configs);
        }

        protected XAResource connect() throws Exception {
            return super.connect();
        }
    }
}

