/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonObject;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateNestingContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.common.NamedValues;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.spi.WithParametersPredicateBuilder;

public class ElasticsearchWithParametersPredicate
extends AbstractElasticsearchPredicate {
    private final ElasticsearchSearchIndexScope<?> scope;
    private final Function<? super NamedValues, ? extends PredicateFinalStep> predicateCreator;

    private ElasticsearchWithParametersPredicate(Builder builder) {
        super(builder);
        this.scope = builder.scope;
        this.predicateCreator = builder.predicateCreator;
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        ElasticsearchSearchPredicate providedPredicate = ElasticsearchSearchPredicate.from(this.scope, this.predicateCreator.apply((NamedValues)context.queryParameters()).toPredicate());
        providedPredicate.checkNestableWithin(PredicateNestingContext.nested(context.getNestedPath()));
        return providedPredicate.toJsonQuery(context);
    }

    @Override
    public void checkNestableWithin(PredicateNestingContext context) {
    }

    public static class Builder
    extends AbstractElasticsearchPredicate.AbstractBuilder
    implements WithParametersPredicateBuilder {
        private Function<? super NamedValues, ? extends PredicateFinalStep> predicateCreator;

        Builder(ElasticsearchSearchIndexScope<?> scope) {
            super(scope);
        }

        public void creator(Function<? super NamedValues, ? extends PredicateFinalStep> predicateCreator) {
            this.predicateCreator = predicateCreator;
        }

        public SearchPredicate build() {
            return new ElasticsearchWithParametersPredicate(this);
        }
    }
}

