/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.webservices.dmr.Attributes;
import org.jboss.as.webservices.dmr.Namespace;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

final class WSSubsystemWriter
implements XMLElementWriter<SubsystemMarshallingContext> {
    WSSubsystemWriter() {
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode subsystem = context.getModelNode();
        if (Attributes.STATISTICS_ENABLED.isMarshallable(subsystem)) {
            Attributes.STATISTICS_ENABLED.marshallAsAttribute(subsystem, (XMLStreamWriter)writer);
        }
        for (SimpleAttributeDefinition attr : Attributes.SUBSYSTEM_ATTRIBUTES) {
            attr.getMarshaller().marshallAsElement((AttributeDefinition)attr, subsystem, true, (XMLStreamWriter)writer);
        }
        if (subsystem.hasDefined("endpoint-config")) {
            ModelNode endpointConfigs = subsystem.get("endpoint-config");
            WSSubsystemWriter.writeConfigs("endpoint-config", writer, endpointConfigs);
        }
        if (subsystem.hasDefined("client-config")) {
            ModelNode clientConfigs = subsystem.get("client-config");
            WSSubsystemWriter.writeConfigs("client-config", writer, clientConfigs);
        }
        writer.writeEndElement();
    }

    private static void writeConfigs(String elementName, XMLExtendedStreamWriter writer, ModelNode configs) throws XMLStreamException {
        ModelNode config = null;
        for (String configName : configs.keys()) {
            ModelNode handlerChains;
            config = configs.get(configName);
            writer.writeStartElement(elementName);
            writer.writeAttribute("name", configName);
            if (config.hasDefined("pre-handler-chain")) {
                handlerChains = config.get("pre-handler-chain");
                WSSubsystemWriter.writeHandlerChains(writer, handlerChains, true);
            }
            if (config.hasDefined("post-handler-chain")) {
                handlerChains = config.get("post-handler-chain");
                WSSubsystemWriter.writeHandlerChains(writer, handlerChains, false);
            }
            if (config.hasDefined("property")) {
                ModelNode properties = config.get("property");
                WSSubsystemWriter.writeProperties(writer, properties);
            }
            writer.writeEndElement();
        }
    }

    private static void writeProperties(XMLExtendedStreamWriter writer, ModelNode properties) throws XMLStreamException {
        for (String propertyName : properties.keys()) {
            ModelNode property = properties.get(propertyName);
            writer.writeStartElement("property");
            writer.writeAttribute("name", propertyName);
            Attributes.VALUE.marshallAsAttribute(property, false, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
    }

    private static void writeHandlerChains(XMLExtendedStreamWriter writer, ModelNode handlerChains, boolean isPre) throws XMLStreamException {
        ModelNode handlerChain = null;
        ModelNode handler = null;
        for (String handlerChainName : handlerChains.keys()) {
            handlerChain = handlerChains.get(handlerChainName);
            writer.writeStartElement(isPre ? "pre-handler-chain" : "post-handler-chain");
            writer.writeAttribute("name", handlerChainName);
            if (handlerChain.hasDefined("protocol-bindings")) {
                String protocolBinding = handlerChain.get("protocol-bindings").asString();
                writer.writeAttribute("protocol-bindings", protocolBinding);
            }
            if (handlerChain.hasDefined("handler")) {
                for (String handlerName : handlerChain.require("handler").keys()) {
                    handler = handlerChain.get("handler").get(handlerName);
                    writer.writeStartElement("handler");
                    writer.writeAttribute("name", handlerName);
                    Attributes.CLASS.marshallAsAttribute(handler, (XMLStreamWriter)writer);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
        }
    }
}

