/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Supplier;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.as.server.deployment.SetupAction;
import org.jboss.as.service.logging.SarLogger;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

final class MBeanRegistrationService
implements Service {
    @Deprecated
    static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"mbean", "registration"});
    private final Supplier<MBeanServer> mBeanServerSupplier;
    private final Supplier<Object> objectSupplier;
    private final String name;
    private ObjectName objectName;
    private final List<SetupAction> setupActions;

    public MBeanRegistrationService(String name, List<SetupAction> setupActions, Supplier<MBeanServer> mBeanServerSupplier, Supplier<Object> objectSupplier) {
        this.name = name;
        this.setupActions = setupActions;
        this.mBeanServerSupplier = mBeanServerSupplier;
        this.objectSupplier = objectSupplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void start(StartContext context) throws StartException {
        MBeanServer mBeanServer = this.getMBeanServer();
        Object value = this.objectSupplier.get();
        try {
            this.objectName = new ObjectName(this.name);
        }
        catch (MalformedObjectNameException e) {
            throw SarLogger.ROOT_LOGGER.mbeanRegistrationFailed(e, this.name);
        }
        try {
            for (SetupAction action : this.setupActions) {
                action.setup(Collections.emptyMap());
            }
            try {
                SarLogger.ROOT_LOGGER.debugf("Registering [%s] with name [%s]", value, this.objectName);
                mBeanServer.registerMBean(value, this.objectName);
            }
            catch (Exception e) {
                throw SarLogger.ROOT_LOGGER.mbeanRegistrationFailed(e, this.name);
            }
        }
        finally {
            ListIterator<SetupAction> it = this.setupActions.listIterator(this.setupActions.size());
            while (it.hasPrevious()) {
                SetupAction action;
                action = it.previous();
                action.teardown(Collections.emptyMap());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop(StopContext context) {
        if (this.objectName == null) {
            SarLogger.ROOT_LOGGER.cannotUnregisterObject();
        }
        MBeanServer mBeanServer = this.getMBeanServer();
        try {
            for (SetupAction action : this.setupActions) {
                action.setup(Collections.emptyMap());
            }
            try {
                mBeanServer.unregisterMBean(this.objectName);
            }
            catch (Exception e) {
                SarLogger.ROOT_LOGGER.unregistrationFailure(e, this.objectName);
            }
        }
        finally {
            ListIterator<SetupAction> it = this.setupActions.listIterator(this.setupActions.size());
            while (it.hasPrevious()) {
                SetupAction action;
                action = it.previous();
                action.teardown(Collections.emptyMap());
            }
        }
    }

    private MBeanServer getMBeanServer() {
        MBeanServer mBeanServer = this.mBeanServerSupplier.get();
        if (mBeanServer == null) {
            mBeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        return mBeanServer;
    }
}

