/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.cli.CLIException;
import org.apache.activemq.artemis.cli.commands.ActionContext;
import org.apache.activemq.artemis.cli.commands.InputAbstract;
import picocli.CommandLine;

public class InstallAbstract
extends InputAbstract {
    protected static final String LOG_DIRNAME = "log";
    protected static final String OOM_DUMP_FILENAME = "oom_dump.hprof";
    @CommandLine.Parameters(description={"The instance directory to hold the broker's configuration and data. Path must be writable."})
    protected File directory;
    @CommandLine.Option(names={"--etc"}, description={"Directory where ActiveMQ configuration is located. Paths can be absolute or relative to artemis.instance directory. Default: etc."})
    protected String etc = "etc";
    @CommandLine.Option(names={"--data"}, description={"Directory where ActiveMQ data are stored. Paths can be absolute or relative to artemis.instance directory. Default: data."})
    protected String data = "data";
    @CommandLine.Option(names={"--home"}, description={"Directory where ActiveMQ Artemis is installed."})
    protected File home;
    @CommandLine.Option(names={"--encoding"}, description={"The encoding that text files should use. Default: UTF-8."})
    protected String encoding = "UTF-8";
    @CommandLine.Option(names={"--windows"}, description={"Force Windows script creation. Default: based on your actual system."})
    protected boolean windows = false;
    @CommandLine.Option(names={"--cygwin", "--linux"}, description={"Force Linux or Cygwin script creation. Default: based on your actual system."})
    protected boolean nix = false;
    @CommandLine.Option(names={"--java-options"}, description={"Extra Java options to be passed to the profile."})
    protected List<String> javaOptions;
    @CommandLine.Option(names={"--java-utility-options"}, description={"Extra Java options to be passed to the utility profile."})
    protected List<String> javaUtilityOptions;
    @CommandLine.Option(names={"--java-memory"}, description={"Define the -Xmx memory parameter for the broker. Default: 2G."})
    protected String javaMemory = "2G";
    protected boolean IS_WINDOWS;
    protected boolean IS_NIX;

    protected String getJavaOptions() {
        StringBuilder builder = new StringBuilder();
        if (this.javaOptions != null) {
            this.javaOptions.forEach(s -> builder.append((String)s).append(" "));
        }
        return builder.toString();
    }

    protected String getJavaUtilityOptions() {
        StringBuilder builder = new StringBuilder();
        if (this.javaUtilityOptions != null) {
            this.javaUtilityOptions.forEach(s -> builder.append((String)s).append(" "));
        }
        return builder.toString();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public File getInstance() {
        return this.directory;
    }

    public void setInstance(File directory) {
        this.directory = directory;
    }

    public File getHome() {
        if (this.home == null) {
            this.home = new File(this.getBrokerHome());
        }
        return this.home;
    }

    public File getDirectory() {
        return this.directory;
    }

    public InstallAbstract setDirectory(File directory) {
        this.directory = directory;
        return this;
    }

    public boolean isWindows() {
        return this.windows;
    }

    public InstallAbstract setWindows(boolean windows) {
        this.windows = windows;
        return this;
    }

    public boolean isNix() {
        return this.nix;
    }

    public InstallAbstract setNix(boolean nix) {
        this.nix = nix;
        return this;
    }

    public Object run(ActionContext context) throws Exception {
        this.IS_NIX = false;
        this.IS_WINDOWS = false;
        if (this.nix) {
            this.IS_NIX = true;
            return null;
        }
        if (this.windows) {
            this.IS_WINDOWS = true;
            return null;
        }
        if ("cygwin".equals(System.getenv("OSTYPE"))) {
            this.IS_NIX = true;
            return null;
        }
        if (System.getProperty("os.name").toLowerCase().trim().startsWith("win")) {
            this.IS_WINDOWS = true;
            return null;
        }
        this.IS_NIX = true;
        return null;
    }

    protected static String applyFilters(String content, Map<String, String> filters) {
        if (filters != null) {
            for (Map.Entry<String, String> entry : filters.entrySet()) {
                content = InstallAbstract.replace(content, entry.getKey(), entry.getValue());
            }
        }
        return content;
    }

    protected static String replace(String content, String key, String value) {
        return content.replaceAll(Pattern.quote(key), Matcher.quoteReplacement(value));
    }

    protected static void copy(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[4096];
        int c = is.read(buffer);
        while (c >= 0) {
            os.write(buffer, 0, c);
            c = is.read(buffer);
        }
    }

    protected void write(String source, File target, HashMap<String, String> filters, boolean unixTarget, boolean force) throws Exception {
        if (target.exists() && !force) {
            throw new CLIException(String.format("The file '%s' already exists.  Use --force to overwrite.", target));
        }
        String content = InstallAbstract.readTextFile(source, filters);
        if (content == null) {
            new Exception(source + " not found").printStackTrace();
        }
        String separator = unixTarget && this.IS_NIX ? "\n" : System.getProperty("line.separator");
        content = content.replaceAll("\\r?\\n", Matcher.quoteReplacement(separator));
        ByteArrayInputStream in = new ByteArrayInputStream(content.getBytes(this.encoding));
        try (FileOutputStream fout = new FileOutputStream(target);){
            InstallAbstract.copy(in, fout);
        }
    }

    protected static String readTextFile(String source, Map<String, String> filters) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (InputStream in = InstallAbstract.openStream(source);){
            if (in == null) {
                throw new IOException("could not find resource " + source);
            }
            InstallAbstract.copy(in, out);
        }
        return InstallAbstract.applyFilters(new String(out.toByteArray(), StandardCharsets.UTF_8), filters);
    }

    protected void write(String source, boolean force) throws IOException {
        File target = new File(this.directory, source);
        if (target.exists() && !force) {
            throw new RuntimeException(String.format("The file '%s' already exists.  Use --force to overwrite.", target));
        }
        try (FileOutputStream fout = new FileOutputStream(target);
             InputStream in = InstallAbstract.openStream(source);){
            InstallAbstract.copy(in, fout);
        }
    }

    protected static InputStream openStream(String source) {
        return InputAbstract.class.getResourceAsStream(source);
    }
}

