/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.io.File;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import org.infinispan.commands.module.ModuleCommandExtensions;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.AggregatedClassLoader;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.TransportConfiguration;
import org.infinispan.configuration.global.UncleanShutdownAction;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.globalstate.ConfigurationStorage;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.SerializationContextInitializer;
import org.jboss.as.clustering.controller.CommonServiceDescriptor;
import org.jboss.as.clustering.infinispan.jmx.MBeanServerProvider;
import org.jboss.as.clustering.infinispan.logging.InfinispanLogger;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanMarshallerFactory;
import org.jboss.as.clustering.infinispan.subsystem.ScheduledThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceName;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ResourceServiceInstaller;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.capability.CapabilityServiceInstaller;

public class GlobalConfigurationServiceConfigurator
implements ResourceServiceConfigurator {
    private final RuntimeCapability<Void> capability;

    GlobalConfigurationServiceConfigurator(RuntimeCapability<Void> capability) {
        this.capability = capability;
    }

    public ResourceServiceInstaller configure(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        final String containerName = address.getLastElement().getValue();
        final ServiceDependency server = context.hasOptionalCapability(CommonServiceDescriptor.MBEAN_SERVER, this.capability, null) ? ServiceDependency.on((NullaryServiceDescriptor)CommonServiceDescriptor.MBEAN_SERVER) : ServiceDependency.of(null);
        final ServiceDependency loader = ServiceDependency.on((ServiceName)Services.JBOSS_SERVICE_MODULE_LOADER);
        final ServiceDependency containerModules = ServiceDependency.on(CacheContainerResourceDefinition.CACHE_CONTAINER_MODULES, (String)containerName);
        final ServiceDependency transport = ServiceDependency.on(TransportResourceDefinition.SERVICE_DESCRIPTOR, (String)containerName);
        final ServiceDependency environment = ServiceDependency.on((NullaryServiceDescriptor)ServerEnvironment.SERVICE_DESCRIPTOR);
        final EnumMap<ThreadPoolResourceDefinition, ServiceDependency> pools = new EnumMap<ThreadPoolResourceDefinition, ServiceDependency>(ThreadPoolResourceDefinition.class);
        for (ThreadPoolResourceDefinition threadPoolResourceDefinition : EnumSet.of(ThreadPoolResourceDefinition.LISTENER, ThreadPoolResourceDefinition.BLOCKING, ThreadPoolResourceDefinition.NON_BLOCKING)) {
            pools.put(threadPoolResourceDefinition, ServiceDependency.on((UnaryServiceDescriptor)threadPoolResourceDefinition, (String)containerName));
        }
        final EnumMap<ScheduledThreadPoolResourceDefinition, ServiceDependency> scheduledPools = new EnumMap<ScheduledThreadPoolResourceDefinition, ServiceDependency>(ScheduledThreadPoolResourceDefinition.class);
        for (ScheduledThreadPoolResourceDefinition pool : EnumSet.allOf(ScheduledThreadPoolResourceDefinition.class)) {
            scheduledPools.put(pool, ServiceDependency.on((UnaryServiceDescriptor)pool, (String)containerName));
        }
        final String string = CacheContainerResourceDefinition.Attribute.DEFAULT_CACHE.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        final boolean statisticsEnabled = CacheContainerResourceDefinition.Attribute.STATISTICS_ENABLED.resolveModelAttribute((ExpressionResolver)context, model).asBoolean();
        final InfinispanMarshallerFactory marshallerFactory = InfinispanMarshallerFactory.valueOf(CacheContainerResourceDefinition.Attribute.MARSHALLER.resolveModelAttribute((ExpressionResolver)context, model).asString());
        Supplier<GlobalConfiguration> global = new Supplier<GlobalConfiguration>(){

            @Override
            public GlobalConfiguration get() {
                GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
                builder.cacheManagerName(containerName).defaultCacheName(string).cacheContainer().statistics(statisticsEnabled);
                builder.transport().read((Object)((TransportConfiguration)transport.get()));
                List modules = (List)containerModules.get();
                Marshaller marshaller = (Marshaller)marshallerFactory.apply((ModuleLoader)loader.get(), modules);
                InfinispanLogger.ROOT_LOGGER.debugf("%s cache-container will use %s", containerName, marshaller.getClass().getName());
                builder.serialization().marshaller(marshaller).addContextInitializer(new SerializationContextInitializer(){

                    @Deprecated
                    public String getProtoFile() throws UncheckedIOException {
                        return null;
                    }

                    @Deprecated
                    public String getProtoFileName() {
                        return null;
                    }

                    public void registerMarshallers(SerializationContext context) {
                    }

                    public void registerSchema(SerializationContext context) {
                    }
                });
                AggregatedClassLoader loader2 = modules.size() > 1 ? new AggregatedClassLoader((Collection)modules.stream().map(Module::getClassLoader).collect(Collectors.toList())) : ((Module)modules.get(0)).getClassLoader();
                builder.classLoader((ClassLoader)loader2);
                builder.blockingThreadPool().read((Object)((ThreadPoolConfiguration)((ServiceDependency)pools.get(ThreadPoolResourceDefinition.BLOCKING)).get()));
                builder.listenerThreadPool().read((Object)((ThreadPoolConfiguration)((ServiceDependency)pools.get(ThreadPoolResourceDefinition.LISTENER)).get()));
                builder.nonBlockingThreadPool().read((Object)((ThreadPoolConfiguration)((ServiceDependency)pools.get(ThreadPoolResourceDefinition.NON_BLOCKING)).get()));
                builder.expirationThreadPool().read((Object)((ThreadPoolConfiguration)((ServiceDependency)scheduledPools.get(ScheduledThreadPoolResourceDefinition.EXPIRATION)).get()));
                builder.shutdown().hookBehavior(ShutdownHookBehavior.DONT_REGISTER);
                builder.metrics().gauges(false).histograms(false).accurateSize(true);
                MBeanServerLookup mbeanServerProvider = Optional.ofNullable((MBeanServer)server.get()).map(MBeanServerProvider::new).orElse(null);
                builder.jmx().domain("org.wildfly.clustering.infinispan").mBeanServerLookup(mbeanServerProvider).enabled(mbeanServerProvider != null);
                ((PrivateGlobalConfigurationBuilder)builder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(!ServiceLoader.load(ModuleCommandExtensions.class, (ClassLoader)loader2).iterator().hasNext());
                String path = "infinispan" + File.separatorChar + containerName;
                builder.globalState().enable().configurationStorage(ConfigurationStorage.VOLATILE).persistentLocation(path, ((ServerEnvironment)environment.get()).getServerDataDir().getPath()).temporaryLocation(path, ((ServerEnvironment)environment.get()).getServerTempDir().getPath()).uncleanShutdownAction(UncleanShutdownAction.PURGE);
                return builder.build();
            }
        };
        return (ResourceServiceInstaller)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)((CapabilityServiceInstaller.Builder)CapabilityServiceInstaller.builder(this.capability, (Supplier)global).requires(List.of(server, loader, containerModules, transport, environment))).requires(pools.values())).requires(scheduledPools.values())).asPassive()).build();
    }
}

