/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.infinispan.persistence.jdbc.common.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.jboss.as.clustering.controller.CommonServiceDescriptor;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.infinispan.persistence.jdbc.DataSourceConnectionFactoryConfigurationBuilder;
import org.jboss.as.clustering.infinispan.persistence.jdbc.JDBCStoreConfiguration;
import org.jboss.as.clustering.infinispan.persistence.jdbc.JDBCStoreConfigurationBuilder;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanExtension;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.TableResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.modules.Module;
import org.wildfly.clustering.server.util.MapEntry;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;

public class JDBCStoreResourceDefinition
extends StoreResourceDefinition<JDBCStoreConfiguration, JDBCStoreConfigurationBuilder> {
    static final PathElement PATH = JDBCStoreResourceDefinition.pathElement("jdbc");
    static final Set<PathElement> REQUIRED_CHILDREN = Set.of(StringTableResourceDefinition.PATH);

    JDBCStoreResourceDefinition() {
        super(PATH, (ResourceDescriptionResolver)InfinispanExtension.SUBSYSTEM_RESOLVER.createChildResolver(PATH, WILDCARD_PATH), new ResourceDescriptorConfigurator(), JDBCStoreConfigurationBuilder.class);
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = super.register(parent);
        new StringTableResourceDefinition().register((org.jboss.as.controller.registry.ManagementResourceRegistration)registration);
        return registration;
    }

    @Override
    public Map.Entry<Map.Entry<Supplier<JDBCStoreConfigurationBuilder>, Consumer<JDBCStoreConfigurationBuilder>>, Stream<Consumer<RequirementServiceBuilder<?>>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress cacheAddress = context.getCurrentAddress().getParent();
        String containerName = cacheAddress.getParent().getLastElement().getValue();
        String cacheName = cacheAddress.getLastElement().getValue();
        String dataSourceName = Attribute.DATA_SOURCE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        final DatabaseType dialect = Optional.ofNullable(Attribute.DIALECT.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull()).map(DatabaseType::valueOf).orElse(null);
        final ServiceDependency dataSource = ServiceDependency.on((UnaryServiceDescriptor)CommonServiceDescriptor.DATA_SOURCE, (String)dataSourceName);
        final ServiceDependency table = ServiceDependency.on(TableResourceDefinition.SERVICE_DESCRIPTOR, (String)containerName, (String)cacheName);
        final ServiceDependency modules = ServiceDependency.on(CacheResourceDefinition.CACHE_MODULES, (String)containerName, (String)cacheName);
        Object entry = super.resolve(context, model);
        Supplier builderFactory = (Supplier)((Map.Entry)entry.getKey()).getKey();
        Consumer<JDBCStoreConfigurationBuilder> configurator = ((Consumer)((Map.Entry)entry.getKey()).getValue()).andThen(new Consumer<JDBCStoreConfigurationBuilder>(){

            @Override
            public void accept(JDBCStoreConfigurationBuilder builder) {
                builder.table().read((TableManipulationConfiguration)table.get());
                TwoWayKey2StringMapper mapper = this.findMapper();
                if (mapper != null) {
                    builder.key2StringMapper(mapper.getClass());
                }
                ((JDBCStoreConfigurationBuilder)builder.dialect(dialect)).transactional(false);
                ((DataSourceConnectionFactoryConfigurationBuilder)builder.connectionFactory(DataSourceConnectionFactoryConfigurationBuilder.class)).setDataSourceDependency((Supplier<DataSource>)dataSource);
            }

            private TwoWayKey2StringMapper findMapper() {
                for (Module module : (List)modules.get()) {
                    Iterator iterator = module.loadService(TwoWayKey2StringMapper.class).iterator();
                    if (!iterator.hasNext()) continue;
                    TwoWayKey2StringMapper mapper = (TwoWayKey2StringMapper)iterator.next();
                    return mapper;
                }
                return null;
            }
        });
        Stream dependencies = (Stream)entry.getValue();
        return MapEntry.of((Object)MapEntry.of((Object)builderFactory, configurator), Stream.concat(dependencies, Stream.of(dataSource, table, modules)));
    }

    static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        ResourceDescriptorConfigurator() {
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return descriptor.addAttributes(Attribute.class).addRequiredChildren(REQUIRED_CHILDREN);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        DATA_SOURCE("data-source", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setRequired(true)).setCapabilityReference((CapabilityReferenceRecorder)org.wildfly.subsystem.resource.capability.CapabilityReferenceRecorder.builder(StoreResourceDefinition.CAPABILITY, (UnaryServiceDescriptor)CommonServiceDescriptor.DATA_SOURCE).build());
            }
        }
        ,
        DIALECT("dialect", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(true)).setRequired(false)).setValidator((ParameterValidator)EnumValidator.create(DatabaseType.class));
            }
        };

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = ((SimpleAttributeDefinitionBuilder)this.apply((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES}))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

