/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.weld.bean.proxy;

import java.io.IOException;
import org.infinispan.protostream.descriptors.WireType;
import org.jboss.weld.bean.proxy.MethodHandler;
import org.jboss.weld.bean.proxy.TargetBeanInstance;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.weld.bean.proxy.MockBean;

public class TargetBeanInstanceMarshaller
implements ProtoStreamMarshaller<TargetBeanInstance> {
    private static final int INSTANCE_INDEX = 1;
    private static final int TYPE_INDEX = 2;
    private static final int HANDLER_INDEX = 3;

    public Class<? extends TargetBeanInstance> getJavaClass() {
        return TargetBeanInstance.class;
    }

    public TargetBeanInstance readFrom(ProtoStreamReader reader) throws IOException {
        Object instance = null;
        Class type = null;
        MethodHandler handler = null;
        block5: while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            switch (WireType.getTagFieldNumber((int)tag)) {
                case 1: {
                    instance = reader.readAny();
                    continue block5;
                }
                case 2: {
                    type = (Class)reader.readObject(Class.class);
                    continue block5;
                }
                case 3: {
                    handler = (MethodHandler)reader.readAny(MethodHandler.class);
                    continue block5;
                }
            }
            reader.skipField(tag);
        }
        TargetBeanInstance result = type != null ? new TargetBeanInstance(new MockBean(type), instance) : new TargetBeanInstance(instance);
        result.setInterceptorsHandler(handler);
        return result;
    }

    public void writeTo(ProtoStreamWriter writer, TargetBeanInstance source) throws IOException {
        MethodHandler handler;
        Class type;
        Object instance = source.getInstance();
        if (instance != null) {
            writer.writeAny(1, instance);
        }
        if ((type = source.getInstanceType()) != null && type != instance.getClass()) {
            writer.writeObject(2, (Object)type);
        }
        if ((handler = source.getInterceptorsHandler()) != null) {
            writer.writeAny(3, (Object)handler);
        }
    }
}

