/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.MultivaluedTreeMap;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResourceInvoker;
import org.jboss.resteasy.spi.ResteasyConfiguration;

public abstract class AbstractPatchMethodFilter
implements ContainerRequestFilter {
    public static final String APPLICATION_JSON_MERGE_PATCH_JSON = "application/merge-patch+json";
    public static final MediaType APPLICATION_JSON_MERGE_PATCH_JSON_TYPE = new MediaType("application", "merge-patch+json");
    @Context
    protected Providers providers;

    protected FilterFlag readFilterDisabledFlag(ContainerRequestContext requestContext) {
        if (requestContext.getMethod().equals("PATCH") && (MediaType.APPLICATION_JSON_PATCH_JSON_TYPE.isCompatible(requestContext.getMediaType()) || APPLICATION_JSON_MERGE_PATCH_JSON_TYPE.isCompatible(requestContext.getMediaType()))) {
            ResteasyConfiguration context = ResteasyContext.getContextData(ResteasyConfiguration.class);
            boolean disabled = false;
            boolean legacyFilter = false;
            if (context == null) {
                disabled = Boolean.getBoolean("resteasy.patchfilter.disabled");
                if (!disabled) {
                    legacyFilter = Boolean.getBoolean("resteasy.patchfilter.legacy");
                }
            } else {
                disabled = Boolean.parseBoolean(context.getParameter("resteasy.patchfilter.disabled"));
                if (!disabled) {
                    legacyFilter = Boolean.parseBoolean(context.getParameter("resteasy.patchfilter.legacy"));
                }
            }
            if (disabled) {
                return FilterFlag.SKIP;
            }
            if (legacyFilter) {
                return FilterFlag.JACKSON;
            }
            return FilterFlag.JSONP;
        }
        return FilterFlag.SKIP;
    }

    protected abstract boolean isDisabled(ContainerRequestContext var1);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (this.isDisabled(requestContext)) {
            return;
        }
        HttpRequest request = ResteasyContext.getContextData(HttpRequest.class);
        HttpResponse response = ResteasyContext.getContextData(HttpResponse.class);
        ArrayList<String> patchContentTypeList = new ArrayList<String>();
        for (Object header : request.getHttpHeaders().getRequestHeader("Content-Type")) {
            patchContentTypeList.add((String)header);
        }
        ArrayList<String> acceptHeaders = new ArrayList<String>();
        for (String header : request.getHttpHeaders().getRequestHeader("Accept")) {
            acceptHeaders.add(header);
        }
        ByteArrayOutputStream tmpOutputStream = new ByteArrayOutputStream();
        try {
            request.setHttpMethod("GET");
            requestContext.getHeaders().putSingle((Object)"Content-Type", (Object)"*/*");
            requestContext.getHeaders().putSingle((Object)"Accept", (Object)"application/json");
            ResourceMethodInvoker methodInvoker = this.getMethodInvoker(requestContext);
            Object targetObject = this.getTargetObject(requestContext, methodInvoker);
            MessageBodyWriter msgBodyWriter = this.providers.getMessageBodyWriter(targetObject.getClass(), targetObject.getClass(), methodInvoker.getMethodAnnotations(), MediaType.APPLICATION_JSON_TYPE);
            if (msgBodyWriter == null) {
                throw new ProcessingException(Messages.MESSAGES.couldNotFindWriterForContentType(MediaType.APPLICATION_JSON_TYPE, targetObject.getClass().getName()));
            }
            msgBodyWriter.writeTo(targetObject, targetObject.getClass(), targetObject.getClass(), methodInvoker.getMethodAnnotations(), MediaType.APPLICATION_JSON_TYPE, new MultivaluedTreeMap(), (OutputStream)tmpOutputStream);
        }
        catch (ProcessingException pe) {
            Throwable c = pe.getCause();
            if (c != null && c instanceof ApplicationException && (c = c.getCause()) != null && c instanceof NotFoundException) {
                throw (NotFoundException)c;
            }
            throw pe;
        }
        finally {
            requestContext.getHeaders().put((Object)"Content-Type", patchContentTypeList);
            requestContext.getHeaders().put((Object)"Accept", acceptHeaders);
            request.setHttpMethod("PATCH");
        }
        try {
            byte[] patchResult = this.applyPatch(requestContext, tmpOutputStream.toByteArray());
            request.setInputStream((InputStream)new ByteArrayInputStream(patchResult));
        }
        catch (IOException e) {
            throw new BadRequestException((Throwable)e);
        }
    }

    protected abstract byte[] applyPatch(ContainerRequestContext var1, byte[] var2) throws IOException, Failure;

    protected Object getTargetObject(ContainerRequestContext requestContext, ResourceMethodInvoker methodInvoker) {
        HttpRequest request = ResteasyContext.getContextData(HttpRequest.class);
        HttpResponse response = ResteasyContext.getContextData(HttpResponse.class);
        Object targetObject = null;
        try {
            targetObject = methodInvoker.invokeDryRun(request, response).toCompletableFuture().getNow(null);
        }
        catch (Exception e) {
            if (e.getCause() instanceof WebApplicationException) {
                throw e;
            }
            LogMessages.LOGGER.errorPatchTarget(requestContext.getUriInfo().getRequestUri().toString());
            throw new ProcessingException("Unexpected error to get the json patch/merge target", (Throwable)e);
        }
        return targetObject;
    }

    protected ResourceMethodInvoker getMethodInvoker(ContainerRequestContext requestContext) {
        HttpRequest request = ResteasyContext.getContextData(HttpRequest.class);
        Registry methodRegistry = ResteasyContext.getContextData(Registry.class);
        ResourceInvoker resourceInovker = null;
        try {
            resourceInovker = methodRegistry.getResourceInvoker(request);
        }
        catch (Exception e) {
            LogMessages.LOGGER.patchTargetMethodNotFound(requestContext.getUriInfo().getRequestUri().toString());
            throw new ProcessingException("GET method returns the patch/merge json object target not found");
        }
        return (ResourceMethodInvoker)resourceInovker;
    }

    public static enum FilterFlag {
        SKIP,
        JACKSON,
        JSONP;

    }
}

