/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.ManagementRegistrar;
import org.jboss.as.clustering.controller.Operation;
import org.jboss.as.clustering.jgroups.subsystem.StackOperation;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.LifecycleEvent;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class StackOperationHandler
extends AbstractRuntimeOnlyHandler
implements ManagementRegistrar<ManagementResourceRegistration> {
    private final Map<String, Operation<ChannelFactory>> operations = new HashMap<String, Operation<ChannelFactory>>();

    public StackOperationHandler() {
        for (Operation operation : EnumSet.allOf(StackOperation.class)) {
            this.operations.put(operation.getName(), (Operation<ChannelFactory>)operation);
        }
    }

    protected synchronized void executeRuntimeStep(final OperationContext context, final ModelNode op) throws OperationFailedException {
        String name = op.get("operation").asString();
        final Operation<ChannelFactory> operation = this.operations.get(name);
        Function<ChannelFactory, ModelNode> operationFunction = new Function<ChannelFactory, ModelNode>(){

            @Override
            public ModelNode apply(ChannelFactory factory) {
                try {
                    return operation.execute((ExpressionResolver)context, op, (Object)factory);
                }
                catch (OperationFailedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ServiceDependency factory = ServiceDependency.on((UnaryServiceDescriptor)ChannelFactory.SERVICE_DESCRIPTOR, (String)context.getCurrentAddressValue());
        AtomicReference reference = new AtomicReference();
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch removeLatch = new CountDownLatch(1);
        ServiceController controller = ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder((Function)operationFunction, (Supplier)factory).withCaptor(reference::set)).requires((Consumer)factory)).build()).install((ServiceTarget)context.getCapabilityServiceTarget());
        controller.addListener((LifecycleListener)new CountDownLifecycleListener(startLatch, EnumSet.of(LifecycleEvent.UP, LifecycleEvent.FAILED)));
        controller.addListener((LifecycleListener)new CountDownLifecycleListener(removeLatch, EnumSet.of(LifecycleEvent.REMOVED)));
        controller.setMode(ServiceController.Mode.ACTIVE);
        try {
            startLatch.await();
            ModelNode result = (ModelNode)reference.get();
            if (result != null) {
                context.getResult().set(result);
            } else {
                context.getFailureDescription().set(controller.getStartException().getLocalizedMessage());
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException((Throwable)e);
        }
        finally {
            try {
                controller.setMode(ServiceController.Mode.REMOVE);
                removeLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }
    }

    public void register(ManagementResourceRegistration registration) {
        for (Operation operation : EnumSet.allOf(StackOperation.class)) {
            registration.registerOperationHandler((OperationDefinition)operation.getDefinition(), (OperationStepHandler)this);
        }
    }

    private static class CountDownLifecycleListener
    implements LifecycleListener {
        private final Set<LifecycleEvent> targetEvents;
        private final CountDownLatch latch;

        CountDownLifecycleListener(CountDownLatch latch, Set<LifecycleEvent> targetEvents) {
            this.targetEvents = targetEvents;
            this.latch = latch;
        }

        public void handleEvent(ServiceController<?> controller, LifecycleEvent event) {
            if (this.targetEvents.contains(event)) {
                this.latch.countDown();
            }
        }
    }
}

