/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import jakarta.ejb.ConcurrentAccessException;
import jakarta.ejb.ConcurrentAccessTimeoutException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.EJBObject;
import jakarta.ejb.RemoveException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import org.jboss.as.ee.component.BasicComponentInstance;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.component.ComponentIsStoppedException;
import org.jboss.as.ee.component.ComponentView;
import org.jboss.as.ejb3.component.DefaultAccessTimeoutService;
import org.jboss.as.ejb3.component.EJBBusinessMethod;
import org.jboss.as.ejb3.component.EJBComponentUnavailableException;
import org.jboss.as.ejb3.component.allowedmethods.AllowedMethodsInformation;
import org.jboss.as.ejb3.component.session.SessionBeanComponent;
import org.jboss.as.ejb3.component.stateful.StatefulAllowedMethodsInformation;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentCreateService;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCache;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCacheConfiguration;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanCacheFactory;
import org.jboss.as.ejb3.component.stateful.cache.StatefulSessionBeanInstanceFactory;
import org.jboss.as.ejb3.concurrency.AccessTimeoutDetails;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.ejb.client.EJBClient;
import org.jboss.ejb.client.EJBLocator;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.StatefulEJBLocator;
import org.jboss.ejb.client.UUIDSessionID;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.requestcontroller.ControlPoint;
import org.wildfly.extension.requestcontroller.RunResult;
import org.wildfly.security.manager.WildFlySecurityManager;

public class StatefulSessionComponent
extends SessionBeanComponent
implements StatefulSessionBeanInstanceFactory<StatefulSessionComponentInstance> {
    private volatile StatefulSessionBeanCache<SessionID, StatefulSessionComponentInstance> cache;
    private final InterceptorFactory afterBegin;
    private Interceptor afterBeginInterceptor;
    private final Method afterBeginMethod;
    private final InterceptorFactory afterCompletion;
    private Interceptor afterCompletionInterceptor;
    private final Method afterCompletionMethod;
    private final InterceptorFactory beforeCompletion;
    private Interceptor beforeCompletionInterceptor;
    private final Method beforeCompletionMethod;
    private final InterceptorFactory prePassivate;
    private Interceptor prePassivateInterceptor;
    private final InterceptorFactory postActivate;
    private Interceptor postActivateInterceptor;
    private final Map<EJBBusinessMethod, AccessTimeoutDetails> methodAccessTimeouts;
    private final DefaultAccessTimeoutService defaultAccessTimeoutProvider;
    private final Supplier<StatefulSessionBeanCacheFactory<SessionID, StatefulSessionComponentInstance>> cacheFactory;
    private final InterceptorFactory ejb2XRemoveMethod;
    private Interceptor ejb2XRemoveMethodInterceptor;
    private final Set<Object> serialiableInterceptorContextKeys;

    protected StatefulSessionComponent(StatefulSessionComponentCreateService ejbComponentCreateService) {
        super(ejbComponentCreateService);
        ejbComponentCreateService.setDefaultStatefulSessionTimeout();
        this.afterBegin = ejbComponentCreateService.getAfterBegin();
        this.afterBeginMethod = ejbComponentCreateService.getAfterBeginMethod();
        this.afterCompletion = ejbComponentCreateService.getAfterCompletion();
        this.afterCompletionMethod = ejbComponentCreateService.getAfterCompletionMethod();
        this.beforeCompletion = ejbComponentCreateService.getBeforeCompletion();
        this.beforeCompletionMethod = ejbComponentCreateService.getBeforeCompletionMethod();
        this.prePassivate = ejbComponentCreateService.getPrePassivate();
        this.postActivate = ejbComponentCreateService.getPostActivate();
        this.methodAccessTimeouts = ejbComponentCreateService.getMethodApplicableAccessTimeouts();
        this.defaultAccessTimeoutProvider = ejbComponentCreateService.getDefaultAccessTimeoutService();
        this.ejb2XRemoveMethod = ejbComponentCreateService.getEjb2XRemoveMethod();
        this.serialiableInterceptorContextKeys = ejbComponentCreateService.getSerializableInterceptorContextKeys();
        this.cacheFactory = ejbComponentCreateService.getCacheFactory();
    }

    @Override
    public StatefulSessionComponentInstance createInstance() {
        return (StatefulSessionComponentInstance)super.createInstance();
    }

    public StatefulSessionComponentInstance createInstance(Object instance) {
        return (StatefulSessionComponentInstance)super.createInstance();
    }

    protected StatefulSessionComponentInstance constructComponentInstance(ManagedReference instance, boolean invokePostConstruct) {
        return (StatefulSessionComponentInstance)super.constructComponentInstance(instance, invokePostConstruct);
    }

    protected StatefulSessionComponentInstance constructComponentInstance(ManagedReference instance, boolean invokePostConstruct, Map<Object, Object> context) {
        return (StatefulSessionComponentInstance)super.constructComponentInstance(instance, invokePostConstruct, context);
    }

    protected SessionID getSessionIdOf(InterceptorContext ctx) {
        StatefulSessionComponentInstance instance = (StatefulSessionComponentInstance)ctx.getPrivateData(ComponentInstance.class);
        return instance.getId();
    }

    @Override
    public <T> T getBusinessObject(Class<T> businessInterface, InterceptorContext context) throws IllegalStateException {
        if (businessInterface == null) {
            throw EjbLogger.ROOT_LOGGER.businessInterfaceIsNull();
        }
        return this.createViewInstanceProxy(businessInterface, Collections.singletonMap(SessionID.class, this.getSessionIdOf(context)));
    }

    @Override
    public EJBLocalObject getEJBLocalObject(InterceptorContext ctx) throws IllegalStateException {
        if (this.getEjbLocalObjectViewServiceName() == null) {
            throw EjbLogger.ROOT_LOGGER.ejbLocalObjectUnavailable(this.getComponentName());
        }
        return this.createViewInstanceProxy(EJBLocalObject.class, Collections.singletonMap(SessionID.class, this.getSessionIdOf(ctx)), this.getEjbLocalObjectViewServiceName());
    }

    @Override
    public EJBObject getEJBObject(final InterceptorContext ctx) throws IllegalStateException {
        String locatorAppName;
        if (this.getEjbObjectViewServiceName() == null) {
            throw EjbLogger.ROOT_LOGGER.beanComponentMissingEjbObject(this.getComponentName(), "EJBObject");
        }
        ServiceController serviceController = StatefulSessionComponent.currentServiceContainer().getRequiredService(this.getEjbObjectViewServiceName());
        final ComponentView view = (ComponentView)serviceController.getValue();
        String string = locatorAppName = this.getEarApplicationName() == null ? "" : this.getEarApplicationName();
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<EJBObject>(){

                @Override
                public EJBObject run() {
                    return (EJBObject)EJBClient.createProxy((EJBLocator)new StatefulEJBLocator(view.getViewClass(), locatorAppName, StatefulSessionComponent.this.getModuleName(), StatefulSessionComponent.this.getComponentName(), StatefulSessionComponent.this.getDistinctName(), StatefulSessionComponent.this.getSessionIdOf(ctx), StatefulSessionComponent.this.getCache().getStrongAffinity()));
                }
            });
        }
        return (EJBObject)EJBClient.createProxy((EJBLocator)new StatefulEJBLocator(view.getViewClass(), locatorAppName, this.getModuleName(), this.getComponentName(), this.getDistinctName(), this.getSessionIdOf(ctx), this.getCache().getStrongAffinity()));
    }

    public AccessTimeoutDetails getAccessTimeout(Method method) {
        EJBBusinessMethod ejbMethod = new EJBBusinessMethod(method);
        AccessTimeoutDetails accessTimeout = this.methodAccessTimeouts.get(ejbMethod);
        if (accessTimeout != null) {
            return accessTimeout;
        }
        AccessTimeoutDetails timeout = (AccessTimeoutDetails)this.beanLevelAccessTimeout.get(method.getDeclaringClass().getName());
        if (timeout != null) {
            return timeout;
        }
        return this.defaultAccessTimeoutProvider.getDefaultAccessTimeout();
    }

    public SessionID createSession() {
        return this.cache.createStatefulSessionBean();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionID createSessionRemote() {
        SessionID sessionID;
        ControlPoint controlPoint = this.getControlPoint();
        if (controlPoint == null) {
            return this.createSession();
        }
        RunResult result = controlPoint.beginRequest();
        if (result == RunResult.REJECTED) {
            throw EjbLogger.ROOT_LOGGER.containerSuspended();
        }
        try {
            sessionID = this.createSession();
        }
        catch (Throwable throwable) {
            try {
                controlPoint.requestComplete();
                throw throwable;
            }
            catch (ComponentIsStoppedException | EJBComponentUnavailableException e) {
                throw e;
            }
            catch (Exception e) {
                throw new EJBException(e);
            }
        }
        controlPoint.requestComplete();
        return sessionID;
    }

    public StatefulSessionBeanCache<SessionID, StatefulSessionComponentInstance> getCache() {
        return this.cache;
    }

    protected BasicComponentInstance instantiateComponentInstance(Interceptor preDestroyInterceptor, Map<Method, Interceptor> methodInterceptors, Map<Object, Object> context) {
        StatefulSessionComponentInstance instance = new StatefulSessionComponentInstance(this, preDestroyInterceptor, methodInterceptors, context);
        for (Object key : this.serialiableInterceptorContextKeys) {
            instance.setInstanceData(key, context.get(key));
        }
        instance.setInstanceData(BasicComponentInstance.INSTANCE_KEY, context.get(BasicComponentInstance.INSTANCE_KEY));
        return instance;
    }

    public Interceptor getAfterBegin() {
        return this.afterBeginInterceptor;
    }

    public Interceptor getAfterCompletion() {
        return this.afterCompletionInterceptor;
    }

    public Interceptor getBeforeCompletion() {
        return this.beforeCompletionInterceptor;
    }

    public Method getAfterBeginMethod() {
        return this.afterBeginMethod;
    }

    public Method getAfterCompletionMethod() {
        return this.afterCompletionMethod;
    }

    public Method getBeforeCompletionMethod() {
        return this.beforeCompletionMethod;
    }

    public Interceptor getPrePassivate() {
        return this.prePassivateInterceptor;
    }

    public Interceptor getPostActivate() {
        return this.postActivateInterceptor;
    }

    public Interceptor getEjb2XRemoveMethod() {
        return this.ejb2XRemoveMethodInterceptor;
    }

    @Override
    public synchronized void init() {
        super.init();
        this.cache = this.cacheFactory.get().createStatefulBeanCache(new StatefulSessionBeanCacheConfiguration<SessionID, StatefulSessionComponentInstance>(){

            @Override
            public StatefulSessionBeanInstanceFactory<StatefulSessionComponentInstance> getInstanceFactory() {
                return StatefulSessionComponent.this;
            }

            @Override
            public Supplier<SessionID> getIdentifierFactory() {
                return IdentifierFactory.UUID;
            }

            @Override
            public Duration getTimeout() {
                StatefulComponentDescription description = (StatefulComponentDescription)StatefulSessionComponent.this.getComponentDescription();
                StatefulTimeoutInfo info = description.getStatefulTimeout();
                return info != null && info.getValue() >= 0L ? Duration.of(info.getValue(), info.getTimeUnit().toChronoUnit()) : null;
            }

            @Override
            public String getComponentName() {
                return StatefulSessionComponent.this.getComponentName();
            }
        });
        this.cache.start();
    }

    protected void createInterceptors(InterceptorFactoryContext context) {
        super.createInterceptors(context);
        if (this.afterBegin != null) {
            this.afterBeginInterceptor = this.afterBegin.create(context);
        }
        if (this.afterCompletion != null) {
            this.afterCompletionInterceptor = this.afterCompletion.create(context);
        }
        if (this.beforeCompletion != null) {
            this.beforeCompletionInterceptor = this.beforeCompletion.create(context);
        }
        if (this.prePassivate != null) {
            this.prePassivateInterceptor = this.prePassivate.create(context);
        }
        if (this.postActivate != null) {
            this.postActivateInterceptor = this.postActivate.create(context);
        }
        if (this.ejb2XRemoveMethod != null) {
            this.ejb2XRemoveMethodInterceptor = this.ejb2XRemoveMethod.create(context);
        }
    }

    @Override
    public void done() {
        this.cache.stop();
        this.cache = null;
        this.afterBeginInterceptor = null;
        this.afterCompletionInterceptor = null;
        this.beforeCompletionInterceptor = null;
        this.prePassivateInterceptor = null;
        this.postActivateInterceptor = null;
        this.ejb2XRemoveMethodInterceptor = null;
        super.done();
    }

    @Override
    public AllowedMethodsInformation getAllowedMethodsInformation() {
        return this.isBeanManagedTransaction() ? StatefulAllowedMethodsInformation.INSTANCE_BMT : StatefulAllowedMethodsInformation.INSTANCE_CMT;
    }

    public Set<Object> getSerialiableInterceptorContextKeys() {
        return this.serialiableInterceptorContextKeys;
    }

    private static ServiceContainer currentServiceContainer() {
        if (System.getSecurityManager() == null) {
            return CurrentServiceContainer.getServiceContainer();
        }
        return (ServiceContainer)AccessController.doPrivileged(CurrentServiceContainer.GET_ACTION);
    }

    public boolean isRemotable(Throwable throwable) {
        return this.cache.isRemotable(throwable);
    }

    public boolean shouldDiscard(Exception ex, Method method) {
        if (this.getApplicationException(ex.getClass(), method) != null || ex instanceof ConcurrentAccessTimeoutException || ex instanceof ConcurrentAccessException) {
            return false;
        }
        return !(ex instanceof RemoveException) && (ex instanceof RuntimeException || ex instanceof RemoteException);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum IdentifierFactory implements Supplier<SessionID>
    {
        UUID{

            @Override
            public SessionID get() {
                return new UUIDSessionID(java.util.UUID.randomUUID());
            }
        };

    }
}

