/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.wildfly.clustering.marshalling.protostream.Privileged;
import org.wildfly.clustering.marshalling.protostream.SerializationContext;
import org.wildfly.clustering.marshalling.protostream.SerializationContextInitializer;

public abstract class AbstractSerializationContextInitializer
implements SerializationContextInitializer {
    private final String resourceName;
    private final ClassLoader loader;

    protected AbstractSerializationContextInitializer() {
        this.resourceName = this.getClass().getPackage().getName() + ".proto";
        this.loader = Privileged.getClassLoader(this.getClass());
    }

    protected AbstractSerializationContextInitializer(String resourceName) {
        this.resourceName = resourceName;
        this.loader = Privileged.getClassLoader(this.getClass());
    }

    protected AbstractSerializationContextInitializer(String resourceName, Class<?> containingClass) {
        this.resourceName = resourceName;
        this.loader = Privileged.getClassLoader(containingClass);
    }

    @Override
    public void registerSchema(SerializationContext context) {
        try {
            context.registerProtoFiles(AbstractSerializationContextInitializer.getFileDescriptorSource(this.loader, this.resourceName));
        }
        catch (DescriptorParserException e) {
            try {
                context.unregisterProtoFile(this.resourceName);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            throw e;
        }
    }

    public String toString() {
        return this.resourceName;
    }

    private static FileDescriptorSource getFileDescriptorSource(final ClassLoader loader, final String resourceName) {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<FileDescriptorSource>(){

                @Override
                public FileDescriptorSource run() throws Exception {
                    return FileDescriptorSource.fromResources((ClassLoader)loader, (String[])new String[]{resourceName});
                }
            });
        }
        catch (PrivilegedActionException e) {
            Exception exception = e.getException();
            if (exception instanceof IOException) {
                throw new UncheckedIOException((IOException)exception);
            }
            throw new RuntimeException(exception);
        }
    }
}

