/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.AbstractElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchVectorFieldCodec;
import org.hibernate.search.engine.backend.types.VectorSimilarity;

public abstract class AbstractElasticsearchVectorFieldCodec<F>
extends AbstractElasticsearchFieldCodec<F>
implements ElasticsearchVectorFieldCodec<F> {
    protected final VectorSimilarity similarity;
    protected final int dimension;
    private final Integer m;
    private final Integer efConstruction;
    private final F indexNullAs;

    protected AbstractElasticsearchVectorFieldCodec(Gson gson, VectorSimilarity similarity, int dimension, Integer m, Integer efConstruction, F indexNullAs) {
        super(gson);
        this.similarity = similarity;
        this.dimension = dimension;
        this.m = m;
        this.efConstruction = efConstruction;
        this.indexNullAs = indexNullAs;
    }

    @Override
    public JsonElement encode(F value) {
        if (value == null) {
            if (this.indexNullAs == null) {
                return JsonNull.INSTANCE;
            }
            value = this.indexNullAs;
        }
        return this.toJsonArray(value);
    }

    protected abstract JsonArray toJsonArray(F var1);

    @Override
    public F decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return this.fromJsonArray(JsonElementTypes.ARRAY.fromElement(element));
    }

    protected abstract F fromJsonArray(JsonArray var1);

    @Override
    public int getConfiguredDimensions() {
        return this.dimension;
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractElasticsearchVectorFieldCodec that = (AbstractElasticsearchVectorFieldCodec)other;
        return this.dimension == that.dimension && Objects.equals(this.similarity, that.similarity) && Objects.equals(this.m, that.m) && Objects.equals(this.efConstruction, that.efConstruction);
    }

    @Override
    public boolean canDecodeArrays() {
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{vectorSimilarity=" + String.valueOf(this.similarity) + ", dimension=" + this.dimension + ", efConstruction=" + this.efConstruction + ", m=" + this.m + "}";
    }
}

