/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.Gson;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.AbstractElasticsearchJavaTimeFieldCodec;

public class ElasticsearchInstantFieldCodec
extends AbstractElasticsearchJavaTimeFieldCodec<Instant> {
    public ElasticsearchInstantFieldCodec(Gson gson, DateTimeFormatter delegate) {
        super(gson, delegate);
    }

    @Override
    protected String nullUnsafeFormat(Instant value) {
        return this.formatter.format(value.atOffset(ZoneOffset.UTC));
    }

    @Override
    protected Instant nullUnsafeParse(String stringValue) {
        return this.formatter.parse((CharSequence)stringValue, OffsetDateTime::from).toInstant();
    }

    @Override
    protected Long nullUnsafeScalar(Instant value) {
        return value.toEpochMilli();
    }
}

