/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import java.util.function.Function;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyWriteAttributeHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.picketlink.common.model.validator.ModelValidationStepHandler;
import org.wildfly.extension.picketlink.idm.model.PartitionManagerResourceDefinition;

public class IDMConfigWriteAttributeHandler
extends ModelOnlyWriteAttributeHandler {
    private final ModelValidationStepHandler[] modelValidators;
    private final Function<PathAddress, PathAddress> partitionAddressProvider;

    IDMConfigWriteAttributeHandler(ModelValidationStepHandler[] modelValidators, Function<PathAddress, PathAddress> partitionAddressProvider, AttributeDefinition ... attributes) {
        super(attributes);
        this.modelValidators = modelValidators;
        this.partitionAddressProvider = partitionAddressProvider;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (this.modelValidators != null) {
            for (ModelValidationStepHandler validator : this.modelValidators) {
                context.addStep((OperationStepHandler)validator, OperationContext.Stage.MODEL);
            }
        }
        if (this.partitionAddressProvider != null) {
            context.addStep((context1, operation1) -> PartitionManagerResourceDefinition.validateModel(context, this.partitionAddressProvider.apply(context1.getCurrentAddress())), OperationContext.Stage.MODEL);
        }
        super.execute(context, operation);
    }
}

