/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.module;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.as.server.deployment.SimpleAttachable;
import org.jboss.as.server.deployment.module.ModuleAliasChecker;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.security.PermissionFactory;

public class ModuleSpecification
extends SimpleAttachable {
    private final Set<ModuleDependency> systemDependenciesSet = new LinkedHashSet<ModuleDependency>();
    private final Set<ModuleDependency> localDependenciesSet = new LinkedHashSet<ModuleDependency>();
    private boolean localDependenciesTransitive;
    private final Set<ModuleDependency> userDependenciesSet = new CopyOnWriteArraySet<ModuleDependency>();
    private final List<ResourceLoaderSpec> resourceLoaders = new ArrayList<ResourceLoaderSpec>();
    private final List<String> classTransformers = new ArrayList<String>();
    private volatile List<ModuleDependency> allDependencies = null;
    private final Set<String> exclusions = new HashSet<String>();
    private final HashMap<String, List<String>> exclusionsMap = new HashMap();
    private final Set<String> excludedDependencies = new HashSet<String>();
    private boolean subDeploymentModulesIsolated;
    private boolean exclusionsCascadedToSubDeployments;
    private boolean privateModule;
    private boolean publicModule;
    private boolean localLast;
    private final Set<String> aliases = new LinkedHashSet<String>();
    private final List<DependencySpec> moduleSystemDependencies = new ArrayList<DependencySpec>();
    private final List<PermissionFactory> permissionFactories = new ArrayList<PermissionFactory>();

    public void addSystemDependency(ModuleDependency dependency) {
        if (!this.exclusions.contains(dependency.getDependencyModule())) {
            if (this.systemDependenciesSet.add(dependency)) {
                this.resetDependencyLists();
            }
        } else {
            this.excludedDependencies.add(dependency.getDependencyModule());
        }
    }

    public void addSystemDependencies(Collection<ModuleDependency> dependencies) {
        for (ModuleDependency dependency : dependencies) {
            this.addSystemDependency(dependency);
        }
    }

    public void addUserDependency(ModuleDependency dependency) {
        if (this.userDependenciesSet.add(dependency)) {
            this.resetDependencyLists();
        }
    }

    public void addUserDependencies(Collection<ModuleDependency> dependencies) {
        for (ModuleDependency dependency : dependencies) {
            this.addUserDependency(dependency);
        }
    }

    public void removeUserDependencies(Predicate<ModuleDependency> predicate) {
        Iterator<ModuleDependency> iter = this.userDependenciesSet.iterator();
        HashSet<ModuleDependency> toRemove = null;
        for (ModuleDependency md : this.userDependenciesSet) {
            if (!predicate.test(md)) continue;
            if (toRemove == null) {
                toRemove = new HashSet<ModuleDependency>();
            }
            toRemove.add(md);
        }
        if (toRemove != null) {
            this.userDependenciesSet.removeAll(toRemove);
            this.resetDependencyLists();
        }
    }

    public void addLocalDependency(ModuleDependency dependency) {
        if (!this.exclusions.contains(dependency.getDependencyModule())) {
            if (this.localDependenciesSet.add(dependency)) {
                this.resetDependencyLists();
            }
        } else {
            this.excludedDependencies.add(dependency.getDependencyModule());
        }
    }

    public void addLocalDependencies(Collection<ModuleDependency> dependencies) {
        for (ModuleDependency dependency : dependencies) {
            this.addLocalDependency(dependency);
        }
    }

    public Set<ModuleDependency> getSystemDependenciesSet() {
        return Collections.unmodifiableSet(this.systemDependenciesSet);
    }

    @Deprecated(forRemoval=true)
    public void addExclusion(ModuleIdentifier exclusion) {
        this.addModuleExclusion(exclusion.toString());
    }

    public void addModuleExclusion(String exclusion) {
        ModuleDependency dep;
        String targetModule = ModuleAliasChecker.getTargetModule(exclusion);
        if (targetModule != null) {
            List aliases = this.exclusionsMap.computeIfAbsent(targetModule, k -> new ArrayList());
            aliases.add(exclusion);
        } else {
            this.exclusionsMap.putIfAbsent(exclusion, new ArrayList());
        }
        this.exclusions.add(exclusion);
        Iterator<ModuleDependency> it = this.systemDependenciesSet.iterator();
        while (it.hasNext()) {
            dep = it.next();
            if (!dep.getDependencyModule().equals(exclusion)) continue;
            it.remove();
            this.resetDependencyLists();
        }
        it = this.localDependenciesSet.iterator();
        while (it.hasNext()) {
            dep = it.next();
            if (!dep.getDependencyModule().equals(exclusion)) continue;
            it.remove();
            this.resetDependencyLists();
        }
    }

    @Deprecated(forRemoval=true)
    public void addExclusions(Iterable<ModuleIdentifier> exclusions) {
        for (ModuleIdentifier exclusion : exclusions) {
            this.addExclusion(exclusion);
        }
    }

    public Set<ModuleDependency> getLocalDependenciesSet() {
        return Collections.unmodifiableSet(this.localDependenciesSet);
    }

    public Set<ModuleDependency> getUserDependenciesSet() {
        return Collections.unmodifiableSet(this.userDependenciesSet);
    }

    public void addResourceLoader(ResourceLoaderSpec resourceLoader) {
        this.resourceLoaders.add(resourceLoader);
    }

    public List<ResourceLoaderSpec> getResourceLoaders() {
        return Collections.unmodifiableList(this.resourceLoaders);
    }

    public void addClassTransformer(String classTransformer) {
        this.classTransformers.add(classTransformer);
    }

    public List<String> getClassTransformers() {
        return Collections.unmodifiableList(this.classTransformers);
    }

    public boolean isSubDeploymentModulesIsolated() {
        return this.subDeploymentModulesIsolated;
    }

    public void setSubDeploymentModulesIsolated(boolean subDeploymentModulesIsolated) {
        this.subDeploymentModulesIsolated = subDeploymentModulesIsolated;
    }

    public boolean isExclusionsCascadedToSubDeployments() {
        return this.exclusionsCascadedToSubDeployments;
    }

    public void setExclusionsCascadedToSubDeployments(boolean exclusionsCascadedToSubDeployments) {
        this.exclusionsCascadedToSubDeployments = exclusionsCascadedToSubDeployments;
    }

    public boolean isPrivateModule() {
        return this.privateModule;
    }

    public void setPrivateModule(boolean privateModule) {
        this.privateModule = privateModule;
    }

    public boolean isPublicModule() {
        return this.publicModule;
    }

    public void setPublicModule(boolean publicModule) {
        this.publicModule = publicModule;
    }

    public boolean isLocalDependenciesTransitive() {
        return this.localDependenciesTransitive;
    }

    public void setLocalDependenciesTransitive(boolean localDependenciesTransitive) {
        this.localDependenciesTransitive = localDependenciesTransitive;
    }

    public boolean isLocalLast() {
        return this.localLast;
    }

    public void setLocalLast(boolean localLast) {
        this.localLast = localLast;
    }

    @Deprecated(forRemoval=true)
    public void addAlias(ModuleIdentifier moduleIdentifier) {
        this.addModuleAlias(moduleIdentifier.toString());
    }

    public void addModuleAlias(String moduleIdentifier) {
        this.aliases.add(moduleIdentifier);
    }

    @Deprecated(forRemoval=true)
    public void addAliases(Collection<ModuleIdentifier> moduleIdentifiers) {
        for (ModuleIdentifier id : moduleIdentifiers) {
            this.addModuleAlias(id.toString());
        }
    }

    @Deprecated(forRemoval=true)
    public List<ModuleIdentifier> getAliases() {
        return this.aliases.stream().map(ModuleIdentifier::fromString).collect(Collectors.toList());
    }

    public Set<String> getModuleAliases() {
        return this.aliases;
    }

    public List<ModuleDependency> getAllDependencies() {
        if (this.allDependencies == null) {
            this.allDependencies = new ArrayList<ModuleDependency>();
            this.allDependencies.addAll(this.systemDependenciesSet);
            this.allDependencies.addAll(this.userDependenciesSet);
            this.allDependencies.addAll(this.localDependenciesSet);
        }
        return this.allDependencies;
    }

    public void addModuleSystemDependencies(List<DependencySpec> systemDependencies) {
        this.moduleSystemDependencies.addAll(systemDependencies);
    }

    public List<DependencySpec> getModuleSystemDependencies() {
        return Collections.unmodifiableList(this.moduleSystemDependencies);
    }

    public void addPermissionFactory(PermissionFactory permissionFactory) {
        this.permissionFactories.add(permissionFactory);
    }

    public List<PermissionFactory> getPermissionFactories() {
        return this.permissionFactories;
    }

    @Deprecated(forRemoval=true)
    public Set<ModuleIdentifier> getNonexistentExcludedDependencies() {
        return this.getFictitiousExcludedDependencies().stream().map(ModuleIdentifier::fromString).collect(Collectors.toSet());
    }

    public Set<String> getFictitiousExcludedDependencies() {
        HashSet<String> unExcludedModuleExclusion = new HashSet<String>(this.exclusions);
        block0: for (String identifier : this.excludedDependencies) {
            for (Map.Entry<String, List<String>> entry : this.exclusionsMap.entrySet()) {
                if (!entry.getKey().equals(identifier) && !entry.getValue().contains(identifier)) continue;
                unExcludedModuleExclusion.remove(entry.getKey());
                entry.getValue().forEach(unExcludedModuleExclusion::remove);
                continue block0;
            }
        }
        return unExcludedModuleExclusion;
    }

    private void resetDependencyLists() {
        this.allDependencies = null;
    }
}

